package com.kdgc.framework.web.common;

import java.util.ArrayList;
import java.util.List;

/*******************************************************************************
 * 功能说明: 带复选框的树节点类
 * @author lchen
 * 
 ******************************************************************************/

public class ComBoxTreeNode implements java.io.Serializable {
	
	private static final long serialVersionUID = 1L;
	private String id;//id 节点的VALUE
	private String text;// 节点显示的文字
	private String iconCls;//节点的图标
	private boolean checked;//节点的选中状态
	private List<ComBoxTreeNode> children;//节点的子节点(异步加载时为空)
	private boolean expanded;//节点的展开状态
	private boolean leaf;   //是否叶子节点
	private int orderBy;
	
	public ComBoxTreeNode(){
		
	}
	public ComBoxTreeNode(String id, String text) {
		this.id = id;
		this.text = text;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public String getIconCls() {
		return iconCls;
	}
	public void setIconCls(String iconCls) {
		this.iconCls = iconCls;
	}
	public boolean isChecked() {
		return checked;
	}
	public void setChecked(boolean checked) {
		this.checked = checked;
	}
	public List<ComBoxTreeNode> getChildren() {
		return children;
	}
	public void setChildren(List<ComBoxTreeNode> children) {
		this.children = children;
	}
	public void addChild(ComBoxTreeNode node) {
		if(children==null){
			children=new ArrayList<ComBoxTreeNode>();
		}
		children.add(node);
	}
	
	public boolean isExpanded() {
		return expanded;
	}
	public void setExpanded(boolean expanded) {
		this.expanded = expanded;
	}
	
	public boolean isLeaf() {
		return leaf;
	}
	public void setLeaf(boolean leaf) {
		this.leaf = leaf;
	}
	public int getOrderBy() {
		return orderBy;
	}
	public void setOrderBy(int orderBy) {
		this.orderBy = orderBy;
	}
}
