package com.kdgc.framework.modules.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
public class OgnlUtil
{
    /**
     * 可以用于判断String,Map,Collection,Array是否为空
     * 
     * @param o
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static boolean isEmpty(Object o) throws IllegalArgumentException
    {
        if (o == null)
            return true;

        if (o instanceof String)
        {
            if (((String) o).length() == 0)
            {
                return true;
            }
        }
        else if (o instanceof Collection)
        {
            if (((Collection) o).isEmpty())
            {
                return true;
            }
        }
        else if (o.getClass().isArray())
        {
            if (Array.getLength(o) == 0)
            {
                return true;
            }
        }
        else if (o instanceof Map)
        {
            if (((Map) o).isEmpty())
            {
                return true;
            }
        }
        else
        {
            return false;
            // throw new
            // IllegalArgumentException("Illegal argument type,must be : Map,Collection,Array,String. but was:"+o.getClass());
        }

        return false;
    }

    /**
     * 判断数组长度是否大于1
     * 
     * @param o
     * @return
     * @throws IllegalArgumentException
     */
    @SuppressWarnings("rawtypes")
    public static boolean iflenthMoreThanOne(Object o, boolean flag) throws IllegalArgumentException
    {
        if (o == null)
            return false;

        if (o instanceof String)
        {
            if (flag)
            {
                if (((String) o).length() > 1)
                {
                    return true;
                }
            }
            else
            {
                if (((String) o).length() == 1)
                {
                    return true;
                }
            }
        }
        else if (o instanceof Collection)
        {
            if (flag)
            {
                if (((Collection) o).size() > 1)
                {
                    return true;
                }
            }
            else
            {
                if (((Collection) o).size() == 1)
                {
                    return true;
                }
            }
        }
        else if (o.getClass().isArray())
        {
            if (flag)
            {
                if (Array.getLength(o) > 1)
                {
                    return true;
                }
            }
            else
            {
                if (Array.getLength(o) == 1)
                {
                    return true;
                }
            }
        }
        else if (o instanceof Map)
        {
            if (flag)
            {
                if (((Map) o).size() > 1)
                {
                    return true;
                }
            }
            else
            {
                if (((Map) o).size() == 1)
                {
                    return true;
                }
            }
        }
        else
        {
            return false;
            // throw new
            // IllegalArgumentException("Illegal argument type,must be : Map,Collection,Array,String. but was:"+o.getClass());
        }

        return false;
    }

    /**
     * 可以用于判断 Map,Collection,String,Array是否不为空
     * 
     * @param c
     * @return
     */
    public static boolean isNotEmpty(Object o)
    {
        return !isEmpty(o);
    }

    public static boolean isNotBlank(Object o)
    {
        return !isBlank(o);
    }
    /**
     * 判断对象不能为空、null
     * @param o
     * @return
     */
    public static boolean isNotEmptyAndNull(Object o)
    {
        return isNotEmpty(o) && isNotBlank(o);
    }

    public static boolean isNumber(Object o)
    {
        if (o == null)
            return false;
        if (o instanceof Number)
        {
            return true;
        }
        if (o instanceof String)
        {
            String str = (String) o;
            if (str.length() == 0)
                return false;
            if (str.trim().length() == 0)
                return false;
            return org.apache.commons.lang3.StringUtils.isNumeric(str);
        }
        return false;
    }

    public static boolean isBlank(Object o)
    {
        if (o == null || o.equals("null"))
            return true;
        if (o instanceof String)
        {
            String str = (String) o;        
            return isBlank(str);
        }
        return false;
    }

    public static boolean isBlank(String str)
    {
        if (str == null || str.length() == 0)
        {
            return true;
        }

        for (int i = 0; i < str.length(); i++)
        {
            if (!Character.isWhitespace(str.charAt(i)))
            {
                return false;
            }
        }
        return true;
    }
}
