package com.kdgc.framework.modules.utils;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang3.reflect.FieldUtils;

/**
 * 枚举工具类
 * 
 */
public final class EnumUtil {
    /**
     * 根据枚举类名和key 值返回对应的枚举
     * 
     * @param enumClass
     * @param key
     * @return
     */
    public static <E extends Enum<E>> E valueOfEnum(Class<E> enumClass,
            String key) {
        if (null == enumClass) {
            throw new IllegalArgumentException("enumClass" + "不能为空！");
        }
        if (null == key || "".equals(key)) {
            throw new IllegalArgumentException("key" + "不能为空！");
        }
        Field keyField = FieldUtils.getField(enumClass, "key", true);
        Field valueField = FieldUtils.getField(enumClass, "value", true);
        if (keyField == null || valueField == null) {
            throw new IllegalArgumentException("enumClass中没有key或者没有value字段!");
        }
        E[] enums = enumClass.getEnumConstants();
        for (E e : enums) {
            String key_ = null;
            try {
                key_ = (String) FieldUtils.readField(e, "key", true);
            } catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
            if (key_ != null && !"".equals(key_) && key_.equals(key)) {
                return e;
            }
        }
        return null;
    }

    /**
     * 根据枚举类名和key 值返回key 对应的value值
     * 
     * @param enumClass
     * @param key
     * @return
     */
    public static <E extends Enum<E>> String valueOfString(Class<E> enumClass,
            String key) {
        if (null == enumClass) {
            throw new IllegalArgumentException("enumClass" + "不能为空！");
        }
        if (null == key || "".equals(key)) {
            throw new IllegalArgumentException("key" + "不能为空！");
        }

        Field keyField = FieldUtils.getField(enumClass, "key", true);
        Field valueField = FieldUtils.getField(enumClass, "value", true);
        if (keyField == null || valueField == null) {
            throw new IllegalArgumentException("enumClass中没有key或者没有value字段!");
        }
        E[] enums = enumClass.getEnumConstants();
        for (E e : enums) {
            String key_;
            try {
                key_ = (String) FieldUtils.readField(e, "key", true);
                if (key_ != null && !"".equals(key_) && key_.equals(key)) {
                    return (String) FieldUtils.readField(e, "value", true);
                }
            } catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }

        }
        return null;
    }

    /**
     * 返回map
     * 
     * @param enumClass
     * @return
     */
    public static <E extends Enum<E>> Map<String, String> getEnumMap(
            Class<E> enumClass) {
        if (null == enumClass) {
            throw new IllegalArgumentException("enumClass" + "不能为空！");
        }
        Field keyField = FieldUtils.getField(enumClass, "key", true);
        Field valueField = FieldUtils.getField(enumClass, "value", true);
        if (keyField == null || valueField == null) {
            throw new IllegalArgumentException("enumClass中没有key或者没有value字段!");
        }
        Map<String, String> map = new LinkedHashMap<String, String>();

        for (E e : enumClass.getEnumConstants()) {
            String key_;
            String value_;
            try {
                key_ = (String) FieldUtils.readField(e, "key", true);
                value_ = (String) FieldUtils.readField(e, "value", true);
                map.put(key_, value_);
            } catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
        }
        return map;
    }

    public static String toString(Enum<?> enumClass) {
        try {
            return enumClass.ordinal() + "," + enumClass.name() + ","
                    + FieldUtils.readField(enumClass, "key", true) + ","
                    + FieldUtils.readField(enumClass, "value", true);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        /*System.out.println(EnumUtil.valueOfEnum(ErrorCodeEnum.class, "1"));
        System.out.println(EnumUtil.valueOfString(ErrorCodeEnum.class, "1"));
        System.out.println(EnumUtil.getEnumMap(ErrorCodeEnum.class));
        System.out.println(EnumUtil.toString(ErrorCodeEnum.dbEx));*/
    }

}
