package com.kdgc.framework.dao.support;

import com.kdgc.framework.dao.model.IdEntity;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

import java.util.Date;

/**
 * Listener - 创建日期、修改日期处理
 */
public class EntityListener {

	/**
	 * 保存前处理
	 * 
	 * @param entity
	 *            基类
	 */
	@PrePersist
	public void prePersist(IdEntity entity) {
		entity.setCreateDate(new Date());
		entity.setModifyDate(new Date());
	}

	/**
	 * 更新前处理
	 * 
	 * @param entity
	 *            基类
	 */
	@PreUpdate
	public void preUpdate(IdEntity entity) {
		entity.setModifyDate(new Date());
	}

}