package com.kdgc.framework.dao.key.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

import com.kdgc.framework.dao.key.CacheValue;
import com.kdgc.framework.dao.key.UniqueTableApp;
import com.kdgc.framework.modules.exception.DBAccessException;

public class DefaultUniqueTableApp implements UniqueTableApp
{
private static final Logger logger = LoggerFactory.getLogger(DefaultUniqueTableApp.class);
protected String selectSQL = null;
protected String updateSQL = null;
protected String insertSQL = null;


protected JdbcTemplate jdbcTemplate = null;

public DefaultUniqueTableApp(JdbcTemplate jdbcTemplate) {
  this.jdbcTemplate = jdbcTemplate;

  this.selectSQL = "SELECT code FROM FW_PRIMARYKEY WHERE name = ? FOR UPDATE";
  this.updateSQL = "UPDATE FW_PRIMARYKEY SET code = code + ? WHERE name = ? ";
  this.insertSQL = "INSERT INTO FW_PRIMARYKEY (code, name) VALUES (?, ?)";
}

public CacheValue getCacheValue(int cacheNum, String name) {
  Assert.isTrue(TransactionSynchronizationManager.isSynchronizationActive(), 
    "Transaction must be running");

  CacheValue cache = null;
  try {
    cache = getCurrCode(name);

    if (cache == null) {
      insert(name);
      cache = getCurrCode(name);
    }

    update(cacheNum, name);
    cache.setMaxVal(cache.getMinVal() + cacheNum);
  } catch (Exception e) {
    logger.error("获取主键失败", e);
  }
  return cache;
}

private CacheValue getCurrCode(String name) {
  CacheValue value = null;
  try {
    Long code = Long.valueOf(this.jdbcTemplate.queryForLong(this.selectSQL, new Object[] { name }));
    value = new CacheValue();
    value.setMinVal(code.longValue() + 1L);
  } catch (EmptyResultDataAccessException e) {
    logger.debug(name + " 没有找到记录");
  } catch (Exception e) {
    throw new DBAccessException(name + " 获取主键失败");
  }
  return value;
}

private void insert(String name) {
  this.jdbcTemplate.update(this.insertSQL, new Object[] { Integer.valueOf(0), name });
}

private void update(int cacheNum, String name) {
  this.jdbcTemplate.update(this.updateSQL, new Object[] { Integer.valueOf(cacheNum), name });
}

public void setSelectSQL(String selectSQL)
{
  this.selectSQL = selectSQL;
}

public void setUpdateSQL(String updateSQL)
{
  this.updateSQL = updateSQL;
}

public void setInsertSQL(String insertSQL)
{
  this.insertSQL = insertSQL;
}

public void setJdbcTemplate(JdbcTemplate jdbcTemplate)
{
  this.jdbcTemplate = jdbcTemplate;
}
}
