package com.kdgc.framework.dao.key;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.support.TransactionTemplate;

public class SequenceFactory
  implements ApplicationContextAware
{
  private static Map<String, SingleSequence> singleSequenceMap = new ConcurrentHashMap();
  private static SequenceFactory factory;
  private TransactionTemplate transactionTemplate;
  private UniqueTableApp uniqueTableApp;
  private ApplicationContext context;
  private int cacheKeyNum = 10;

  public static SingleSequence getSequence(String name)
  {
    SingleSequence sequence = (SingleSequence)singleSequenceMap.get(name);
    if (sequence == null) {
      synchronized (SequenceFactory.class) {
        if (sequence == null) {
          sequence = factory.createSequence(name);
          singleSequenceMap.put(name, sequence);
        }
      }
    }
    return sequence;
  }

  private SingleSequence createSequence(String name) {
    int cacheNum = getCacheKeyNum();
    SingleSequence sequence = new SingleSequence(cacheNum, this.uniqueTableApp, this.transactionTemplate);
    return sequence;
  }

  public void setUniqueTableApp(UniqueTableApp uniqueTableApp) {
    this.uniqueTableApp = uniqueTableApp;
  }

  public void setApplicationContext(ApplicationContext applicationContext)
    throws BeansException
  {
    this.context = applicationContext;
    factory = (SequenceFactory)this.context.getBean(SequenceFactory.class);
  }

  public int getCacheKeyNum() {
    return this.cacheKeyNum;
  }

  public void setCacheKeyNum(int cacheKeyNum) {
    this.cacheKeyNum = cacheKeyNum;
  }

  public TransactionTemplate getTransactionTemplate() {
    return this.transactionTemplate;
  }

  public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
    this.transactionTemplate = transactionTemplate;
  }
}