package com.kdgc.framework.core.support;

import java.lang.reflect.Method;
import java.util.Calendar;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import com.kdgc.framework.modules.security.shiro.Principal;
import com.kdgc.framework.web.common.utils.AjaxUtil;
import com.kdgc.framework.web.entity.admin.FwOpMonitor;
import com.kdgc.framework.web.service.admin.IFwOpMonitorService;

public class TraceInterceptor implements MethodInterceptor{

	@Autowired(required = true)
	private HttpServletRequest request;
	
	@Resource(name="FwOpMonitorServiceImpl")
	private IFwOpMonitorService fwOpMonitorService;
	
	@Value("${monitor.log}")
	private boolean isMonitor;
	
	/**
	 * 对拦截的方法进行监控日志处理
	 * @param mAnnotation 方法的监控注解
	 * @param startDate   方法执行起始时间
	 * @param totalTime   方法执行的总时间
	 * @param result      方法执行的结果，成功或失败
	 */
	//protected abstract void setMonitorLogInfo(MonitorAnnotation mAnnotation,long startDate,long totalTime,boolean result);
	
	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Logger logger=LoggerFactory.getLogger(invocation.getClass());
		boolean result=true;
		long startTime = System.currentTimeMillis();
		try {
			logger.info("------------【"+invocation.getMethod().getName()+"】:BEGIN!--(cpi-framework)------------");
			logger.info("Class 名称："+invocation.getMethod().getDeclaringClass().getName());
			 Class[] clazz= invocation.getMethod().getParameterTypes();
			 for(int i=0;i<clazz.length;i++){
				 logger.info("arg["+i+"]类型: "+clazz[i]);
			 }
			return invocation.proceed();
		} catch (Exception e) {
			logger.error("Error happened in class {},in method {}",invocation.getMethod().getDeclaringClass().getName(),invocation.getMethod().getName());
			Object[] argus=invocation.getArguments();
			for(int i=0;i<argus.length;i++){
				logger.error("arg["+i+"]: "+argus[i]);
			}
			result=false;
			throw e;
		}finally{
			logger.info("------------【"+invocation.getMethod().getName()+"】:END!--(cpi-framework)------------");
			if(isMonitor){
				afterInvoke(invocation.getMethod(),startTime, result);
			}		
		}
	}
	
	public void afterInvoke(Method method,long startTime,boolean result){
		MonitorAnnotation mAnnotation= method.getAnnotation(MonitorAnnotation.class);
		if(null!=mAnnotation){
			FwOpMonitor opLog=new FwOpMonitor();
			opLog.setOpActioname(mAnnotation.actionName());
			opLog.setOpContent(mAnnotation.methodDescr());
			opLog.setOpResult(result);
			opLog.setOpOptime(Calendar.getInstance().getTime());
			opLog.setOpTotaltime(opLog.getOpOptime().getTime() -startTime);
			opLog.setOpUrl(request.getRequestURI());
			opLog.setOpIp(AjaxUtil.getIpAddr(request));		
			Subject subject = SecurityUtils.getSubject();
			if (subject != null) {
				Principal principal = (Principal) subject.getPrincipal();
				if (principal != null) {
					  opLog.setOpUserid(principal.getId());
				      opLog.setOpUsername(principal.getLoginName());
				}
			}
	      //保存操作日志信息到数据库中
		  fwOpMonitorService.save(opLog);
		}
	}
	
}
