package com.kdgc.framework.core.spring;

import java.util.List;
import java.util.Map;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.view.AbstractView;

public class JXLSExcelView extends AbstractView
{
  public static final String EXCEL_EXPORT_FILE_NAME = "ExcelExportFileName";
  public static final String EXCEL_TEMPLATE_FILE_NAME = "ExcelTemplateFileName";
  public static final String EXCEL_SHEET_NAMES = "ExcelSheetNames";
  public static final String MUTIL_SHEET_DATA_KEY = "MutilSheetDataKey";
  private static final String CONTENT_TYPE = "application/vnd.ms-excel";
  private XLSTransformerExt transformer;

  public JXLSExcelView()
  {
    this.transformer = new XLSTransformerExt();
    setContentType(JXLSExcelView.CONTENT_TYPE);
  }

  protected boolean generatesDownloadContent()
  {
    return true;
  }

  protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response)
    throws Exception
  {
    String fileName = (String)model.get(JXLSExcelView.EXCEL_EXPORT_FILE_NAME);
    String templateName = (String)model.get(JXLSExcelView.EXCEL_TEMPLATE_FILE_NAME);
    List newSheetNames = (List)model.get(JXLSExcelView.EXCEL_SHEET_NAMES);

    response.setHeader("content-disposition", "attachment; filename=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));

    String srcFilePath = "/static/resources/excel/" + templateName;

    ServletOutputStream out = response.getOutputStream();

    if (newSheetNames == null)
      this.transformer.transformXLS(request.getSession().getServletContext(), srcFilePath, model, out);
    else {
      this.transformer.transformMultipleSheetsList(srcFilePath, (List)model.get(JXLSExcelView.MUTIL_SHEET_DATA_KEY), newSheetNames, out);
    }

    out.flush();
  }
}