
var wfConfirmPersonsGrid = $("#wfConfirmPersonsGrid");
$(function(){
	initWfConfirmPersonsGrid();
	bindEnterKey("#groupNameQuery",searchWfConfirmPersons);
});


/**
 * 初始化
 */
function initWfConfirmPersonsGrid(){
	wfConfirmPersonsGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#wfConfirmPersonsGridTbar",
	    url:ctx+'/wfConfirmPersons/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="wfConfirmPersonsFormDetail('+row.confirmId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
			{field:'groupName',title:'组名称',width:200,align:'center',halign:"center"},
			{field:'affirmWayText',title:'确认方式',width:200,align:'center',halign:"center"},
			{field:'remark',title:'备注',width:200,align:'center',halign:"center"},
			{field:'isEnableText',title:'是否启用',width:200,align:'center',halign:"center"}

	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			wfConfirmPersonsFormDetail(row.confirmId);
	    }
	});
	
    wfConfirmPersonsGrid.datagrid('doCellTip');
    var pager = wfConfirmPersonsGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('wfConfirmPersonsGrid',"流程审批二次确认人员维护")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function wfConfirmPersonsFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=WfConfirmPersons&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadWfConfirmPersons(){
	wfConfirmPersonsGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchWfConfirmPersons(){
	wfConfirmPersonsGrid.datagrid('load',{
		groupName : $("#groupNameQuery").textbox("getValue"),
		affirmWay : $("#affirmWayQuery").combobox("getValue")
	});
}


/**
 * 增加
 */
function addWfConfirmPersons() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=WfConfirmPersons",
		submiturl : "/wfConfirmPersons/saveWfConfirmPersons?formcode=WfConfirmPersons",
		callback : reloadWfConfirmPersons
	});
	
}


/**
 * 修改
 */
function editWfConfirmPersons() {

	var row = wfConfirmPersonsGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=WfConfirmPersons&id=" + row.confirmId,
		submiturl:"/wfConfirmPersons/saveWfConfirmPersons?formcode=WfConfirmPersons",
		callback : reloadWfConfirmPersons
	});
}


/**
 * 删除
 */
function delWfConfirmPersons() {

	var row = wfConfirmPersonsGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/wfConfirmPersons/delWfConfirmPersons",
				data : {
					id : row.confirmId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						wfConfirmPersonsGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
}

function showMultiFlowWin() {
	return function () {
		showMultiFlowWinFun(this)
	}
}
function showMultiFlowWinFun(that) {
	if (!that) {
		that = this;
	}
	var inputobj = formatterInputobj(that);
	var names = $('#' + inputobj.inputText).val();
	var ids = $('#' + inputobj.inputId).val();
	openChooseDialog({
		title: '选择流程',
		contenturl: '/view/sys/workFlowMultiSelectWin',
		width: 970,
		height: 560,
		okhandler: function () {
			var rows = $('#choosegrid').datagrid('getRows');
			if (rows) {
				var conids = [];
				var connames = [];
				for (var i = 0; i < rows.length; i++) {
					conids.push(rows[i].resId);
					connames.push(rows[i].flowText);
				}
				$('#' + inputobj.inputId).val(conids);
				$('#' + inputobj.inputText).textbox('setValue', connames);
				return true;
			} else {
				alertWarn("请选择流程");
				return false;
			}
		},
		onload: function () {
			if (names != null && names != "") {
				var namesArray = names.split(',');
				var idsArray = ids.split(',');
				for (var i = 0; i < namesArray.length; i++) {
					$('#choosegrid').datagrid('appendRow', {
						resId: idsArray[i],
						flowText: namesArray[i]
					});
				}
			}
		}
	});

}
