var WfProcessinstRollDataGrid=$('#WfProcessinstRoll_datagrid');
$(function(){
	initWfProcessinstRollGrid();
});

function initWfProcessinstRollGrid(){
	WfProcessinstRollDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#WfProcessinstRoll_datagrid_tb",
	    url:ctx+'/WfProcessinstRoll/pageWfProcessinstRoll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="WfProcessinstRollFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',title:'id',width:100,align:'center',halign:'center'},
	    {field:'msgId',title:'msgId',width:100,align:'center',halign:'center'},
	    {field:'busiMainId',title:'busiMainId',width:100,align:'center',halign:'center'},
	    {field:'formCode',title:'formCode',width:100,align:'center',halign:'center'},
	    {field:'workitemid',title:'workitemid',width:100,align:'center',halign:'center'},
	    {field:'processinstid',title:'processinstid',width:100,align:'center',halign:'center'},
	    {field:'workmemory',title:'意见',width:100,align:'center',halign:'center'},
	    {field:'workmemoryPic',title:'workmemoryPic',width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center'},
	    {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center'},
	    {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.id);
	    }
	});
    WfProcessinstRollDataGrid.datagrid('doCellTip');
    var pager = WfProcessinstRollDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('WfProcessinstRoll_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function WfProcessinstRollFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=WfProcessinstRoll&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadWfProcessinstRoll(){
	WfProcessinstRollDataGrid.datagrid('reload');
}
//查询表格
function searchWfProcessinstRoll(){
	WfProcessinstRollDataGrid.datagrid('load',{
		search:$("#searchWfProcessinstRoll").val()
	});
}

//增加记录
function addWfProcessinstRoll() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=WfProcessinstRoll",
		submiturl:"/WfProcessinstRoll/saveWfProcessinstRoll?formcode=WfProcessinstRoll",
//		contenturl:"/view/workflow/WfProcessinstRoll",
//		submiturl:"/WfProcessinstRoll/saveWfProcessinstRoll",
		callback:reloadWfProcessinstRoll
	});
	
}

//修改记录
function editWfProcessinstRoll() {
	var row = WfProcessinstRollDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=WfProcessinstRoll&id=" + id,
			submiturl:"/WfProcessinstRoll/saveWfProcessinstRoll?formcode=WfProcessinstRoll",
//			contenturl : "/view/workflow/WfProcessinstRoll",
//			submiturl : "/WfProcessinstRoll/saveWfProcessinstRoll",
//			onload : "/WfProcessinstRoll/findWfProcessinstRoll?id=" + id,
			callback : reloadWfProcessinstRoll
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delWfProcessinstRoll() {
	var row = WfProcessinstRollDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/WfProcessinstRoll/delWfProcessinstRoll",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							WfProcessinstRollDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
