var WfCommonphrase_basegrid=$('#WfCommonphrase_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	WfCommonphrase_basegrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		cls:'md',
		pagination:true,
		height:getMixGridHeight(),
		toolbar:"#WfCommonphrase_datagrid_tb",
	    url:ctx+'/WfCommonphrase/pageWfCommonphrase',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.phraseId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'phraseId',title:'常用语ID',hidden:true},
	    {field:'commonPhrase',title:'流程常用语',width:200,align:'center',halign:'center',sortable : true},
	    {field:'phraseType',hidden:true},
	    {field:'phraseTypeText',title:'常用语类型',width:100,align:'center',halign:'center'},
	    {field:'accountName',title:'常用语使用人',width:100,align:'center',halign:'center'},
	    {field:'displayNo',title:'顺序',width:100,align:'center',halign:'center',sortable : true},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.phraseId);
	    }
	});
	WfCommonphrase_basegrid.datagrid('doCellTip');
    var pager = WfCommonphrase_basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('WfCommonphrase_datagrid',"常用语管理一览表");
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=WfCommonphrase&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	WfCommonphrase_basegrid.datagrid('reload');
}
//查询表格
function searchWfCommonphrase(){
	WfCommonphrase_basegrid.datagrid('load',{
		// search:$("#searchWfCommonphrase").val()
		phraseType:$("#phraseType").textbox('getValue'),
		commonPhrase:$("#commonPhrase").textbox('getValue')
	});
}

//增加记录
function addWfCommonphrase() {
	$.ajax({
		url : ctx+"/WfCommonphrase/getMaxDisplayNo",
		dataType : 'json',
		success : function(result) {
			if (result.success) {
				WfCommonphrase_basegrid.datagrid('reload');
				openSaveDialog({
					title:"添加记录",
					maximized : true,
					contenturl:"/GenForm/form?formcode=WfCommonphrase",
					submiturl:"/WfCommonphrase/saveWfCommonphrase?formcode=WfCommonphrase",
//					contenturl:"/view/business/edoc/WfCommonphrase",
//					submiturl:"/WfCommonphrase/saveWfCommonphrase",
					callback:reloadGrid,
					onload : function (){
						$('#displayNo').numberbox('setValue',result.o);
					}
				});
			}else{
				alertError(result.msg);
			}
		}
	});
	
	
}

//修改记录
function editWfCommonphrase() {
	var row = WfCommonphrase_basegrid.datagrid('getSelected');
	if (row) {
		var id = row.phraseId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=WfCommonphrase&id=" + id,
			submiturl:"/WfCommonphrase/saveWfCommonphrase?formcode=WfCommonphrase",
//			contenturl : "/view/business/edoc/WfCommonphrase",
//			submiturl : "/WfCommonphrase/saveWfCommonphrase",
//			onload : "/WfCommonphrase/findWfCommonphrase?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delWfCommonphrase() {
	var row = WfCommonphrase_basegrid.datagrid('getSelected');
	if (row) {
	var id =row.phraseId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/WfCommonphrase/delWfCommonphrase",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							WfCommonphrase_basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
function moveupWfCommonphrase() {
	var selections = WfCommonphrase_basegrid.datagrid('getSelections');
	if (! selections.length) {
		alertWarn('请先选择要移动的项目属性');
		return;
	}
	// 多行移动(上移)
	for(var i = 0; i < selections.length; i++){
		var index = WfCommonphrase_basegrid.datagrid('getRowIndex',selections[i]);
        if(index <= 0){
        	return;
        }
        // 当前行
		var toup = selections[i];
		// 当前行的上一行,即移往的行
		var todown = WfCommonphrase_basegrid.datagrid('getData').rows[index - 1];
		WfCommonphrase_basegrid.datagrid('getData').rows[index] = todown;
		WfCommonphrase_basegrid.datagrid('getData').rows[index - 1] = toup;
		WfCommonphrase_basegrid.datagrid('refreshRow', index);
		WfCommonphrase_basegrid.datagrid('refreshRow', index - 1);
		// 支持多选,因此要先取消选中之前的选中行
		WfCommonphrase_basegrid.datagrid('unselectRow', index );
		WfCommonphrase_basegrid.datagrid('selectRow', index - 1);
    }
}

// 下移
function movedownWfCommonphrase() {
	var selections = WfCommonphrase_basegrid.datagrid('getSelections');
	if (! selections.length) {
		alertWarn('请先选择要移动的项目属性');
		return;
	}
	// 多行移动(下移)
	var length = WfCommonphrase_basegrid.datagrid("getRows").length;
	for(var i = 0; i < selections.length; i++){
		// 从最下面的选中列判断
		var $i = selections.length-1-i;
        var index = WfCommonphrase_basegrid.datagrid('getRowIndex',selections[$i]);
        if(index >= length-1){
        	return;
        }
        // 当前行
		var todown = selections[$i];
		// 当前行的下一行,即移往的行
		var toup = WfCommonphrase_basegrid.datagrid('getData').rows[index + 1];
		WfCommonphrase_basegrid.datagrid('getData').rows[index + 1] = todown;
		WfCommonphrase_basegrid.datagrid('getData').rows[index] = toup;
		WfCommonphrase_basegrid.datagrid('refreshRow', index);
		WfCommonphrase_basegrid.datagrid('refreshRow', index + 1);
		// 支持多选,因此要先取消选中之前的选中行
		WfCommonphrase_basegrid.datagrid('unselectRow', index );
		WfCommonphrase_basegrid.datagrid('selectRow', index + 1);
    }
}

function saveDisplayNo() {
	$('#saveDisplayNo').linkbutton('disable');
	// 已分配里程碑节点列表grid信息
	var rows = WfCommonphrase_basegrid.datagrid('getRows');
	if(! rows.length){
		$('#saveDisplayNo').linkbutton('enable');
		return;
	}
	
	var phraseIds=new Array();
	$.each(rows,function(index,value){
		phraseIds.push({
			phraseId:value.phraseId
		});
	});
	var effectRow = new Object();
	effectRow["data"] = JSON.stringify(phraseIds);

	var saveUrl = ctx + "/WfCommonphrase/saveWfCommonphraseDisplayNo";
	// 所有datagrid的数据均传入后台
	// 后台根据index进行排序并保存
	$.post(saveUrl, effectRow, function(result) {
		alertInfo('保存排序成功');
		WfCommonphrase_basegrid.datagrid('reload');
		// 启用按钮
		$('#saveDisplayNo').linkbutton('enable');
	}, "JSON").error(function() {
		alertError('保存排序失败，请重试');
		// 启用按钮
		$('#saveDisplayNo').linkbutton('enable');
	});
}