var basegrid=$('#BasCourt_datagrid');
$(function(){
	initGrid();

	$('#search').textbox('textbox').bind('keyup', function (e) {
		if (e.keyCode == 13) {
			searchBasCourt();
		}
	});
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		height:getMixGridHeight(),
		cls:'md',
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasCourt_datagrid_tb",
	    url:ctx+'/BasCourt/pageBasCourt',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.courtId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'courtName',title:'法院名称',width:100,align:'center',halign:'center'},
	 //   {field:'regionId',title:'地区',width:100,align:'center',halign:'center'},
	    {field:'areaFullName',title:'地区',width:100,align:'center',halign:'center'},
	    {field:'courtAddr',title:'法院地址',width:100,align:'left',halign:'center'},
	    {field:'contactMan',title:'联系人',width:100,align:'center',halign:'center'},
	    {field:'contactNumber',title:'联系电话',width:100,align:'center',halign:'center'},
	    {field:'remark',title:'说明',width:100,align:'left',halign:'center'},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.courtId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasCourt_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasCourt&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasCourt(){
	basegrid.datagrid('load',{
		search:$("#search").val()
	});
}

//增加记录
function addBasCourt() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasCourt",
		submiturl:"/BasCourt/saveBasCourt?formcode=BasCourt",
//		contenturl:"/view/sys/BasCourt",
//		submiturl:"/BasCourt/saveBasCourt",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasCourt() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.courtId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasCourt&id=" + id,
			submiturl:"/BasCourt/saveBasCourt?formcode=BasCourt",
//			contenturl : "/view/sys/BasCourt",
//			submiturl : "/BasCourt/saveBasCourt",
//			onload : "/BasCourt/findBasCourt?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasCourt() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.courtId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasCourt/delBasCourt",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
