var basetree=$('#PubContactOrgType_tree');
var baseform=$('#PubContactOrgType_form');
$(function(){
	initTree();
});
//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/PubContactOrgType/treePubContactOrgTypeWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}
//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable){
	if(isable){
		$('#delPubContactOrgType').linkbutton('enable'); //删除
		$('#savePubContactOrgType').linkbutton('enable'); //保存
	}else{
		$('#delPubContactOrgType').linkbutton('disable');
		$('#savePubContactOrgType').linkbutton('disable');
	}
}
//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
	if(node.id==="0"){
		baseform.form('clear');
		controlBtn(false);
	}else{
		baseform.form('load',ctx+"/PubContactOrgType/findPubContactOrgType?id="+node.id);
		controlBtn(true);
	}
}

function expandNode(){
	basetree.tree('expandAll');
}

function resetPubContactOrgType(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function addPubContactOrgType() {
	var node = basetree.tree('getSelected');
	// 清除当前界面信息
	baseform.form('clear');
	$('#contactOrgTypePid').combotree('setValue',node.id);
	$('#savePubContactOrgType').linkbutton('enable');
	$("#type").val("1")
}

//删除
function delPubContactOrgType() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点及下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/PubContactOrgType/delPubContactOrgTypeAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function savePubContactOrgType(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		baseform.form('submit', {
			url : ctx + "/PubContactOrgType/savePubContactOrgType",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#savePubContactOrgType').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
					// 获取选中的节点
					var resultnode = basetree.tree('find',result.o.contactOrgTypeId);
					if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
						basetree.tree('update', {
									target : selectnode.target,
									text : result.o.contactOrgTypeName
									
								});
					} else {
						basetree.tree('append', {
									parent : selectnode.target,
									data : [{
id:result.o.contactOrgTypeId,
text:result.o.contactOrgTypeName
											}]
								});
					}
					alertInfo(result.msg);
					var newnode = basetree.tree('find',result.o.contactOrgTypeId);
					basetree.tree('select', newnode.target);
					$('#savePubContactOrgType').linkbutton('enable');
				} else {
					alertError(result.msg);
					$('#savePubContactOrgType').linkbutton('enable');
				}
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

