var PubCommonToolDataGrid=$('#PubCommonTool_datagrid');
$(function(){
	initPubCommonToolGrid();
});

function initPubCommonToolGrid(){
	PubCommonToolDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#PubCommonTool_datagrid_tb",
	    url:ctx+'/PubCommonTool/pagePubCommonTool',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="PubCommonToolFormDetail('+row.toolId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'toolId',title:'工具主键',hidden:true},
	    {field:'toolName',title:'工具名称',width:80,align:'center',halign:'center'},
	    {field:'toolAddr',title:'工具地址',width:300,align:'center',halign:'center'},
	    {field:'toolIco',title:'工具图标',width:100,align:'center',halign:'center'},
//	    {field:'toolImg',title:'工具图片',width:100,align:'center',halign:'center'},
	    {field:'displayNo',title:'排序',width:50,align:'center',halign:'center'},
	    {field:'isEnableText',title:'是否启用',width:100,align:'center',halign:'center'},
	    {field:'remark',title:'备注',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.toolId);
	    }
	});
    PubCommonToolDataGrid.datagrid('doCellTip');
    var pager = PubCommonToolDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubCommonTool_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function PubCommonToolFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubCommonTool&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadPubCommonTool(){
	PubCommonToolDataGrid.datagrid('reload');
}
//查询表格
function searchPubCommonTool(){
	PubCommonToolDataGrid.datagrid('load',{
		search:$("#searchPubCommonTool").val()
	});
}

//增加记录
function addPubCommonTool() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubCommonTool",
		submiturl:"/PubCommonTool/savePubCommonTool?formcode=PubCommonTool",
		callback:reloadPubCommonTool
	});
	
}

//修改记录
function editPubCommonTool() {
	var row = PubCommonToolDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.toolId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=PubCommonTool&id=" + id,
			submiturl:"/PubCommonTool/savePubCommonTool?formcode=PubCommonTool",
//			contenturl : "/view/pub/PubCommonTool",
//			submiturl : "/PubCommonTool/savePubCommonTool",
//			onload : "/PubCommonTool/findPubCommonTool?id=" + id,
			callback : reloadPubCommonTool
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delPubCommonTool() {
	var row = PubCommonToolDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.toolId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/PubCommonTool/delPubCommonTool",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							PubCommonToolDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}

/**
 * 选择图标
 * @returns
 */
function chooseIco(){
	openChooseDialog({
		title:'选择图标',
		contenturl:"/BasMenu/chooseIcons",
		width:600,
		height:400,
		okhandler:function(){
			if($('#chooseico').val()){
				$('#toolIco').textbox('setValue',$('#chooseico').val());
				return true;
			}else{
				alertWarn('请选择一个图标');
				return false;
			}
		}
	});

}

//删除记录
function stopPubCommonTool() {
	var row = PubCommonToolDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.toolId;
		alertConfirmYes('您是否要停用当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/PubCommonTool/stopPubCommonTool",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							PubCommonToolDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
