var basegrid=$('#GenForm_datagrid');
var basepanelgrid=$('#GenFormPanel_datagrid');
$(function(){
	initGrid();
	initPanelGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		pagination:true,
		fitColumns:true,
		toolbar:"#GenForm_datagrid_tb",
	    url:ctx+'/GenForm/pageGenForm',
	    columns:[[
	    {field:'ID',title:'ID',hidden:true},
	    {field:'FORM_CODE',title:'页面编码',width:130},
	    {field:'FORM_NAME',title:'页面名称',width:120},
//	    {field:'FORM_TYPE',hidden:true},
//	    {field:'FORM_TYPE_TEXT_',title:'页面类型',width:80},
//	    {field:'CATALOG_NAME',title:'文件目录',width:80},
	    {field:'FLOW_NAME',title:'流程',width:130},
	    {field:'BUSI_TABLE',title:'表名',width:130},
	    {field:'MODEL_NAME',title:'会计凭证业务主题',width:100}
	    ]],
	    onSelect:function(index,row){
	    	basepanelgrid.datagrid('load',{
				formid:row.ID
			});
	    },
	    onDblClickRow:editGenForm
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}

function searchGenForm(){
	basegrid.datagrid('load',{
		search:$("#searchGenForm").val()
	});
}

//增加表单
function addGenForm() {
	openSaveDialog({
		title:"新增页面",
		width:500,
		height:370,
		contenturl:"/view/gen/GenFormform",
		submiturl:"/GenForm/saveGenForm",
		callback:reloadGrid
	});
	
}

//修改表单
function editGenForm() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		openSaveDialog({
			title:"修改页面",
			width:500,
			height:370,
			contenturl : "/view/gen/GenFormform",
			submiturl : "/GenForm/saveGenForm",
			onload : "/GenForm/findGenForm?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除表单
function delGenForm() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenForm/delGenForm",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的表单信息');
	}
}

function initPanelGrid(){
	basepanelgrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		pagination:true,
		fitColumns:true,
		toolbar:"#GenFormPanel_datagrid_tb",
	    url:ctx+'/GenFormPanel/pageGenFormPanelByFormID',
	    columns:[[
	    {field:'PANEL_ID',title:'面板ID',hidden:true},
	    {field:'FORM_ID',title:'表单ID',hidden:true},
	    {field:'PANEL_TITLE',title:'面板标题',width:100},
	    {field:'PANEL_TYPE',hidden:true},
	    {field:'PANEL_TYPE_TEXT_',title:'面板类型',width:100},
	    {field:'FORM_COLNUM',title:'列数',width:50},
	    {field:'DISPLAY_NO',title:'显示顺序',width:80}
	    ]]
	});

}

function reloadpanelGrid(){
	basepanelgrid.datagrid('reload');
}

//增加
function addGenFormPanel() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var formid=row.ID;
		openSaveDialog({
			title:"添加记录",
			height:550,
			width:500,
			contenturl:"/view/gen/GenFormPanelform",
			submiturl:"/GenFormPanel/saveGenFormPanel",
			callback:reloadpanelGrid,
			onload:function(){
				$("#formId").val(formid);
			}
		});
	}else {
		alertInfo('请选择一个表单');
	}
	
}

//修改表单
function editGenFormPanel() {
	var row = basepanelgrid.datagrid('getSelected');
	if (row) {
		var id = row.PANEL_ID;
		openSaveDialog({
			title : "修改记录",
			height:550,
			width:500,
			contenturl : "/view/gen/GenFormPanelform",
			submiturl : "/GenFormPanel/saveGenFormPanel",
			onload : "/GenFormPanel/findGenFormPanel?id=" + id,
			callback : reloadpanelGrid
		});
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除表单
function delGenFormPanel() {
	var row = basepanelgrid.datagrid('getSelected');
	if (row) {
	var id =row.PANEL_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenFormPanel/delGenFormPanel",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basepanelgrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的表单信息');
	}
}
function chooseTable(){
	openChooseDialog({
		title:'选择数据库表',
		contenturl:'/gen/alltable',
		width:400,
		height:500,
		okhandler:function(){
			var row=$("#alltable").datagrid('getSelected');
			if(row){
				$("#busiTable").textbox("setValue",row.code);
				return true;
			}else{
				 alertInfo("请选择表名");
				 return false;
			}
		}
	});
	
}
