var basetree=$('#DocCatalog_tree');
var basegrid=$('#DocFileType_datagrid');
$(function(){
	initTree();
	initGrid();
	bindEnterKey("#searchDocFileType",searchDocFileType);
});
function initTree(){
	basetree.tree({
		url : ctx + '/DocCatalog/treeStanderDocCatalog?sysType=CONSTRUCTION',
		onSelect : function(node) {
			reloadGrid();
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

function _previewfile(versionid){
	previewFile({
		versionid:versionid
	})
}
function initGrid(){
	basegrid.datagrid({
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#DocFileType_datagrid_tb",
	    url:ctx+'/DocFileType/pageDocSearch',
	    columns:[[
	    {
	     field:'opt',title:'预览',width:40,align:'center',
	     formatter:function(value,rowData,index){	// value表示字段的值,rowData行记录数据,index行索引
	     	if(rowData.VERSION_ID)
	   			  return '<div onclick="_previewfile(\''+rowData.VERSION_ID+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
	      }},
	    {field:'FILE_ID',title:'文件ID',hidden:true},
	    {field:'BASE_VERSION_ID',title:'基础版本ID',hidden:true},
	    {field:'FILE_TYPE_NAME',title:'文件类型',align:'center',width:80},
	    {field:'FILE_NAME',title:'文档名称',align:'center',width:80},
	    {field:'FILE_NO',title:'文档编号',align:'center',width:80},
	    {field:'ORIGINAL_NAME',title:'文件名称',align:'center',width:130},
	    {field:'VERSION_NO',title:'版本号',align:'center',width:100},
	    {field:'VERSION_NOH',title:'历史版本',align:'center',width:60},
	    {field:'CREATE_ACCOUNT',title:'创建人',align:'center',width:80},
	    {field:'CREATE_TIME',title:'创建时间',align:'center',width:80}
	    ]]
	});
	
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('DocFileType_datagrid',"文档查询");   
	        }    
	    }]   
	}); 
}
function reloadGrid(){
	var node=basetree.tree('getSelected');
	basegrid.datagrid('reload',{
		catalogid:node.id,
		search:$("#searchDocFileType").val()
	});
}
function viewFileLog(){
	var row=basegrid.datagrid("getSelected");
	if(row){
		$('<div/>').dialog({
			href :ctx+"/view/business/pm/DocFileLog?versionId="+row.VERSION_ID,
			maximized : true,
			modal : true,
			title : "查看日志",
			onClose : function() {
				$(this).dialog('destroy');
			},
			inline:false
		});
	}else{
		alertWarn("请先选择一条数据");
	}
}
function searchDocFileType(){
	reloadGrid();
}
