var DocFormFileDataGrid=$('#DocFormFile_datagrid');
$(function(){
	initDocFormFileGrid();
});

function initDocFormFileGrid(){
	DocFormFileDataGrid.datagrid({
		height:getMixGridHeight(),
		border:false,
		singleSelect:false,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			startDate:$('#sDate').datebox('getValue'),
			endDate:$('#eDate').datebox('getValue')
		},
		cls:'md',
		toolbar:"#DocFormFile_datagrid_tb",
	    url:ctx+'/DocFormFile/pageDocFormFile',
//	    selectOnCheck:false,
//	    checkOnSelect:false,
	    columns:[[
	    	{checkbox:true,field:'ck'},
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="DocFormFileFormDetail('+row.formFileId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
//	    {field:'formFileId',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'displayNo',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'fileName',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'fileNo',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'fileTypeId',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'fileVersionId',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'formId',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'isUse',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'memo',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'primaryKey',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'projectId',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'modifyAccount',title:'',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'modifyTime',title:'',width:100,align:'center',halign:'center',sortable:true},
	    {field:'billTypeText',title:'发票类型',width:120,align:'center',halign:'center',sortable:true},
	    {field:'billNo',title:'发票号',width:120,align:'center',halign:'center',sortable:true},
	    {field:'billCode',title:'发票代码',width:120,align:'center',halign:'center',sortable:true},
	    {field:'billDate',title:'开票日期',width:100,align:'center',halign:'center',sortable:true},
	    {field:'billMoney',title:'发票金额',width:100,align:'right',halign:'right',sortable:true,formatter:formatterMoney},
//	    {field:'billTaxMoney',title:'发票税额',width:100,align:'right',halign:'right',sortable:true,formatter:formatterMoney},
//	    {field:'billCategory',title:'发票分类',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'billRemark',title:'发票说明',width:200,align:'left',halign:'left',sortable:true},
	    {field:'saleName',title:'销售方',width:160,align:'left',halign:'left',sortable:true},
	    {field:'primaryKey',title:'操作',width:100,align:'center',halign:'center',formatter:function(value,row,index){
	    	var  str = '<a style="cursor: pointer;color:#409eff;" onclick="previewFile({versionid:'+row.fileVersionId+'})" >发票</a>';
	    	if(value){
	    		str+= '&emsp;&emsp;	<a style="cursor: pointer;color:#409eff;" onclick="DocFormFileFormDetail('+value+',\''+row.formCode+'\')" >报账单</a>';
	    	}/*else{
	    		str+= '&emsp;&emsp;	<a style="cursor: pointer;color:red;" onclick="doreimburse('+index+')" >发起报销</a>';
	    	}*/
	    	return str;
	    }}
//	    ,{field:'billTaxRate',title:'税率',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'serviceType',title:'货物或应税服务类型',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			DocFormFileFormDetail(row.formFileId);
	    },
	    onClickRow:function(index, row){
//		    DocFormFileDataGrid.datagrid('unselectAll');
//		    DocFormFileDataGrid.datagrid('selectRow',index);
	    }
	});
    DocFormFileDataGrid.datagrid('doCellTip');
    var pager = DocFormFileDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('DocFormFile_datagrid',"我的票夹");
	        }    
	    }]   
	});
}
//查看表单明细
function DocFormFileFormDetail(id,formCode){
	formCode = formCode||"DocFormFile";
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode="+formCode+"&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadDocFormFile(){
	DocFormFileDataGrid.datagrid('reload');
}
//查询表格
function searchDocFormFile(){
	DocFormFileDataGrid.datagrid('load',{
		startDate:$('#sDate').datebox('getValue'),
		endDate:$('#eDate').datebox('getValue'),
		invoceType: $("#invoceType").combobox('getValue'),
		search :$("#search").textbox('getValue'),
		reimbursed : $("#reimbursed").combobox('getValue')
	});
}

//增加记录
function addDocFormFile() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=DocFormFile",
		submiturl:"/DocFormFile/saveDocFormFile?formcode=DocFormFile",
//		contenturl:"/view/doc/DocFormFile",
//		submiturl:"/DocFormFile/saveDocFormFile",
		callback:reloadDocFormFile
	});
	
}
function doreimburse(){
	
}
//修改记录
function editDocFormFile() {
	var row = DocFormFileDataGrid.datagrid('getSelected');
	if (row) {
		if(row.primaryKey){
			alertWarn('当前发票已经报销，暂时无法修改');
			return;
		}
		var id = row.formFileId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=DocFormFile&id=" + id,
			submiturl:"/DocFormFile/saveDocFormFile?formcode=DocFormFile",
//			contenturl : "/view/doc/DocFormFile",
//			submiturl : "/DocFormFile/saveDocFormFile",
//			onload : "/DocFormFile/findDocFormFile?id=" + id,
			callback : reloadDocFormFile
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delDocFormFile() {
	var rows = DocFormFileDataGrid.datagrid('getSelections');
	if (rows&&rows.length>0) {
		var ids = [];
		var flag=false;
		rows.forEach(function(row){
			if(row.primaryKey){
				flag = true;
				return;
			}
			ids.push(row.formFileId);
		});
		if(flag){
			alertWarn('选择的发票中包含已报销的发票，请您确认后重新选择');
			return;
		}
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/DocFormFile/delDocFormFile",
					data : {
						ids : ids.join(",")
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							DocFormFileDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

function timeRangeChange(rec){
	rec.value=="custom"?$("#timeRangeDateBox").show():$("#timeRangeDateBox").hide();//自定义的时候展示选
	if(rec.value=="0"){//全部
		$('#sDate').datebox('clear');
		$('#eDate').datebox('clear');
	}else if(rec.value=="day"){//今日
		$('#sDate').datebox('setValue',new Date().Format("yyyy-MM-dd"));
		$('#eDate').datebox('setValue',new Date().Format("yyyy-MM-dd"));
	}else if(rec.value=="week"){//本周
		$('#sDate').datebox('setValue',new Date().getFirstDateOfWeek().Format("yyyy-MM-dd"));
		$('#eDate').datebox('setValue',new Date().getLastDateOfWeek().Format("yyyy-MM-dd"));
	}else if(rec.value=="month"){//本月
		$('#sDate').datebox('setValue',new Date().getFirstDateOfMonth().Format("yyyy-MM-dd"));
		$('#eDate').datebox('setValue',new Date().getLastDateOfMonth().Format("yyyy-MM-dd"));
	}else if(rec.value=="year"){//本年
		$('#sDate').datebox('setValue',new Date().Format("yyyy")+"-01-01");
		$('#eDate').datebox('setValue',new Date().Format("yyyy")+"-12-31");
	}else if(rec.value=="lastmonth"){//上个月
		$('#sDate').datebox('setValue',new Date().getFirstDateOfMonth().add("month",-1).Format("yyyy-MM-dd"));
		$('#eDate').datebox('setValue',new Date().getLastDateOfMonth().add("month",-1).Format("yyyy-MM-dd"));
	}else if(rec.value=="lastyear"){//去年
		$('#sDate').datebox('setValue',(new Date().Format("yyyy")-1)+"-01-01");
		$('#eDate').datebox('setValue',(new Date().Format("yyyy")-1)+"-12-31");
	} 
}
