var basegrid = $('#GmInfoContent_datagrid');
var workflowStatus = "";
$(function () {
    // 流程状态下拉框
    $('#flow_combo').combobox({
        editable: false,
        onChange: function (newV, oldV) {
            if (oldV) {
                searchGmInfoContent();
            }
        }
    });
    initGrid();
    bindEnterKey('#keyWordSearch', searchGmInfoContent);
});

function initGrid() {
    basegrid.datagrid({
        // fit : true,
        border: false,
        singleSelect: true,
        cls: 'md',
        rownumbers: true,
        fitColumns: true,
        pagination: true,
        height: getMixGridHeight(),
        queryParams: {
            flowDone: haseasyui('#flow_combo') ? $('#flow_combo').combobox(
                'getValue') : "",
            infomationType: informationType
        },
        toolbar: "#GmInfoContent_datagrid_tb",
        url: ctx + '/GmInfoContent/pageGmInfoContent',
        columns: [[
            {
                field: 'opt',
                title: '明细',
                width: 40,
                align: 'center',
                formatter: function (value, row, index) { // value表示字段的值,rowData行记录数据,index行索引
                    return '<div onclick="openFormDetail(' + index
                        + ')" class="icon-detail iconfont blue">&nbsp;</div>';
                }
            }, {
                field: 'typeName',
                title: '信息栏目',
                width: 100,
                align: 'center',
                halign: 'center',
                sortable: true
            }, {
                field: 'contentTitle',
                title: '发布标题',
                width: 200,
                align: 'left',
                halign: 'center',
                sortable: true
            }, {
                field: 'userName',
                hidden: true
            }, {
                field: 'publishDeptIdName',
                title: '发布部门',
                width: 80,
                align: 'center',
                halign: 'center',
                sortable: true
            }, {
                field: 'publishAccontIdName',
                title: '发布人员',
                width: 80,
                align: 'center',
                halign: 'center',
                sortable: true
            }, {
                field: 'publishDate',
                title: '发布时间',
                width: 80,
                align: 'center',
                halign: 'center',
                sortable: true,
                formatter: function (value, row, index) {
                    if (value === null) {
                        return null;
                    } else {
                        return new Date(value).Format('yyyy-MM-dd');
                    }
                }
            }, {
                field: 'isReleasePeople',
                hidden: true
            }, {
                field: 'isReleasePeopleText',
                hidden: true
            }, {
                field: 'isStick',
                hidden: true
            }, {
                field: 'isStickText',
                hidden: true
            }, {
                field: 'isPicNews',
                hidden: true
            }, {
                field: 'isPicNewsText',
                hidden: true
            }, {
                field: 'contentFormat',
                hidden: true
            }, {
                field: 'contentFormatText',
                hidden: true
            }, {
                field: 'infoUseType',
                title: '采用情况',
                width: 80,
                align: 'center',
                halign: 'center',
                // 判断节点是否显示
                hidden: ($('#infoUse').attr('href') !== "#")
            }, {
                field: 'workflowStatusText',
                title: '审批状态',
                width: 80,
                align: 'center',
                halign: 'center',
                sortable: true,
                // formatter : function (v){
                // 	if (v=="3"){
                // 		return "已发布";
                // 	}else{
                // 		return "未发布";
                // 	}
                // }
            }]],
        onDblClickRow: function (index, row) {
            // 查看明细
            openFormDetail(index);
        },
        onLoadSuccess: function (data) {
            // 存在信息采用功能
            if ($('#infoUse').attr('href') !== "#") {
                return data;
            }
            let infoIds = "";
            for (let i = 0; i < data.rows.length; i++) {
                infoIds += data.rows[i].infoId + ",";
            }
            $.ajax({
                url: ctx + "/gmInfoContentUse/findGmInfoContentUseByInfoIds",
                async: false,
                type: "post",
                data: {
                    infoIds: infoIds
                },
                dataType: "json",
                success: function (result) {
                    for (let i = 0; i < data.rows.length; i++) {
                        let row = data.rows[i];
                        row['infoUseType'] = result[row['infoId']];
                    }
                }
            });
            if (data.rows.length > 0) {
                for (let i = 0; i < data.rows.length; i++) {
                    let row = data.rows[i];
                    $('#GmInfoContent_datagrid').datagrid('updateRow', {
                        index: i,
                        row: row
                    });
                    $('#GmInfoContent_datagrid').datagrid('refreshRow', i);
                }
            }
            return data;
        }
    });
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({
        buttons: [{
            iconCls: 'icon-page_excel',
            handler: function () {
                exportExcel('GmInfoContent_datagrid', "信息发布");
            }
        }]
    });
}

// 查看表单明细
function openFormDetail(index) {
    basegrid.datagrid("selectRow", index);
    var row = basegrid.datagrid('getSelected');
    openDetailDialog({
        title: "查看记录",
        maximized: true,
        contenturl: "/GmInfoContent/viewGmInfoContent?id=" + row.infoId + "&isdetail=true",
        onload: function () {
            $('#isApprove').val(row.isApproval);
            $('#typeIdName').textbox('setValue', row.typeName);
            $('#publishScope_TEXT_').textbox('setValue', row.userName);
        }
    });
}

// 重新加载表格
function reloadGrid() {
    basegrid.datagrid('reload');
}

// 查询表格
function searchGmInfoContent() {
    basegrid.datagrid('load', {
        flowDone: haseasyui('#flow_combo') ? $('#flow_combo').combobox(
            'getValue') : "",
        infoTypeId: haseasyui('#typeIdNew') ? $('#typeIdNew').combobox('getValue') : "",
        // search : $("#searchGmInfoContent").val(),
        keyWord: $("#keyWordSearch").val(),
        infomationType: informationType
    });
}

// 增加记录
function addGmInfoContent() {
    openSaveDialog({
        title: "添加记录",
        maximized: true,
        sureText: "保存草稿",
        contenturl: "/GmInfoContent/viewGmInfoContent",
        submiturl: "/GmInfoContent/saveGmInfoContent?formcode=GmInfoContent",
        onload: addOnload,
        callback: reloadGrid,
        bottons: [{
            text: "预览",
            iconCls: 'icon-page-printer',
            handler: function () {
                saveForm("preview");
            }
        }, {
            text: "发送",
            iconCls: 'icon-apply',
            id: 'submit_GmInfoContent',
            handler: function () {
                var isApprove = $('#isApprove').val();
                var workflowStatus = $('#workflowStatus').val();
                if (isApprove == "Y") {
                    if (workflowStatus == '3') {
                        alertWarn('数据已通过');
                        return;
                    }
                    saveForm("approve");
                } else {
                    alertConfirmYes('该栏目无需审批，发送即发布，是否发送？', function (r) {
                        if (r) {
                            $('#workflowStatus').val(Number("3"));
                            saveForm("publish");
                        }
                    });
                }
            }
        }],
        onsubmit: function (param) {
//			if ($('input[name="contentFormat"]:checked').val()=="MODEL"||$('input[name="contentFormat"]:checked').val()=="URL"){
//				var container = UE.getEditor('ct').getContent();
//				autoSetValue('content',container);
//			}
            return true;
        }
    });

}

function addOnload() {
    $('#publishDate').datetimebox('setValue', (new Date()).Format("yyyy-MM-dd hh:mm:ss"));
}

// 修改记录
function editGmInfoContent() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
//		if (row.workflowStatus){
//			if (row.workflowStatus=='3') {
//				alertInfo('数据已经发布过,不能修改');
//				return;
//			}
//		}
        var id = row.infoId;
        openSaveDialog({
            title: "修改记录",
            maximized: true,
            contenturl: "/GmInfoContent/viewGmInfoContent?id=" + id,
            submiturl: "/GmInfoContent/saveGmInfoContent?formcode=GmInfoContent",
            // onload : "/GmInfoContent/findGmInfoContent?id=" + id,
            callback: reloadGrid,
            sureText: "保存草稿",
            submitbtn: "GmInfoContent_Form",//发送表单ID
            onload: function () {
                $('#isYulan').val('N');
                $('#isApprove').val(row.isApproval);
                $('#typeIdName').textbox('setValue', row.typeName);
//				$('#publishScope_TEXT_').textbox('setValue',row.userName);
            },
            bottons: [{
                text: "预览",
                iconCls: 'icon-page-printer',
                handler: function () {
                    $('#isYulan').val('Y');
                    saveForm("preview");
                }
            }, {
                text: "发送",
                iconCls: 'icon-apply',
                id: 'submit_GmInfoContent',
                handler: function () {
                    var isApprove = $('#isApprove').val();
                    var workflowStatus = $('#workflowStatus').val();
                    if (isApprove == "Y") {
                        if (workflowStatus == '3') {
                            alertWarn('数据已通过');
                            return;
                        }
                        $('#isYulan').val('N');
                        saveForm("approve");
                    } else {
                        alertConfirmYes('该栏目无需审批，发送即发布，是否发送？', function (r) {
                            if (r) {
                                $('#isYulan').val('N');
                                $('#workflowStatus').val(Number("3"));
                                saveForm("publish");
                            }
                        });
                    }
                }
            }],
            onsubmit: function (param) {
//				
//				if ($('input[name="contentFormat"]:checked').val()=="MODEL"||$('input[name="contentFormat"]:checked').val()=="URL"){
//					 var container = UE.getEditor('ct').getContent();
//					autoSetValue('content',container);
//				}
                return true;
            }
        });

    } else {
        alertWarn('请选择一条记录进行修改');
    }
}

// 删除记录
function delGmInfoContent() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        if (row.workflowStatus == '3') {
            alertWarn('数据已经发布过,不能删除');
            return;
        }
        var id = row.infoId;
        alertConfirmYes('您是否要删除当前选中的数据？', function (r) {
            if (r) {
                $.ajax({
                    url: ctx + "/GmInfoContent/delGmInfoContent",
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function (result) {
                        if (result.success) {
                            basegrid.datagrid('reload');
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertWarn('请先选择要删除的数据信息');
    }
}

function doFlow() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        if (row.workflowStatus == '3') {
            alertWarn('数据已通过');
            return;
        }
        if (row.isApproval == 'N') {
            alertConfirmYes('该栏目无需审批，发送即发布，是否发送？', function (r) {
                if (r) {
                    $.ajax({
                        url: ctx + "/GmInfoContent/updateGmInfoContent",
                        data: {
                            businessMainId: row.infoId,
                        },
                        type: "post",
                        dataType: "json",
                        success: function (result) {
                            if (result.success) {
                                basegrid.datagrid('reload');
                                alertInfo(result.msg);
                            } else {
                                alertError(result.msg);
                            }
                        }
                    })
                }
            });
        } else {
            openFlowDialog({
                processInstId: row.processinstid,
                businessMainId: row.infoId,
                formCode: "GmInfoContent",
                callback: reloadGrid
            });
        }
    } else {
        alertWarn('请先选择一条数据信息');
    }
}

function viewFlow() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        if (!row.processinstid) {
            alertWarn('该记录无需上报');
            return;
        }
        viewFlowDialog(row.processinstid);
    } else {
        alertWarn('请先选择一条数据信息');
    }
}

function selectGmInfoType() {
    openChooseDialog({
        title: '选择信息栏目',
        contenturl: '/view/business/gm/GmInfoTypeWin?type=select',
        width: 400,
        height: 500,
        okhandler: function () {
            var row = $("#GmInfoType_datagrid").datalist('getSelected');
            if (row) {
                $("#typeId").val(row.typeId);
                $("#typeIdName").textbox("setValue", row.typeName);
                $("#isApprove").val(row.isApproval);
                $("#flowCode").val(row.flowCode);
                //在信息发布的 增加页面设置隐藏的栏目类型（集团统建 企业自建 以控制发布范围）
                autoSetValue('infoType', row.infoType);
                //选择的栏目为集团统建
                /*			if(row.infoType=='1'){
                                $("#publishScope").val('org:'+ orgId);
                                $("#publishScope_TEXT_").textbox('setValue',orgName);
                            }else{
                                //查询栏目关联的空间表，给发布范围进行默认赋值
                                $.ajax({
                                    url:ctx+"/BasSpaceComponentAssociated/findPublishScopeByTypeId",
                                    data:{
                                        typeId:row.typeId
                                    },
                                    dataType:"json",
                                    success:function(result){
                                        if(result.success){
                                            $('#publishScope').val(result.o.userId);
                                            $('#publishScope_TEXT_').textbox('setValue',result.o.userName);
                                        }else{
                                            alertError(result.msg)
                                        }
                                    }
                                })
                            }	*/
                //默认发布范围为同安控股
                //$("#publishScope").val('org:10000000');
                //$("#publishScope_TEXT_").textbox('setValue',"集团公司");
                return true;
            } else {
                alertWarn("请选择流程");
                return false;
            }
        }
    });
}

function previewGmInfoContent() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        var url = ctx + "/GmInfoContent/previewGmInfoContent?id=" + row.infoId;
        window.open(url, '信息预览');
    } else {
        alertWarn('请先选择一条数据信息');
        return false;
    }
}

function previewList() {
    window.open(ctx + "/GmInfoContent/previewList", "栏目预览");
}

function saveForm(status) {
//	if ($('input[name="contentFormat"]:checked').val()=="MODEL"){
//		 var container = UE.getEditor('ct').getContent();
//		$('#content').textbox("setValue",container);
//	}
    //$('#publishDate').val(new Date().Format("yyyy-MM-dd"));
    if (status == "preview") {
        if ($('#content').val() == "") {
            alertWarn('请维护正文内容');
            return false;
        }
    } else {
        $("#GmInfoContent_Form").form('enableValidation');
    }
    $("#GmInfoContent_Form").form('submit', {
        dataType: 'json',
        method: "POST",
        url: ctx + "/GmInfoContent/saveGmInfoContent?formcode=GmInfoContent",
        onSubmit: function (param) {
            var isValid = $(this).form('validate');
            if (!isValid) {
                alertWarn("请完善表单信息");
                return false;
            }
            layer.msg('数据发送中', {icon: 16, shade: 0.3, time: 0});
            return true;
        },
        success: function (result) {
            layer.closeAll();
            var reg = new RegExp("\\&quot;", "g");// g,表示全部替换。
            result = jQuery.parseJSON(result.replace(reg, ""));
            $('#GmInfoContent_Form').form('load', result.o);
            if (result.success) {
                if (status == "approve") {//有流程的发送
                    openFlowDialog({
                        processInstId: result.o.processinstid,
                        businessMainId: result.o.infoId,
                        formCode: "GmInfoContent",
                        callback: reloadGrid
                    });
                    $("#save").linkbutton("disable");
                    $("#submit_GmInfoContent").linkbutton("disable");
                    searchGmInfoContent();
                    var d = $(this).closest('.window').find('.window-body');
                    d.dialog('destroy');
                } else if (status == "preview") {
                    var d = $(this).closest('.window').find('.window-body');
                    d.dialog('refresh', ctx + "/GmInfoContent/viewGmInfoContent?id=" + result.o.infoId);
                    var url = ctx + "/GmInfoContent/previewGmInfoContent?id=" + result.o.infoId;
                    window.open(url);
                } else {//无流程的发送
                    $("#save").linkbutton("disable");
                    $("#submit_GmInfoContent").linkbutton("disable");
                    searchGmInfoContent();
                    var d = $(this).closest('.window').find('.window-body');
                    d.dialog('destroy');
                    alertInfo(result.msg);
                }
            }
        }
    });
}

//信息发布 取消按钮
function quitCommit() {
    var row = basegrid.datagrid('getSelected');
    if (row) {
        if (row.createAccount == accountId || row.createAccount == 0) {
            if (row.workflowStatus != '3') {
                alertWarn('信息未发布，无需取消');
                return;
            }
            $.ajax({
                url: ctx + "/GmInfoQuitcommit/quitcommit",
                data: {
                    infoId: row.infoId
                },
                dataType: "json",
                success: function (result) {
                    if (result.success) {
                        basegrid.datagrid('reload');
                        alertInfo("取消发布成功!")
                    } else {
                        alertError(result.msg);
                    }
                }
            })
        } else {
            alertWarn("只有该信息的发起人和管理员才能取消发布!");
            return false;
        }
    } else {
        alertWarn('请先选择一条数据信息');
        return false;
    }
}


// 信息采用
function infoUse() {
    let row = basegrid.datagrid('getSelected');
    if (row) {
        openChooseDialog({
            title: "请选择信息采用类型",
            contenturl: '/gmInfoContentUse/getGmInfoContentUseByInfoIdWin?infoId=' + row.infoId,
            width: 500,
            height: 150,
            okhandler: function () {
                $.ajax({
                    url: ctx + "/gmInfoContentUse/updateGmInfoContentUse",
                    async: false,
                    type: "post",
                    data: {
                        infoId: row.infoId,
                        infoUseType: $('#infoUseCombo').combobox('getValues').join(','),
                    },
                    dataType: "json",
                    success: function (result) {
                        if (result.success) {
                            basegrid.datagrid('reload');
                            alertInfo("信息采用设置成功!")
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
                return true;
            },
        });
    } else {
        alertWarn('请先选择一条数据信息');
        return false;
    }
}
