var webim;
$(function () {
    try {
        $.getScript(WebIMServer + "/static/js/WebIM.js", function () {
            $.post(WebIMServer + "/login", {loginCode: "admin", loginPassword: "admin_BT2020"}, function (result) {
                if (result.success) {
                    var sessionid = result.data;
                    webim = new WebIM({
                        token: sessionid
                    });
                } else {
                    console.log("登陆失败" + result.msg);
                }
            })
        })
    } catch (e) {
        console.log("WebIM初始化出错,可能是远程WebIM.js未加载");
        console.log(e);
    }

    initOrgtree();
    initGrid();
    bindEnterKey("#doSearch",doSearch);
});
var isLoad = false;//是否加载过grid
//初始话用户grid
function initGrid() {
    $('#basemp_datagrid').datagrid({
       // fit: true,
        singleSelect: true,
        rownumbers: true,
        fitColumns: true,
        pagination: true,
        url: ctx + '/basemp/pageall',
        toolbar: '#tb',
		cls:'md',
		height:getMixGridHeight(),
        columns: [[
//					{
//						field:'opt',title:'明细',width:40,align:'center',
//						formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
//							return '<div onclick="showDetail(\''+rowData.EMP_ID+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
//					}},
            {field: 'EMP_ID', title: 'EmpId', width: 100, hidden: true},
            {field: 'EMP_CODE', title: '员工编码', width: 100,halign:'center'},
            {field: 'EMP_NAME', title: '员工名称', width: 100,halign:'center'},
            {field: 'LOGIN_NAME', title: '登陆名称', width: 100,halign:'center'},
           /* {field: 'ORG_NAME', title: '组织名称', width: 100},
            {field: 'DEPT_NAME', title: '部门名称', width: 100},*/
            
            {field: 'ORG_DEPT_NAME', title: '组织部门名称', width: 200,halign:'center'},
            {field: 'PRESENT_JOB_TEXT_', title: '岗位', width: 100,halign:'center'},
            {field: 'SEX_TEXT_', title: '性别',align:'center',halign:'center',width: 40},
            {field: 'IS_APP', title: '手机端',align:'center',halign:'center', width: 50,
                formatter:function(value,row,index){
                    var title=value=='Y'?"点击禁用手机端":"点击启用手机端";
                    return "<a class='"+(value=='Y'?"icon-ok":"icon-no")+"' title=\""+title+"\" onclick=\"setApp()\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>";
                }
            },
            {field: 'IMEI', title: '绑定设备',align:'center',halign:'center', width: 70,
                formatter:function(value,row,index){
                    var title=value?"点击解除绑定,当前绑定信息["+(row.IMEI=='***'?"任意设备":(row.DEVICE_MODE+","+row.IMEI))+"]":"点击设置为无需绑定设备人员";
                    return "<a class='"+(value?(value=='***'?"el-tag el-tag--small el-tag--danger el-tag--light":"icon-ok"):"icon-no")+"' title=\""+title+"\" onclick=\"resetIMEI("+row.EMP_ID+",'"+(row.DEVICE_MODE?row.DEVICE_MODE:'')+"','"+(row.IMEI?row.IMEI:'')+"')\">"+(value=='***'?"任意":"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;")+"</a>";
                }
            },
			{field:'STATUS_TEXT_',title:'用户状态',align:'center',halign:'center',width:60,formatter:function(value){
				if(value=='注销'){
					return "<span class='el-tag el-tag--small el-tag--danger el-tag--light'>"+value+"</span>"
				}else{
					return '<span class="el-tag el-tag--small el-tag--success el-tag--light">'+value+'</span>'
				}
			}},
            {
                field: 'LOCKTIME', title: '解冻截止时间',halign:'center', width: 100, styler: function (value, row, index) {
                    if (value) {
                        return 'color:red;';
                    }
                }
            },
            {field:'det',title:'操作',width:140, align: 'center', halign: 'center',formatter:function(value,row,index){
                    var str ='<span class="rowbtn" onclick="$(\'#basemp_datagrid\').datagrid(\'selectRow\','+index+');allocateRoles(' + row.EMP_ID + ')" >角色分配</span>';
                    if(row.LOCK_TIME){
                        str+='|<span class="rowbtn" onclick="$(\'#basemp_datagrid\').datagrid(\'selectRow\','+index+');unlock()" >解冻用户</span>';
                    }
                    return "<div class='rowbtnbox'>"+str+"</div>";
                }
            }
//			          {field:'DISPLAY_NO',title:'排序',width:100,hidden:true}
        ]]
    });
    $('#basemp_datagrid').datagrid('doCellTip');
    var pager = $('#basemp_datagrid').datagrid('getPager');    // 得到datagrid的pager对象
    pager.pagination({
        buttons: [{
            iconCls: 'icon-page_excel',
            handler: function () {
                exportExcelSelCol('basemp_datagrid', "用户信息");
            }
        }]
    });
}
//解除设备绑定
function resetIMEI(empId,deviceMode,IMEI){
	var row = $('#basemp_datagrid').datagrid('getSelected');
	if(IMEI){
		alertConfirmYes('是否解除设备绑定['+(IMEI=='***'?"任意设备":deviceMode)+']？', function(r) {
			if (r) {
				$.ajax({
			        type: 'post',
			        dataType: 'json',
			        url: ctx + "/basemp/resetIMEI",
			        data : {
			        	empId : empId,
					},
			        success: function (result) {
			        	doSearch();
			            alertInfo(result.msg);
			        },
			        error: function () {
			            alertError("解除设备绑定出错");
			        }
			    });
			}
		});
	}else{
		alertConfirmYes('确认设置为无需绑定设备人员？', function(r) {
			if (r) {
				$.ajax({
			        type: 'post',
			        dataType: 'json',
			        url: ctx + "/basemp/resetIMEI",
			        data : {
			        	empId : empId,
			        	IMEI:"***"
					},
			        success: function (result) {
			        	doSearch();
			            alertInfo(result.msg);
			        },
			        error: function () {
			            alertError("解除设备绑定出错");
			        }
			    });
			}
		});
	}
}

//重新加载数据
function reloadGrid(orgid, deptid) {
    $('#basemp_datagrid').datagrid('reload', {
        orgid: orgid,
        deptid: deptid,
        search: $("#doSearch").val()
    });
}

//初始化组织机构tree
function initOrgtree() {
    $('#basemp_orgdepttree').tree({
        url: ctx + '/basorg/queryOrgAndDeptTree?type=1',
        onLoadSuccess: function (node, data) {
            // 默认显示根节点信息
            var root = $(this).tree('getRoot');
            if (node) {
                $(this).tree('select', node.target);
            } else {
                $(this).tree('collapseAll');
                $(this).tree('expand', root.target);
                $(this).tree('select', root.target);
            }
        },
        onSelect: function (node) {
            reloadGrid(node.attributes.org_id, node.attributes.dept_id);
        }
    });
}

function doSearch() {
    var node = $('#basemp_orgdepttree').tree('getSelected');
    reloadGrid(node.attributes.org_id, node.attributes.dept_id);
}

function unlock() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        alertConfirm('确定解冻该用户的登陆限制?', function (r) {
            if (r) {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + "/basemp/unlock?empId=" + row.EMP_ID,
                    success: function (result) {
                        if (result.success) {
                            $('#basemp_datagrid').datagrid('reload');
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertWarn('请选择一条记录进行操作');
    }

}


function resetPassword() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        alertConfirm('重置操作会将密码重置为默认密码,是否确定?', function (r) {
            if (r) {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + "/basemp/resetPassword?empId=" + row.EMP_ID,
                    success: function (result) {
                        if (result.success) {
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }, error: function () {
                        alertError("请求失败!");
                    }
                });
            }
        });
    } else {
        alertWarn('请选择一条记录进行操作');
    }
}

//刷新grid
function refreshGride() {
    $('#basemp_datagrid').datagrid('reload');
}

//点击新增加载数据方法
function addLoad() {
    var node = $('#basemp_orgdepttree').tree('getSelected');
    $('#org_Id').combotree('setValue',node.attributes.org_id);
    $('#dept_Id').combotree('setValue',node.attributes.dept_id);
    $("#documentid").val(generateUUID())
    $('#isVisual').combobox({readonly:true,onChange:function (val) {
            if (val ==='Y'){
                $("#empName").textbox({editable:true});
                $("#empName").next("span").find("a").hide();
            }
            else{
                $("#empName").textbox({editable:false});
                $("#empName").next("span").find("a").show();
            }
        }})

        $('#isVisual').combobox('setValue','Y');
//    if (node.attributes.org_name=='外部单位')
//        $('#isVisual').combobox('setValue','Y');
//    else
//        $('#isVisual').combobox('setValue','N');

}
function addEmp() {
	var node = $('#basemp_orgdepttree').tree('getSelected');
	  if (node.attributes.type=='1'){
		  outEmpAdd();
	  }else{
		  innerEmpReg();
	  }
}
//添加用户
function outEmpAdd() {
    var node = $('#basemp_orgdepttree').tree('getSelected');
    if (node&&node.attributes.dept_id!=null){
        openSaveDialog({
            title: "添加外部用户",
            width: 650,
            height: 400,
            contenturl: "/view/base/basempform",
            submiturl: "/basemp/saveemp",
            callback: refreshGride,
            onload: addLoad
        });
    }else {
        alertWarn('请选择部门进行操作');
    }


}
function innerEmpReg(){
	    var inputobj = formatterInputobj(this);
	    openChooseDialog({
	        title: "选择人员",
	        contenturl: "/view/sys/innerEmpSelectWin",
	        width: 800,
	        height: 450,
	        okhandler: function () {
	            var r = $('#empSelect_datagrid').datagrid('getSelected');
	            if (r) {
	            	var hrEmpId = r.hrEmpId;
	            	 alertConfirm('确认生成“'+r.empName+'”的用户信息?', function (r) {
	                     if (r) {
	                         $.ajax({
	                             type: 'post',
	                             dataType: 'json',
	                             url: ctx + "/hrEmp/regUserFromHr?hrEmpId=" + hrEmpId,
	                             success: function (result) {
	                                 if (result.success) {
	                                     alertInfo(result.msg);
	                                     $('#basemp_datagrid').datagrid('reload');
	                                 } else {
	                                     alertError(result.msg);
	                                 }
	                             }
	                         });
	                     }
	                 });
	                return true;
	            } else {
                    alertWarn("请选择人员");
	                return false;
	            }
	        },
	        onload: function () {
	            $('#empSelect_datagrid').datagrid({
	                onDblClickRow: function (index, r) {
	                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
	                    if (btns.length > 0) {
	                        $(btns[0]).click();
	                    }

	                }

	            })
	        }
	    })
}
//修改用户
function editEmp() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        openSaveDialog({
            title: "修改用户",
            width: 650,
            height: 400,
            contenturl: "/view/base/basempform",
            submiturl: "/basemp/saveemp",
            onload: formOnLoad,
            callback: refreshGride
        });
    } else {
        alertWarn('请先选择一条记录再进行修改');
    }
}

function formOnLoad() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: ctx + "/basemp/queryEmpById?empId=" + row.EMP_ID,
            success: function (data) {
                var submitform = $("#empManage_form");
                submitform.form('load', data);
            }
        });
    }
}

//删除用户
function delEmp() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        alertConfirm('删除操作会删除该用户及其权限组,是否确定?', function (r) {
            if (r) {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + "/basemp/delemp?empId=" + row.EMP_ID,
                    success: function (result) {
                        if (result.success) {
                            alertInfo(result.msg);
                            $('#basemp_datagrid').datagrid('reload');
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertWarn('请先选择一条记录再进行删除');
    }
}

function saveUser() {
    var url = ctx + "/basemp/saveemp.action";
    $('#empManage_form').form('submit', {
        url: url,
        dataType: 'json',
        onSubmit: function () {
            return $(this).form('validate');
        },
        success: function (data) {
            alertInfo("操作成功！");
            $('#empManage_window').window('close');
            $('#basemp_datagrid').datagrid('reload');
        },
        error: function (result) {
            alertError("失败！");
        }
    });
}


//用户帐套按钮
function showAccount() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    var index;
    if (row) {
        index = $('#basemp_datagrid').datagrid('getRowIndex', row);
        $('<div/>').dialog({
            href: ctx + '/view/base/basempAccount',
            width: 550,
            height: 400,
            modal: true,
            title: '用户帐套',
            onClose: function () {
                $(this).dialog('destroy');
                //关闭刷新列表页面
                refreshGride();
            },
            onLoad: function () {
                initAccounGrid(row["EMP_ID"]);
            }
        });
    } else {
        alertWarn('请先选择一条记录');
    }
}

//点击进入明细的界面
function showDetail(empid) {
    openDetailDialog({
        title: "用户详情",
        width: 650,
        height: 400,
        contenturl: "/basemp/basempdetail?id=" + empid
    });
}


//分配角色
function allocateRoles(empId){
    var node = $('#basemp_orgdepttree').tree('getSelected');
    var treeId = node.attributes.id;
    var orgId = node.attributes.org_id;
    var deptId = node.attributes.dept_id;
    var treeType = node.attributes.dtype;
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: ctx + "/basEmpAccount/findEmpAccountByEmpId?empId=" + empId,
        success: function (result) {
            if(result.length==1){
                var accountId = result[0].ACCOUNT_ID;
                    openDetailDialog({
                    title: "用户角色分配",
                    contenturl: '/view/base/BasRolesAllocate?accId='+accountId +'&treeId='+treeId+'&treeType='+treeType+'&orgId='+orgId+'&deptId='+deptId,
                    width: 970,
                    height: 560,
                });
            }
            if(result.length > 1){
                openChooseDialog({
                    title: "用户帐套",
                    contenturl: '/view/base/basempAccountDetail?empId='+empId,
                    width: 550,
                    height: 400,
                    okhandler: function () {
                        var row = $('#empAccount_datagrid').datagrid('getSelected');
                        if (row) {
                            var accountId = row.ACCOUNT_ID;
                            openDetailDialog({
                                title: "用户角色分配",
                                contenturl: '/view/base/BasRolesAllocate?accId='+accountId +'&treeId='+treeId+'&treeType='+treeType+'&orgId='+orgId+'&deptId='+deptId,
                                width: 970,
                                height: 560,
                            });
                        return true;}
                        else {
                            alertWarn("请选择帐套");
                            return false;
                        }
                    }
                })
            }

        },
        error: function () {
            alertError("数据请求失败");
        }
    });


}



function detailOnLoad(params) {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: ctx + "/sysemp/queryEmpById.action?empId=" + row["EMP_ID"],
        success: function (result) {
            $('#empManageDetail_form').form('LoadLabel', result);
            formatterDetailForm(dicresult);
        },
        error: function () {
            alertError("数据请求失败");
        }
    });
}

function initDD() {
    var loadIndex = layer.msg('数据同步中...', {
        icon: 16,
        shade: 0.3, time: 0
    });
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: ctx + "/app/userddsyn",
        success: function (result) {
            layer.close(loadIndex);
            alertInfo(result.msg);
        },
        error: function () {
            layer.close(loadIndex);
            alertError("数据同步出错");
        }
    });
}

function visualChange(rec) {
    var isVisual = rec.value;
    if (isVisual == 'Y') {//外部用户
    	
//        setCss($("#presentJob"), "combobox", false, true, false, true, true);
        setCss($("#org_Id"), "combotree", false, false, true, false, false);
        setCss($("#dept_Id"), "combotree", false, false, true, false, false);
        setCss($("#contactOrgId_TEXT_"), "textbox", false, false, true, false);
    } else {
//        setCss($("#presentJob"), "combobox", false, false, true, false);
        setCss($("#org_Id"), "combotree", false, true, true, true, false);
        setCss($("#dept_Id"), "combotree", false, true, true, true, false);
        setCss($("#contactOrgId_TEXT_"), "textbox", false, true, false, true, true);
    }
}


function initWebChatUsers() {
    if (webim) {
        var loadIndex = layer.msg('数据同步中...', {
            icon: 16,
            shade: 0.3, time: 0
        });
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: ctx + "/basemp/getAllWebChatUser",
            success: function (result) {
                webim.initUsers(result, function (data) {
                    layer.close(loadIndex);
                    if (data.success) {
                        alertInfo(data.msg);
                    } else {
                        alertError(data.msg);
                    }
                });

            },
            error: function () {
                layer.close(loadIndex);
                alertError("数据同步出错");
            }
        });
    } else {
        alertWarn("WebIM未能初始化");
    }

}



function cancelEmp() {
	 var row = $('#basemp_datagrid').datagrid('getSelected');
	    if (row) {
	        alertConfirm('注销后用户将无法登陆,是否确定?', function (r) {
	            if (r) {
	                $.ajax({
	                    type: 'post',
	                    dataType: 'json',
	                    url: ctx + "/basemp/cancelemp?empId=" + row.EMP_ID,
	                    success: function (result) {
	                        if (result.success) {
	                            alertInfo(result.msg);
	                            $('#basemp_datagrid').datagrid('reload');
	                        } else {
	                            alertError(result.msg);
	                        }
	                    }
	                });
	            }
	        });
	    } else {
	        alertWarn('请先选择一条记录再进行删除');
	    }

}

function setApp() {
	var row = $('#basemp_datagrid').datagrid('getSelected');
	var isApp = 'Y';
	if(row.IS_APP=='Y'){
		alertConfirmYes('是否取消该用户手机端权限？', function(r) {
			if (r) {
				isApp = 'N';
				setIsApp(row.EMP_ID,isApp)
			}
		});
	}else{
		setIsApp(row.EMP_ID,isApp)
	}
	
}

function setIsApp(empId,isApp){
	 $.ajax({
	        type: 'post',
	        dataType: 'json',
	        url: ctx + "/basemp/setApp",
	        data : {
	        	empId : empId,
	        	isApp : isApp
			},
	        success: function (result) {
	        	doSearch();
	            alertInfo(result.msg);
	        },
	        error: function () {
	            alertError("设置手机端出错");
	        }
	    });
}