
var basMessageDeadlineGrid = $("#basMessageDeadlineGrid");
$(function(){
	initBasMessageDeadlineGrid();
});


/**
 * 初始化
 */
function initBasMessageDeadlineGrid(){
	basMessageDeadlineGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:false,
		fitColumns:true,
		pagination:true,
		queryParams:{
			isCustom:'N'
		},
		cls:'md',
		toolbar:"#basMessageDeadlineGridTbar",
	    url:ctx+'/basMessageDeadline/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basMessageDeadlineFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',hidden:true},
	    {field:'timeTypeText',title:'时间计算',width:100,align:'center',halign:'center',sortable:true},
	    {field:'processTime',title:'办理时长',width:100,align:'center',halign:'center',sortable:true},
			{field:'color',title:'标识颜色',width:40,align:'center',halign:'center',formatter:function(value){
					return '<div style="width:20px;height:20px;background-color:'+value+';margin:0 atuo;display: inline-block;"></div>'
				}}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basMessageDeadlineFormDetail(row.id);
	    }
	});
	
    basMessageDeadlineGrid.datagrid('doCellTip');
    var pager = basMessageDeadlineGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basMessageDeadlineGrid',"流程时长提醒设置")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basMessageDeadlineFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		width:550,
		height:300,
		contenturl:"/GenForm/form?formcode=BasMessageDeadline&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasMessageDeadline(){
	basMessageDeadlineGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasMessageDeadline(){
	basMessageDeadlineGrid.datagrid('load',{

	});
}


/**
 * 增加
 */
function addBasMessageDeadline() {
	openSaveDialog({
		title : "添加记录",
		width:550,
		height:300,
		contenturl : "/GenForm/form?formcode=BasMessageDeadline",
		submiturl : "/basMessageDeadline/saveBasMessageDeadline?formcode=BasMessageDeadline",
		callback : reloadBasMessageDeadline
	});
	
}


/**
 * 修改
 */
function editBasMessageDeadline() {

	var row = basMessageDeadlineGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		width:550,
		height:300,
		contenturl:"/GenForm/form?formcode=BasMessageDeadline&id=" + row.id,
		submiturl:"/basMessageDeadline/saveBasMessageDeadline?formcode=BasMessageDeadline",
		callback : reloadBasMessageDeadline
	});
}


/**
 * 删除
 */
function delBasMessageDeadline() {

	var row = basMessageDeadlineGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basMessageDeadline/delBasMessageDeadline",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basMessageDeadlineGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}


