var BasUsedFunctionDataGrid = $('#BasUsedFunction_datagrid');
$(function() {
	initBasUsedFunctionGrid();
});

function initBasUsedFunctionGrid() {
	BasUsedFunctionDataGrid.datagrid({
				//fit : true,
				border : false,
				singleSelect : true,
				rownumbers : true,
				fitColumns : true,
				cls:'md',
				pagination:true,
				height:getMixGridHeight(),
				toolbar : "#BasUsedFunction_datagrid_tb",
				url : ctx + '/BasUsedFunction/pageBasUsedFunction',
				columns : [ [
						{
							field : 'opt',
							title : '明细',
							width : 40,
							align : 'center',
							formatter : function(value, row, index) { // value表示字段的值,rowData行记录数据,index行索引
								return '<div onclick="BasUsedFunctionFormDetail('
										+ row.id
										+ ')" class="icon-detail iconfont blue">&nbsp;</div>';
							}
						},
						{
							field : 'functionName',
							title : '名称',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true
						},
						{
							field : 'functionIco',
							title : '图标',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true,
							formatter : function(value, row, index) { // value表示字段的值,rowData行记录数据,index行索引
								return '<div class="' + value
										+ ' iconfont blue">&nbsp;</div>';
							}
						},
						{
							field : 'functionColor',
							title : '颜色',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true,
							formatter : function(value, row, index) {
								// value表示字段的值,rowData行记录数据,index行索引
								return '<div class="layui-inline" style="width:20px;height:20px;background-color:  '
										+ value + ';"></div>';
							}
						}, {
							field : 'belongMenuName',
							title : '所属板块',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true
						}, {
							field : 'menuName',
							title : '系统页面',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true
						}, {
							field : 'menuAddr',
							title : '地址',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true
						}, {
							field : 'remark',
							title : '备注',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true
						}, {
							field : 'displayNo',
							title : '排序',
							width : 100,
							align : 'center',
							halign : 'center',
							sortable : true
						} ] ],
				onDblClickRow : function(index, row) {
					// 查看明细
					BasUsedFunctionFormDetail(row.id);
				}
			});
	BasUsedFunctionDataGrid.datagrid('doCellTip');
	var pager = BasUsedFunctionDataGrid.datagrid('getPager');
	pager.pagination({
		buttons : [ {
			iconCls : 'icon-page_excel',
			handler : function() {
				exportExcel('BasUsedFunction_datagrid', "栏目常用功能");
			}
		} ]
	});
}
// 查看表单明细
function BasUsedFunctionFormDetail(id) {
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasUsedFunction&isdetail=true&id="
				+ id
	});
}
// 重新加载表格
function reloadBasUsedFunction() {
	BasUsedFunctionDataGrid.datagrid('reload');
}
// 查询表格
function searchBasUsedFunction() {
	BasUsedFunctionDataGrid.datagrid('load', {
		search : $("#searchBasUsedFunction").val()
	});
}

// 增加记录
function addBasUsedFunction() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasUsedFunction",
		submiturl : "/BasUsedFunction/saveBasUsedFunction?formcode=BasUsedFunction",
		callback : reloadBasUsedFunction
	});

}

// 修改记录
function editBasUsedFunction() {
	var row = BasUsedFunctionDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl : "/GenForm/form?formcode=BasUsedFunction&id=" + id,
			submiturl : "/BasUsedFunction/saveBasUsedFunction?formcode=BasUsedFunction",
			onload : function (){
				var pid =  $('#belongMenu').combotree('getValue');
				$('#menuId').combotree('reload', ctx+'/BasMenu/treeBasMenu?pid='+pid);
			},
			callback : reloadBasUsedFunction
		});

	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

// 删除记录
function delBasUsedFunction() {
	var row = BasUsedFunctionDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx + "/BasUsedFunction/delBasUsedFunction",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasUsedFunctionDataGrid.datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
