var basegrid=$('#BasSpaceDefine_datagrid');
$(function(){
	initGrid();
	bindEnterKey("#searchBasSpaceDefine",searchBasSpaceDefine);
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		toolbar:"#BasSpaceDefine_datagrid_tb",
	    url:ctx+'/BasSpaceDefine/pageBasSpaceDefine',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+index+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'spaceType',hidden:true},
	    {field:'spaceTypeText',title:'空间类型',width:70,align:'center',halign:'center',sortable:true},
	    {field:'spaceName',title:'空间名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'spaceTemplate',title:'备注',width:100,align:'left',halign:'center',sortable:true},
	    {field:'creationType',hidden:true},
	    {field:'orgId',hidden:true},
	    {field:'isModify',hidden:true},
	    {field:'isModifyText',title:'是否允许自定义',width:50,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(index);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasSpaceDefine_datagrid',"空间信息");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(index){
	basegrid.datagrid("selectRow",index);
	var row = basegrid.datagrid('getSelected');
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSpaceDefine&isdetail=true&id="+row.spaceId,
		onload:function(){
			var item = $('#configType').val() ;
			if ("1"==item){//空间链接
				$("#component").closest(".easyui-tabs").hide();
				$("#spaceLink_span").closest("tr").show();
			}else if ("2"==item){//分配组件
				$("#spaceLink_span").closest("tr").hide();
				$("#component").closest(".easyui-tabs").show();
			}
		}
	
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasSpaceDefine(spaceType){
	basegrid.datagrid('load',{
		search:$("#searchBasSpaceDefine").val(),
		spaceType:spaceType
	});
}

//增加记录
function addBasSpaceDefine() {
	openSaveDialog({
		title:"添加记录",	
		/*bottons : [ {
			text : "分配组件",
			id : 'allocate_BasSpaceComponent',
			iconCls : 'icon-page-printer',
			handler : function() {
				allocateBasSpaceComponent();
			}
		}],*/
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSpaceDefine&isdetail=false",
		submiturl:"/BasSpaceDefine/saveBasSpaceDefine?formcode=BasSpaceDefine",
		callback:reloadGrid,
		onload:function (){
			var item = $('#configType').combobox('getValue') ;
			changeConfigType(item);
		},
		onsubmit:function(param){
			param.data = getBasSpaceUseData();
			return true;
		}
	});
	
}

//修改记录
function editBasSpaceDefine() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.spaceId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasSpaceDefine&isdetail=false&id=" + id,
			submiturl:"/BasSpaceDefine/saveBasSpaceDefine?formcode=BasSpaceDefine",
			callback : reloadGrid,
			onsubmit:function(param){
				param.data = getBasSpaceUseData();
				return true;
			},
			onload : function(){
				var n = $('#spaceType').combobox('getValue') ;
				var item = $('#configType').combobox('getValue') ;
				changeConfigType(item);
					   if(n == '2'){  //领导空间
					     $('#empLv').combobox('setValue','1');
					     setCss($('#menuId'),'combotree',false,false,true,false,null);
					   }else if(n == '3'){  //部门空间
					     $('#empLv').combobox('setValue','2');
					     setCss($('#menuId'),'combotree',false,false,true,false,null);
					   }else if(n == '4'){  //员工空间
					    $('#empLv').combobox('setValue','3');
					     setCss($('#menuId'),'combotree',false,false,true,false,null);
					  }else if(n == '5'){  //栏目空间
						     setCss($('#menuId'),'combotree',false,false,true,false,null);
					}else{
					    setCss($('#menuId'),'combotree',false,true,false,true,null);
					 }
			}
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasSpaceDefine() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.spaceId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasSpaceDefine/delBasSpaceDefine",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}


//空间布局,  同时可以在预览中修改组件的顺序
function allocateSpace(){
	var row = basegrid.datagrid('getSelected');
	if(row){
		if ("1"==row.configType){//空间链接
			alertWarn('空间配置属性为链接，无需布局');
			return false;
		}
		var url = ctx+"/BasSpaceDefine/previewSpaceDrag?spaceId=" +row.spaceId;
		window.open(url);
	}else{
		alertWarn('请先选择一条数据信息');
		return false;
	}
}

//空间预览
function previewSpace(){
	var row = basegrid.datagrid('getSelected');
	if(row){
		var url = ctx+"/BasSpaceDefine/priewSpace?spaceId=" +row.spaceId+"&isModify=N";
		window.open(url);
	}else{
		alertWarn('请先选择一条数据信息');
		return false;
	}
}
function changeConfigType(n){
	console.log("n==="+n);
	if ("1"==n){//空间链接
		$("#component").closest(".easyui-tabs").hide();
		$("#spaceLink").closest("tr").show();
		setCss($("#spaceLink"),"textbox",true,false,true,false,null);
		setCss($("#isModify"),"textbox",false,true,false,true,null);
		$("#isModify").combobox('setValue','N');
		//删除组件信息
		removeAll();
	}else if ("2"==n){//分配组件
		$("#spaceLink").textbox("setValue","");
		$("#spaceLink").closest("tr").hide();
		setCss($("#spaceLink"),"textbox",false,true,false,true,null);
		setCss($("#isModify"),"textbox",true,false,true,false,null);
		//$("#isModify").combobox('setValue','Y');
		$("#component").closest(".easyui-tabs").show();
	}
}

