var basegrid=$('#BasMessage_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasMessage_datagrid_tb",
	    url:ctx+'/BasMessage/pageBasMessage',
	    columns:[[
	    {field:'MSG_ID',title:'msgId'},
	    {field:'MSG_TITLE',title:'消息标题'},
	    {field:'MSG_URL',title:'消息地址'},
	    {field:'MSG_TYPE',hidden:true},
	    {field:'MSG_TYPE_TEXT_',title:'消息类型'},
	    {field:'BUSI_TYPE',hidden:true},
	    {field:'BUSI_TYPE_TEXT_',title:'业务类型'},
	    {field:'SENDER',title:'发送人'},
	    {field:'SENDTIME',title:'发起时间'},
	    {field:'IS_PUBLIC',title:'isPublic'},
	    {field:'IS_USE',title:'isUse'}
	    ]]
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}

function searchBasMessage(){
	basegrid.datagrid('load',{
		search:$("#searchBasMessage").val()
	});
}

//增加数据字典
function addBasMessage() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/base/BasMessageform",
		submiturl:"/BasMessage/saveBasMessage",
		callback:reloadGrid
	});
	
}

//修改数据字典
function editBasMessage() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.MSG_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/base/BasMessageform",
			submiturl : "/BasMessage/saveBasMessage",
			onload : "/BasMessage/findBasMessage?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delBasMessage() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.MSG_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMessage/delBasMessage",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
