var basegrid=$('#BasMenuLink_datagrid');
$(function(){
	initGrid();
	bindEnterKey("#searchBasMenuLink",searchBasMenuLink);
});

function initGrid(){
	basegrid.datagrid({
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination: true,
		cls: 'md',
		// height: $("body").height() - 120,
		toolbar:"#BasMenuLink_datagrid_tb",
		url:ctx+'/BasMenuLink/pageBasMenuLink',
		columns:[[
			{
				field:'opt',title:'查看',width:40,align:'center',
				formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
					return '<div onclick="openFormDetail(\''+row.menuAddr+'\',\''+row.menuName+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
				}},
//	    {field:'id',title:'id',width:100,align:'center',halign:'center'},
//	    {field:'menuId',title:'menuId',width:100,align:'center',halign:'center'},
			{field:'menuName',title:'名称',width:150,align:'center',halign:'center'},
//	    {field:'menuAddr',title:'地址',width:100,align:'left',halign:'center'},
//	    {field:'menuIco',title:'图标',width:100,align:'center',halign:'center'},
			{field:'enableText',title:'是否启用',width:80,align:'center',halign:'center'},
			{field:'displayNo',title:'排序',width:60,align:'center',halign:'center'},
			{field:'remark',title:'说明',width:200,align:'center',halign:'center'}
		]],
		onDblClickRow:function(index, row){
			//查看明细
			editBasMenuLink()
		}
	});
	basegrid.datagrid('doCellTip');
	var pager = basegrid.datagrid('getPager');
	pager.pagination({
		buttons:[{
			iconCls:'icon-page_excel',
			handler:function(){
				exportExcel('BasMenuLink_datagrid',"title");
			}
		}]
	});
}
//查看表单明细
function openFormDetail(menuaddr,menuName){
	if (parent && parent.openInMainTab) {
		var tab = parent.openInMainTab(menuName, menuaddr);
	} else {
		window.open(ctx + menuaddr, '_blank');
	}
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasMenuLink(){
	basegrid.datagrid('load',{
		search:$("#searchBasMenuLink").val()
	});
}

//增加记录
function addBasMenuLink() {
	$.ajax({
		url : ctx+"/BasMenuLink/getMaxDisplayNo",
		dataType : 'json',
		success : function(result) {
			if (result.success) {
				basegrid.datagrid('reload');
				openSaveDialog({
					title:"添加记录",
//					maximized : true,
					height: 400,
					contenturl:"/GenForm/form?formcode=BasMenuLink",
					submiturl:"/BasMenuLink/saveBasMenuLink?formcode=BasMenuLink",
//					contenturl:"/view/base/BasMenuLink",
//					submiturl:"/BasMenuLink/saveBasMenuLink",
					callback:reloadGrid,
					onload : function (){
						$('#displayNo').numberbox('setValue',result.o);
					}
				});
			}else{
				alertError(result.msg);
			}
		}
	});


}

//修改记录
function editBasMenuLink() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
//			maximized : true,
			height: 400,
			contenturl:"/GenForm/form?formcode=BasMenuLink&id=" + id,
			submiturl:"/BasMenuLink/saveBasMenuLink?formcode=BasMenuLink",
//			contenturl : "/view/base/BasMenuLink",
//			submiturl : "/BasMenuLink/saveBasMenuLink",
//			onload : "/BasMenuLink/findBasMenuLink?id=" + id,
			callback : reloadGrid
		});

	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasMenuLink() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMenuLink/delBasMenuLink",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}

function changeBusinessType(v){
	if(v=='2'){
		setCss($('#menuId'),"combotree",false,true,false,true,true);
		setCss($('#menuAddr'),"textbox",true,false,true,false,true);
	}else{
		setCss($('#menuId'),"combotree",false,false,true,false,true);
		setCss($('#menuAddr'),"textbox",false,true,false,true,false);
	}
}
function moveupBasMenuLink() {
	var selections = basegrid.datagrid('getSelections');
	if (! selections.length) {
		alertWarn('请先选择要移动的项目属性');
		return;
	}
	// 多行移动(上移)
	for(var i = 0; i < selections.length; i++){
		var index = basegrid.datagrid('getRowIndex',selections[i]);
		if(index <= 0){
			return;
		}
		// 当前行
		var toup = selections[i];
		// 当前行的上一行,即移往的行
		var todown = basegrid.datagrid('getData').rows[index - 1];
		basegrid.datagrid('getData').rows[index] = todown;
		basegrid.datagrid('getData').rows[index - 1] = toup;
		basegrid.datagrid('refreshRow', index);
		basegrid.datagrid('refreshRow', index - 1);
		// 支持多选,因此要先取消选中之前的选中行
		basegrid.datagrid('unselectRow', index );
		basegrid.datagrid('selectRow', index - 1);
	}
}

// 下移
function movedownBasMenuLink() {
	var selections = basegrid.datagrid('getSelections');
	if (! selections.length) {
		alertWarn('请先选择要移动的项目属性');
		return;
	}
	// 多行移动(下移)
	var length = basegrid.datagrid("getRows").length;
	for(var i = 0; i < selections.length; i++){
		// 从最下面的选中列判断
		var $i = selections.length-1-i;
		var index = basegrid.datagrid('getRowIndex',selections[$i]);
		if(index >= length-1){
			return;
		}
		// 当前行
		var todown = selections[$i];
		// 当前行的下一行,即移往的行
		var toup = basegrid.datagrid('getData').rows[index + 1];
		basegrid.datagrid('getData').rows[index + 1] = todown;
		basegrid.datagrid('getData').rows[index] = toup;
		basegrid.datagrid('refreshRow', index);
		basegrid.datagrid('refreshRow', index + 1);
		// 支持多选,因此要先取消选中之前的选中行
		basegrid.datagrid('unselectRow', index );
		basegrid.datagrid('selectRow', index + 1);
	}
}

function saveDisplayNo() {
	$('#saveDisplayNo').linkbutton('disable');
	// 已分配里程碑节点列表grid信息
	var rows = basegrid.datagrid('getRows');
	if(! rows.length){
		$('#saveDisplayNo').linkbutton('enable');
		return;
	}
	var ids=new Array();
	$.each(rows,function(index,value){
		ids.push({
			id:value.id
		});
	});
	var effectRow = new Object();
	effectRow["data"] = JSON.stringify(ids);

	var saveUrl = ctx + "/BasMenuLink/saveBasMenuLinkDisplayNo";
	// 所有datagrid的数据均传入后台
	// 后台根据index进行排序并保存
	$.post(saveUrl, effectRow, function(result) {
		alertInfo('保存排序成功');
		basegrid.datagrid('reload');
		// 启用按钮
		$('#saveDisplayNo').linkbutton('enable');
	}, "JSON").error(function() {
		alertError('保存排序失败，请重试');
		// 启用按钮
		$('#saveDisplayNo').linkbutton('enable');
	});
}