var basegrid=$('#BasMeasureUnit_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
//		fitColumns:true,
		pagination:true,
		toolbar:"#BasMeasureUnit_datagrid_tb",
	    url:ctx+'/BasMeasureUnit/pageBasMeasureUnit',
	    columns:[[
	    {field:'MEASURE_UNIT_ID',hidden:true},
	    {field:'MEASURE_UNIT_NAME',title:'单位名称',width:200,align:'center',halign:'center'},
	    {field:'MEASURE_UNIT_ALIAS',title:'单位简称',width:200,align:'center',halign:'center'},
	    {field:'DISPLAY_NO',title:'排序',width:100,align:'right',halign:'center'}
	    ]],
	    onDblClickRow : editBasMeasureUnit
	});

}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasMeasureUnit(){
	basegrid.datagrid('load',{
		search:$("#searchBasMeasureUnit").val()
	});
}

//增加记录
function addBasMeasureUnit() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/base/BasMeasureUnitform",
		submiturl:"/BasMeasureUnit/saveBasMeasureUnit",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasMeasureUnit() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.MEASURE_UNIT_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/base/BasMeasureUnitform",
			submiturl : "/BasMeasureUnit/saveBasMeasureUnit",
			onload : "/BasMeasureUnit/findBasMeasureUnit?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasMeasureUnit() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.MEASURE_UNIT_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMeasureUnit/delBasMeasureUnit",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
