var basegrid=$('#BasMeassageSetting_datagrid');
$(function(){
	initGrid();
	bindEnterKey("#searchBasMeassageSetting",searchBasMeassageSetting);
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasMeassageSetting_datagrid_tb",
	    url:ctx+'/BasMeassageSetting/pageBasMeassageSetting',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',title:'ID',width:100,align:'center',halign:'center'},
	    {field:'businessTypeId',title:'流程目录id',width:100,align:'center',halign:'center'},
	    {field:'pcMsg',title:'PC端消息',width:100,align:'center',halign:'center'},
	    {field:'appMsg',title:'app端消息',width:100,align:'center',halign:'center'},
	    {field:'microMsg',title:'微应用消息',width:100,align:'center',halign:'center'},
	    {field:'applyAccount',title:'应用人员',width:100,align:'center',halign:'center'},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.id);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasMeassageSetting_datagrid',"用户消息配置");
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasMeassageSetting&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasMeassageSetting(){
	basegrid.datagrid('load',{
		search:$("#searchBasMeassageSetting").val()
	});
}

//增加记录
function addBasMeassageSetting() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasMeassageSetting",
		submiturl:"/BasMeassageSetting/saveBasMeassageSetting?formcode=BasMeassageSetting",
//		contenturl:"/view/base/BasMeassageSetting",
//		submiturl:"/BasMeassageSetting/saveBasMeassageSetting",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasMeassageSetting() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasMeassageSetting&id=" + id,
			submiturl:"/BasMeassageSetting/saveBasMeassageSetting?formcode=BasMeassageSetting",
//			contenturl : "/view/base/BasMeassageSetting",
//			submiturl : "/BasMeassageSetting/saveBasMeassageSetting",
//			onload : "/BasMeassageSetting/findBasMeassageSetting?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasMeassageSetting() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMeassageSetting/delBasMeassageSetting",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
