var basegrid=$('#BasInterfaceOptlog_datagrid');
$(function(){
	initGrid();
	bindEnterKey('#searchBasInterfaceOptlog',searchBasInterfaceOptlog);
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			interfaceName:interfaceName,
		},
		toolbar:"#BasInterfaceOptlog_datagrid_tb",
	    url:ctx+'/BasInterfaceOptlog/pageBasInterfaceOptlog',
	    columns:[[
	    {field:'LOG_ID',title:'',hidden:true},
				{field:'operateTime',title:'接口日期',width:80,align:'center',halign:'center'},
				{field:'operateAccount',title:'创建人',width:80,align:'center',halign:'center'},
				{field:'operateName',title:'接口类型',width:80,align:'center',halign:'center'},
	    {field:'operateIp',title:'访问IP',width:80,align:'left',halign:'center'},
	    // {field:'OPERATE_METHOD',title:'访问方法',width:200,align:'left',halign:'center'},
	  //   {field:'OPERATE_RESULT',title:'访问状态',width:50,align:'center',halign:'center',
	  //   formatter: function(value,row,index){
		// 		if (value=='N'){
		// 			return "失败";
		// 		} else {
		// 			return "正常";
		// 		}
		// 	}
		// },
	    {field:'OPERATE_DETAIL',title:'日志明细',width:100,align:'center',halign:'center',
	    formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
							return '<div onclick="showDetail(\''+index+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
					}}
	    ]],
	    rowStyler: function(index,row){
			if (row.OPERATE_RESULT=='N'){
				return 'background-color:red;color:white;';
			}
		}
	});
	basegrid.datagrid('doCellTip');
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasInterfaceOptlog_datagrid',"操作日志信息");   
	        }    
	    }]   
	}); 
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasInterfaceOptlog(){
	basegrid.datagrid('load',{
		search:$("#searchBasInterfaceOptlog").val(),
		interfaceName:interfaceName,
		interfaceLogType:$("#interfaceLogType").combobox("getValue"),
		startTime:$("#startTime").val(),
		endTime:$("#endTime").val(),
	});
}


//删除记录
function delBasInterfaceOptlog() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.LOG_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasInterfaceOptlog/delBasInterfaceOptlog",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}

function showDetail(index){
	basegrid.datagrid('selectRow',index);
	var content=basegrid.datagrid('getSelected').operateDetail;
	$('#BasInterfaceOptlog_dialog').dialog({   
		content:content
	}); 
	$('#BasInterfaceOptlog_dialog').dialog('open'); 
}

function showconsolelog(){
	openDetailDialog({
		title:"控制台日志",
		width:500,
		height:400,
		contenturl:'/view/base/consolelogs'
	})
}
