var basegrid=$('#BasDeviceUser_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasDeviceUser_datagrid_tb",
	    url:ctx+'/BasDeviceUser/pageBasDeviceUser',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',title:'id',width:100,align:'center',halign:'center'},
	    {field:'clientId',title:'设备id',width:100,align:'center',halign:'center'},
	    {field:'accountId',title:'用户id',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.id);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasDeviceUser_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasDeviceUser&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasDeviceUser(){
	basegrid.datagrid('load',{
		search:$("#searchBasDeviceUser").val()
	});
}

//增加记录
function addBasDeviceUser() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasDeviceUser",
		submiturl:"/BasDeviceUser/saveBasDeviceUser?formcode=BasDeviceUser",
//		contenturl:"/view/base/BasDeviceUser",
//		submiturl:"/BasDeviceUser/saveBasDeviceUser",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasDeviceUser() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasDeviceUser&id=" + id,
			submiturl:"/BasDeviceUser/saveBasDeviceUser?formcode=BasDeviceUser",
//			contenturl : "/view/base/BasDeviceUser",
//			submiturl : "/BasDeviceUser/saveBasDeviceUser",
//			onload : "/BasDeviceUser/findBasDeviceUser?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasDeviceUser() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasDeviceUser/delBasDeviceUser",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
