pageAll
===
with temp as (with recursive cte as (
select t.ACCOUNT_ID, T.FNUMBER id,t.COMPANYNUMBER, t.FLONGNAME_L2 as text,t.FLONGNAME_L2 path
from
FM_ACCOUNT t  
where t.is_use = 'Y' AND T.ACCOUNT_PID= 0
union all
select t.ACCOUNT_ID,T.FNUMBER id,t.COMPANYNUMBER,concat( cte.text, '/', t.FLONGNAME_L2 ) as text,substr( concat( cte.text, '/', t.FLONGNAME_L2 ),  1, length( concat( cte.text, '>', t.FLONGNAME_L2 ))) path
from FM_ACCOUNT t,cte  
where t.is_use = 'Y'  and cte.ACCOUNT_ID = t.ACCOUNT_PID )
select  cte.*,o.org_id from cte,bas_org o
WHERE cte.COMPANYNUMBER = o.TO_FINANCE_CODE
order by cte.id )
select
t.attr_Id,
t.asset_Attribute,
d.dic_text as asset_attribute_text,
t.is_Card,
t.depreciation_Limit,
t.org_id,
t.account_no,
t.zj_budget_no,
t.jz_budget_no,
CONCAT(temp.id,'-',temp.path) as account_name,
CONCAT(b.id,'-',b.path) as zj_budget_name,
CONCAT(c.id,'-',c.path) as jz_budget_name
from PUB_ASSETS_ATTR t
left join temp  on  t.account_no = temp.id and t.org_id = temp.org_id
left join temp b on t.zj_budget_no = b.id and t.org_id = b.org_id
left join temp c on t.jz_budget_no = c.id and t.org_id = c.org_id
left join bas_dic d on t.asset_Attribute = d.dic_value and d.dic_code = 'ASSETS_TYPE_ONE'
where t.is_use = 'Y'
and t.CATEGORY_ID=#mainId#

getGroupAccount
===
with recursive cte as
 (select t.*, t.FLONGNAME_L2 as text, t.FLONGNAME_L2 path
    from FM_ACCOUNT t
   where t.is_use = 'Y'
     AND T.ACCOUNT_PID = 0
  union all
  select t.*,
         concat(cte.text, '/', t.FLONGNAME_L2) as text,
         substr(concat(cte.text, '/', t.FLONGNAME_L2),
                1,
                length(concat(cte.text, '>', t.FLONGNAME_L2))) path
    from FM_ACCOUNT t, cte
   where t.is_use = 'Y'
     and cte.ACCOUNT_ID = t.ACCOUNT_PID)
select cte.FNUMBER id,
       cte.ACCOUNT_ID,
       concat('(', cte.fnumber, ')', cte.FNAME_L2) text,
       (select p.FNUMBER
          from fm_account p
         where p.account_id = cte.ACCOUNT_PID) pid,
       CONCAT(cte.FNUMBER, '-', cte.path) as account_name,
       o.org_id
  from cte, bas_org o
 WHERE o.ORG_ID = #orgId# 
   AND cte.COMPANYNUMBER = o.TO_FINANCE_CODE
 order by cte.FNUMBER


getComboByCategoryId
===
select
    t.asset_Attribute id,
    d.DIC_VALUE value,
    d.dic_text text
from PUB_ASSETS_ATTR t
left join bas_dic d on t.asset_Attribute = d.dic_value and d.dic_code = 'ASSETS_TYPE_ONE'
where t.is_use = 'Y' and t.CATEGORY_ID = #categoryId#