select
===
select @pageTag(){
				t.SPACE_ID,
		t.SPACE_TYPE,
		GETDICNAME('SPACE_TYPE',t.SPACE_TYPE) SPACE_TYPE_TEXT,
		t.SPACE_NAME,
		t.SPACE_TEMPLATE,
		t.CREATION_TYPE,
		GETDICNAME('SYS_DATA_CREATION_TYPE',t.CREATION_TYPE) CREATION_TYPE_TEXT,
		t.ORG_ID,
		(select group_concat(b.ORG_NAME) from BAS_ORG b where instr(concat(',', t.ORG_ID , ','),concat( ',' , b.ORG_ID , ',')) != 0)  ORG_NAME,
		t.IS_MODIFY,
		GETDICNAME('IS_OR_NOT',t.IS_MODIFY) IS_MODIFY_TEXT,
		t.CREATE_ACCOUNT,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
		t.config_Type
	 @}
from BAS_SPACE_DEFINE t 
left join bas_menu m on t.MENU_ID =m.MENU_ID and m.IS_USE = 'Y'
where t.is_use = 'Y'
@if(!isEmpty(search)){
and(
 upper(t.SPACE_NAME) like #search# ESCAPE '/'   or 
 upper(t.SPACE_TEMPLATE) like #search# ESCAPE '/' 
)@}
@if(!isEmpty(spaceType)){
 and t.SPACE_TYPE = #spaceType#
@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.space_type,m.DISPLAY_NO ,T.EMP_LV
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}


getUseUserIdTextBySpaceId
===
select 
p.user_id,
p.user_name
from BAS_SPACE_DEFINE t 
left join (select g.SPACE_ID,
         GROUP_CONCAT(concat(g.user_type,':',g.user_id) ORDER BY g.SPACE_ID) user_id,
         GROUP_CONCAT((case
                   when g.user_type = 'dept' then
                    getdeptname(g.user_id)
                   when g.user_type = 'org' then
                    getbaseabbr(g.user_id)
                   when g.user_type = 'user' then
                    getaccountname(g.user_id)
                 end) ORDER BY g.SPACE_ID) user_name
    from BAS_SPACE_USE g
   where g.is_use = 'Y'
   group by g.SPACE_ID) p on t.SPACE_ID = p.SPACE_ID
where t.is_use = 'Y'
@if(!isEmpty(spaceId)){
	and t.SPACE_ID=#spaceId#
@}


getManageUserIdTextBySpaceId
===
select 
p.user_id,
p.user_name
from BAS_SPACE_DEFINE t 
left join (select g.SPACE_ID,
         GROUP_CONCAT(concat(g.user_type,':',g.user_id) ORDER BY g.SPACE_ID) user_id,
         GROUP_CONCAT((case
                   when g.user_type = 'dept' then
                    getdeptname(g.user_id)
                   when g.user_type = 'org' then
                    getbaseabbr(g.user_id)
                   when g.user_type = 'user' then
                    getaccountname(g.user_id)
                 end) ORDER BY g.SPACE_ID) user_name
    from BAS_SPACE_USE g
   where g.is_use = 'Y'
   group by g.SPACE_ID) p on t.SPACE_ID = p.SPACE_ID
where t.is_use = 'Y'
@if(!isEmpty(spaceId)){
	and t.SPACE_ID=#spaceId#
@}

getMySpaceList
===
SELECT s.*
  FROM BAS_SPACE_define s,
       (select u.SPACE_ID, 4 ds
          from BAS_SPACE_use u
         where u.user_type = 'org'
           and #orgId# in
               (WITH recursive temp AS (SELECT a.*
                   FROM bas_org AS a
                  WHERE a.ORG_ID = u.USER_ID
                 UNION ALL
                 SELECT a.*
                   FROM bas_org AS a, temp t
                  WHERE t.org_id = a.PORG_ID)  SELECT org_id FROM temp t
                )
           AND u.is_use = 'Y'
        union all
        select u.SPACE_ID, 3 ds
          from BAS_SPACE_use u
         where u.user_type = 'dept'
           and u.USER_ID = #deptId#
           AND u.is_use = 'Y'
        union all
        select u.SPACE_ID, 1 ds
          from BAS_SPACE_use u
         where u.user_type = 'user'
           and u.USER_ID = #userId#
           AND u.is_use = 'Y'
        union all
        select u.SPACE_ID, 2 ds
          from BAS_SPACE_use u,
               (select case
                         when r.ROLE_TYPE = 'org' then
                          concat(a.ORG_ID, '>', a.ROLE_ID)
                         when r.ROLE_TYPE = 'dept' then
                          concat(a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID)
                         else
                          r.ROLE_ID
                       end ROLE_ID
                  from bas_roles_account a, bas_roles r
                 where a.ACCOUNT_ID = #userId#
                   and a.ROLE_ID = r.ROLE_ID) r
         where u.user_type = 'role'
           and r.role_id LIKE u.USER_ID
           AND u.is_use = 'Y') u
 WHERE s.space_Type = '0'
   AND s.is_use = 'Y'
   AND s.space_id = u.space_id
 ORDER BY (case when s.EMP_LV is null or s.EMP_LV='' then 999 else s.EMP_LV end) ,
 u.ds, s.space_type, ifnull(s.display_no, 999)

   
getMyApply   
===
SELECT
@pageTag(){
	t.*,
	(
	SELECT GROUP_CONCAT(a.ACCOUNT_NAME)
	FROM
		bas_message m,
		bas_message_receive r,
		bas_emp_account a 
	WHERE
		m.PROCESSINSTID = t.PROCESSINSTID 
		AND m.MSG_TYPE = '1' 
		AND m.MSG_ID = r.MSG_ID 
		and m.IS_USE='Y'
		AND ifnull( r.IS_DEAL, 'N' ) = 'N' 
		and a.ACCOUNT_ID = r.ACCOUNT_ID
	) ACCOUNT_NAME
	@}
FROM
	(
	SELECT
		f.form_name,
		f.is_app,
		t.msg_url,
		t.msg_title title,
		t.msg_title,
		t.busi_main_id,
		t.form_code,
		t.processinstid,
		wp.currentstate,
		DATE_FORMAT( wp.createtime, '%m-%d' ) createtime,
		rank ( ) over ( PARTITION BY t.processinstid ORDER BY t.msg_id desc) rn 
	FROM
		BAS_MESSAGE t
		LEFT JOIN gen_form f ON f.form_code = t.form_code 
		AND f.is_use = 'Y'
		LEFT JOIN wf_processinst wp ON wp.processinstid = t.processinstid 
		AND wp.currentstate <> 7 
	WHERE
		wp.creator = #userId#  
		AND t.msg_type = '1' 
@if(!isEmpty(search)){
	and (t.title like #search# ESCAPE '/'  or
	(select DATE_FORMAT(p.createtime,'%Y-%m-%d %H:%i:%s') from wf_processinst p where p.processinstid=t.processinstid)  like #search# ESCAPE '/' )
@}    
@if(!isEmpty(isApp)){
	and f.is_app = #isApp#
@}     
 order by t.processinstid desc) t where t.rn=1



myReimburseData
===
select rank()over() rownum, t.*
  from (select distinct f.form_name,
                        t.msg_url,
                        (case when r.expense_type_id = 2 then ifnull(t.msg_title,concat(t.msg_title,' (报销金额:',FORMAT(r.payment_money, 2),'元)')) else 
                          ifnull(t.msg_title,t.msg_title) end ) title ,
                        t.busi_main_id,
                        t.form_code,
                        t.processinstid,
                        wp.currentstate,
                        DATE_FORMAT(wp.createtime,'%Y-%m-%d') createtime
          from BAS_MESSAGE t
          left join fm_expense_reimburse r on r.reimburse_id = t.busi_main_id
          left join gen_form f
            on f.form_code = t.form_code
           and f.is_use = 'Y'
          left join wf_processinst wp
            on wp.processinstid = t.processinstid
           and wp.currentstate <> 7
         where 1=1 and t.form_code like '%Reimburse%'
@if(!isEmpty(search)){
	and (t.title like #search# ESCAPE '/'  or
	(select DATE_FORMAT(p.createtime,'%Y-%m-%d %H:%i:%s') from wf_processinst p where p.processinstid=t.processinstid)  like #search# ESCAPE '/' )
@}  
 order by t.processinstid desc) t
 where 1=1  LIMIT 0,20
 

getMyWork
===
with tmp as
 (SELECT distinct r.task_id,r.user_id,r.is_use,r.user_type
    FROM (select TT.TASK_ID, tt.USER_ID, tt.IS_USE, tt.user_type
            from GM_TASK_ASSIST tt
           where tt.is_use = 'Y'
          union all
          select tu.task_id,tu.USER_ID, tu.IS_USE, tu.user_type
            from Gm_Task_Undertaker tu
          ) r
   WHERE r.is_use = 'Y'
@if(!isEmpty(accountid)){
     and ((r.user_type = 'org' and r.user_id in (select o.id from view_bas_org_bizdept o start with o.id = #org# CONNECT BY  o.id =PRIOR o.pid)) or
         (r.user_type = 'dept' and r.user_id in (select o.id from view_bas_org_bizdept o start with o.id = #dept# CONNECT BY  o.id =PRIOR o.pid)) or
         (r.user_type = 'user' and r.user_id = #accountid#))
@}
)
select z.*,
      
getdicname('GM_TASK_STATUS',z.STATUS) STATUS_name ,
(select group_concat(a.account_name) from BAS_EMP_ACCOUNT a where concat(',',z.LEADERS,',') like concat('%,',a.account_id,',%')) LEADERS_name,
DATE_FORMAT(z.START_DATE, 'mm/dd') as START_DATE,
DATE_FORMAT(z.END_DATE, 'mm/dd') as END_DATE
  from (select t.meeting_task_id as id,
                                t.meeting_name as task_name,
                                t.status as status,
                                t.leaders,
                                t.start_date,
                                t.end_date,
                                'GmMeetingTask' as form_code,
                                t.is_use
                           from GM_MEETING_TASK t,tmp  
                          where  t.meeting_task_id = tmp.task_id
                         union all
                         select t.register_task_id as id,
                                t.meeting_name as task_name,
                                t.status as status,
                                t.leaders,
                                t.start_date,
                                t.end_date,
                                'GmTaskRegister' as form_code,
                                t.is_use
                           from GM_TASK_REGISTER t,tmp  where t.register_task_id = tmp.task_id
                         union all
                         select t.task_year_id as id,
                                t.project_name as task_name,
                                null as status,
                                DATE_FORMAT(t.head_account) as leaders,
                                null as start_date,
                                null as end_date,
                                'GmTaskYear' as form_code,
                                t.is_use
                           from GM_TASK_YEAR t where t.head_account = #accountid#
                         union all
                         select t.task_resolve_year_id as id,
                                t.task_name as task_name,
                                t.status,
                                t.leaders,
                                t.start_date,
                                t.end_date,
                                'GmTaskResolveYear' as form_code,
                                t.is_use
                           from GM_TASK_RESOLVE_YEAR t,tmp  where t.task_resolve_year_id = tmp.task_id
                         union all
                         select t.leader_assign_id as id,
                                t.task_name,
                                t.status,
                                t.leaders,
                                t.start_date,
                                t.end_date,
                                'GmTaskLeaderAssign' as form_code,
                                t.is_use
                           from GM_TASK_LEADER_ASSIGN t,tmp
                           where t.leader_assign_id = tmp.task_id) z
 where z.is_use = 'Y'


getMyApplyNew   
===
with wfProcessinst as (SELECT max(wp.ENDTIME) ENDTIME ,wp.PARENTPROCINSTID
FROM wf_processinst wp WHERE   
wp.CURRENTSTATE = 12 and   wp.creator =  #userId#   group by wp.PARENTPROCINSTID),
maxmsg as
( SELECT
	m.processinstid ,
	wp.createtime,
	wp.currentstate,
	max(m.msg_id) msg_id
	FROM
		bas_message m
		LEFT JOIN wf_processinst wp ON m.processinstid = wp.processinstid 
	WHERE
		 wp.creator = #userId# and wp.currentstate <> 7
	GROUP BY
		m.processinstid 
	)  
select @pageTag(){ 
 	f.form_name,
    f.print_addr,
    f.is_app,
    t.msg_url,
    t.msg_title title,
    t.msg_title,
    t.busi_main_id,
    t.form_code,
    t.processinstid,
    y.res_id,
    (select account_name from bas_emp_account b where b.account_id = 1003530) send_name,
    DATE_FORMAT(mm.createtime,'%Y-%m-%d %H:%i:%s') createtime,
    (select group_concat(w.workitemname)
       from WF_WORKITEM w
      where w.processinstid = t.PROCESSINSTID
        and w.currentstate in ('4', '10')) workitemname,
    (SELECT group_concat(b.account_name) 
		FROM
			WF_WORKITEM tt,
			bas_message s,
			bas_message_receive r,
			bas_emp_account b 
		WHERE
			s.msg_id = r.msg_id 
			AND ifnull( R.IS_DEAL, '' ) <> 'Y' 
			AND tt.currentstate IN ( 4, 10 ) 
			AND tt.workitemid = s.workitemid 
			AND s.processinstid = t.processinstid 
			AND r.account_id = b.account_id
		) receive_By,
    case when mm.currentstate='12' then 1 else 0 end status,
    wp.endTime,
    T.MSG_TYPE
@}
from BAS_MESSAGE t 
    LEFT JOIN WF_PROCESSDEFINE_PROCESSINST w ON t.processinstid = w.processinstid 
    LEFT JOIN wfProcessinst wp on wp.PARENTPROCINSTID = t.processinstid 
    LEFT JOIN STF_BUSINESS_PROCESS e ON e.design_name = w.processdefname
    LEFT JOIN stf_business_type y ON y.res_id = e.business_type_id
    left join gen_form f on f.form_code = t.form_code and f.is_use = 'Y'
    join maxmsg mm on t.processinstid = mm.processinstid and t.msg_id = mm.msg_id
where DATE_FORMAT(t.SENDTIME,'%Y-%m-%d') BETWEEN #startDate# AND #endDate#
@if(!isEmpty(status)){
    AND (case when mm.currentstate='12' then 1 else 0 end) = #status#
@}
@if(!isEmpty(subject)){
        and locate(#subject# , t.msg_title ) > 0
@}
@if(!isEmpty(flowType)){
        AND y.res_id IN 
                                    (
                                    with recursive temp as
                                                                        (
                                                                        select a.* from stf_business_type a where  a.RES_ID = #flowType#
                                                                        union all
                                                                        select a.* from stf_business_type a,temp t where a.PARENT_ID=t.RES_ID  
                                                                        )
                                    SELECT
                                            t.RES_ID id
                                    FROM
                                            temp t
        )
@}
@if(!isEmpty(search)){
	and (t.msg_title like #search# ESCAPE '/'  or
	DATE_FORMAT(mm.createtime,'%Y-%m-%d %H:%i:%s') like #search# ESCAPE '/' )
@}
 order by (case when mm.currentstate='12' then 1 else 0 end), t.processinstid desc


getEdocApply
===
select 
   z.*

from (select 
        t.ID,(select tt.office_name from EDOC_NO_DEFINE tt where DATE_FORMAT(tt.id)=t.org_replace) org_replace,t.SERIAL_NO,t.doc_mark,
    getdicName('EDOC_SECRET_LEVEL',t.SECRET_LEVEL) SECRET_LEVEL_name,
    (select distinct getdicname('MSG_LEVEL',m.msg_level)  from BAS_MESSAGE m where m.processinstid=t.processinstid  and m.is_use='Y') msg_level,
    t.PROCESSINSTID,t.subject,
 DATE_FORMAT(t.create_time,'MM-dd') send_time,
t.create_time,
    getaccountname(t.CREATE_ACCOUNT) send_by,
    (select GETDEPTNAME(q.dept_id) from Bas_Emp_Account q where q.account_id = t.CREATE_ACCOUNT) send_dept,
    (select distinct DATE_FORMAT(min(r.read_time),'%Y-%m-%d %H:%i:%s') from BAS_MESSAGE t1,bas_message_receive r where t1.processinstid=t.processinstid and t1.is_use='Y' and t1.msg_id=r.msg_id and r.account_id=#userId# ) receive_Time,
    (select group_concat(getaccountname(s.participant)) from (select p.participant,tt.processinstid
  from WF_WORKITEM tt, WF_PARTICIPANT p
 where tt.currentstate in (4, 10) and p.partictype='role'
   and tt.workitemid = p.workitemid
union all
select p.participant,tt.processinstid
  from WF_WORKITEM tt, WF_PARTICIPANT p
 where  tt.currentstate in (4, 10) and p.partictype='person'
   and tt.workitemid = p.workitemid) s where s.processinstid=t.processinstid
) receive_By,
    (select group_concat(w.workitemname) from WF_WORKITEM w where w.processinstid=t.PROCESSINSTID and w.currentstate in ('4','10')) workitemname,
    (select DATE_FORMAT(max(t1.create_time),'%Y-%m-%d')
  from EDOC_EXCHANGE t1
 where t1.edoc_id = t.id) appro_time,
    t.IS_USE,
    t.WORKFLOW_STATUS,
    ifnull(getdicname('WORKFLOW_STATUS',t.WORKFLOW_STATUS),'待处理') WORKFLOW_STATUS_name
from EDOC_APPLY t
where t.is_use = 'Y'
@if(!isEmpty(type)){
and t.EDOC_TYPE = #type#
@}
and t.CREATE_ACCOUNT=#userId#   and t.processinstid in (select w.processinstid  from WF_WORKITEM w where w.processdefname = t.flow_code and w.currentstate='12' and w.participant=#userId# )
) z order by z.create_time desc 


getMyKnowledgeDocument
===
select 
		t.DOCUMENT_ID as id,
		t.CATEGORY_ID,
		t.ATTRIBUTE,
		t.DOCUMENT_FORMAT,
		t.DOCUMENT_NAME,
		t.KEYWORD,
		t.DOCUMENT_DESCRIPTION,
		t.DOCUMENT_BODY,
		t.ORG_ID,
		getbaseabbr(t.ORG_ID) org_name,
		t.DEPT_ID,
		getdeptname(t.DEPT_ID) dept_name,
		t.CREATE_ACCOUNT,
		getaccountname(t.CREATE_ACCOUNT) CREATE_ACCOUNT_name,
		DATE_FORMAT(t.create_time,'MM-dd') as time,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
		r.version_id
from GM_KNOWLEDGE_DOCUMENT t
left join   EDOC_FILE_RELATE r on r.file_id=DATE_FORMAT(t.DOCUMENT_BODY)
where t.is_use = 'Y' 
and t.CATEGORY_ID in (select c.category_id 
  from GM_KNOWLEDGE_DOCUMENT_CATEGORY c
 where c.is_use = 'Y'   
   and ( concat(',' , replace(c.SHARED_SCOPE,'loginuser.accountId',#loginuser.accountid#) , ',') LIKE concat('%,' , #userId# , ',%')
 or  concat(',' , c.SHARED_SCOPE , ',') LIKE concat('%,user:' , #userId# , ',%')
 or  concat(',' , c.SHARED_SCOPE , ',') LIKE concat('%,dept:' , #deptId# , ',%')
 or  concat(',' , c.SHARED_SCOPE , ',') LIKE concat('%,org:' , #orgId# ,',%')
  or  concat(',' , c.SHARED_SCOPE , ',') LIKE concat('%,' , 'all' , ',%')
  or t.create_account = #userId#
 ))
@if(!isEmpty(search)){
and(
 upper(t.DOCUMENT_FORMAT) like #search# ESCAPE '/'   or 
 upper(t.DOCUMENT_NAME) like #search# ESCAPE '/'   or 
 upper(t.KEYWORD) like #search# ESCAPE '/'   or 
 upper(t.DOCUMENT_DESCRIPTION) like  #search#
)@}




findFirstMenuSpace
===
select t.*
from BAS_SPACE_DEFINE t
where t.is_use = 'Y'
and t.menu_Id = #menuId#
and t.emp_Lv = #station#
and instr(concat(',' , t.org_id , ','), concat(',' , #orgId# , ','))!=0
and (t.dept_id is null or (t.dept_id is not null and instr(concat(',' , t.dept_id , ','), concat(',' , #deptId# , ','))!=0 )) 


checkBasSpaceDefine
===
select t.*
from BAS_SPACE_DEFINE t
where t.is_use = 'Y'
@if(!isEmpty(spaceId)){
    and t.SPACE_ID != #spaceId#
@}
@if(!isEmpty(spaceType)){
    and t.space_Type = #spaceType#
@}
@if(!isEmpty(empLv)){
    and t.emp_Lv = #empLv#
@}
@if(!isEmpty(menuId)){
    and t.menu_Id = #menuId#
@}
@if(!isEmpty(org)){
    and instr(concat(',' , t.org_id , ','), concat(',' , #org# , ',')) != 0
@}
@if(!isEmpty(dept)){
    and instr(concat(',' , t.dept_id , ','), concat(',' , #dept# , ',')) != 0
@}


getIncomeList
===
select sum(t.money) value, t.type_name name
  from v_income_cost t
 where t.type = #type#
 and t.org_id=#loginuser.orgid#
 group by t.type_name

getIncomeListByYear
===
select round(sum(decode(t.type, 'income', t.money, 0))/10000,2) income_value,
       round(sum(decode(t.type, 'cost', t.money, 0))/10000,2)cost_value,
       DATE_FORMAT(t.apply_data, 'mm') mm
  from v_income_cost t
 where DATE_FORMAT(t.apply_data, 'yyyy') = DATE_FORMAT(NOW(), 'yyyy')
  and t.org_id=#loginuser.orgid#
 group by DATE_FORMAT(t.apply_data, 'mm')

getGmAssetsInventory
===
select count(1) value, C.CATEGORY_NAME name
  from GM_ASSETS_INVENTORY t
  LEFT JOIN GM_ASSETS_CATEGORY C
    ON T.ASSETS_TYPE = C.CATEGORY_ID
 where t.is_use = 'Y'
    and t.org_id=#loginuser.orgid#
   and c.category_id in
       (select s.category_id
          from GM_ASSETS_CATEGORY s
         where s.is_use = 'Y'
         start with s.category_id = 34
        CONNECT BY PRIOR s.category_id = s.category_pid)
 group by C.CATEGORY_NAME

getGmAssetsInventoryWG
===
select sum(v.in_num) in_num,
       sum(v.out_num) out_num,
       sum(v.kc_num) kc_num,
       sum(v.in_num1) in_num1,
       sum(v.out_num1) out_num1,
       sum(v.kc_num1) kc_num1,
       sum(v.in_num2) in_num2,
       sum(v.out_num2) out_num2,
       sum(v.kc_num2) kc_num2,
       sum(v.in_num3) in_num3,
       sum(v.out_num3) out_num3,
       sum(v.kc_num3) kc_num3,
       sum(v.in_num4) in_num4,
       sum(v.out_num4) out_num4,
       sum(v.kc_num4) kc_num4,
       sum(v.in_num5) in_num5,
       sum(v.out_num5) out_num5,
       sum(v.kc_num5) kc_num5
  from v_assets_in_out_amount v
 where v.org_id=#loginuser.orgid#

getConIncomeInfo
===
select round(sum(ifnull(t.phase_money_this, 0))/10000,2) phase_money_this,
       round(sum(ifnull(d.price_tax_money, 0))/10000,2) price_tax_money
  from V_PHASE_DATA t
  left join V_COMMON_CON a
    on a.con_id = t.con_id
  left join (select d.pk_id, d.biz_code, d.price_tax_money
               from fm_receive_detail d
               left join FM_RECEIVE_TOTAL r
                 on r.receive_total_id = d.receive_total_id
              where r.is_use = 'Y'
                and d.is_use = 'Y'
                and r.workflow_status = '3') d
    on d.pk_id = t.pk_id
   and d.biz_code = t.biz_code
 where t.is_use = 'Y'
   and a.workflow_status = 3
   and DATE_FORMAT(t.PHASE_TIME, 'yyyy') = DATE_FORMAT(NOW(), 'yyyy')
   and t.PHASE_TIME < NOW()
   and a.org_id=#loginuser.orgid#
   and a.con_type_id in
       (select p.pmcon_type_id
          from PM_PMCON_TYPE p
         where p.is_use = 'Y'
         start with p.pmcon_type_id in (400)
        connect by prior p.pmcon_type_id = p.pmcon_type_pid)

getHouseInfo
===
with temp as
 (select c.assets_id,
         (case
           when e.workflow_status IN (3) AND
                e.contract_id NOT IN
                (SELECT t1.old_contract_id
                   FROM ma_lease_contract t1
                  WHERE t1.is_use = 'Y'
                       --续租的租赁合同
                    AND t1.con_type = 1
                 UNION
                 SELECT r.contract_id
                   FROM ma_lease_rebate r
                  WHERE r.is_use = 'Y') then
            (ifnull(c.lease_area, 0))
           else
            0
         end) already_rent,
         (case
           when c.facade_type = '2' then
            ifnull(c.lease_area, 0)
           else
            0
         end) annex_area
    from MA_HOUSE_FACADE c
    left join MA_LEASE_PLAN_DETAIL d
      on c.FACADE_ID = d.FACADE_ID
     and d.is_use = 'Y'
    left join ma_lease_contract e
      on d.CONTRACT_ID = e.contract_id
     and e.is_use = 'Y'
   where c.is_use = 'Y'
     and e.workflow_status IN (3)),
a as
 (select ifnull(a.BUILT_AREA, 0) BUILT_AREA,
         ifnull(m.already_rent, 0) already_rent, --已租面积
         ifnull(m.annex_area, 0) annex_area, --附属建筑面积
         (case
           when t.assets_useage = '7' then
            ifnull(a.BUILT_AREA, 0)
           else
            0
         end) vacant_AREA, --空置面积
         (case
           when ifnull(m.already_rent, 0) = 0 then
            ifnull(a.BUILT_AREA, 0)
           else
            0
         end) free_AREA --空闲面积
    from GM_ASSETS_INVENTORY t
    left join GM_REAL_PROPERTY a
      on t.ASSETS_ID = a.ASSETS_ID
    left join GM_LOCATION_INFO b
      on t.ASSETS_ID = b.ASSETS_ID
    left join (select temp.assets_id,
                     sum(ifnull(temp.already_rent, 0)) already_rent,
                     sum(ifnull(temp.annex_area, 0)) annex_area
                from temp
               group by temp.assets_id) m
      on t.assets_id = m.assets_id
   where t.is_use = 'Y'
     AND t.assets_catagory = 'GmAssetsInventoryFC'
     AND t.assets_status IN ('3', '4')
   order by t.ASSETS_ID)
select sum(a.already_rent) already_rent,
       sum(a.free_AREA) free_AREA,
       sum(a.vacant_AREA) vacant_AREA,
       sum(a.annex_area) annex_area,
       round(sum(a.already_rent) / sum(a.BUILT_AREA) * 100, 2) rent_rate,
       round(sum(a.vacant_AREA) / sum(a.BUILT_AREA) * 100, 2) vacant_rate
  from a

getHouseTypeCount
===
select count(t.assets_id) value,
       d.dic_text name
  from BAS_DIC d
  left join GM_REAL_PROPERTY a
    on d.dic_value = a.houses_nature
   and a.is_use = 'Y'
   and a.houses_nature is not null
  left join GM_ASSETS_INVENTORY t
    on t.ASSETS_ID = a.ASSETS_ID
   AND t.assets_catagory in ('GmAssetsInventoryFC')
   AND t.assets_status IN ('3', '4')
   and t.is_use = 'Y'
 where d.dic_code = 'HOUSES_NATURE'
 group by d.dic_text
union all
select count(t.assets_id) value, '广告位' name
  from GM_ASSETS_INVENTORY t
 where t.is_use = 'Y'
   AND t.assets_catagory in ('GmAssetsInventoryGG')
   AND t.assets_status IN ('3', '4')

getMoneyByYear
===
select round(sum(ifnull(p.phase_money_this, 0))/10000,2) phase_money_this,
       round(sum(ifnull(ff.price_tax_money, 0))/10000,2) price_tax_money,
       round((sum(ifnull(p.phase_money_this, 0) - ifnull(ff.price_tax_money, 0)))/10000,2) ws_money,
       DATE_FORMAT(p.phase_time, 'MM"月')month
  from ma_lease_contract e
  left join PM_PMCON_PHASE p
    on e.contract_id = p.pmcon_id
   and p.is_use = 'Y'
  left join (select f.pk_id, sum(ifnull(f.price_tax_money, 0)) price_tax_money
               from fm_receive_detail f
               left join fm_receive_total o
                 on f.receive_total_id = o.receive_total_id
                and o.is_use = 'Y'
                and o.workflow_status = '3'
                and f.is_use = 'Y'
              group by f.pk_id) ff
    on p.pmcon_phase_id = ff.pk_id
 where e.workflow_status IN (3)
   and DATE_FORMAT(p.phase_time, 'yyyy') = DATE_FORMAT(NOW(), 'yyyy')
   and DATE_FORMAT(p.phase_time, '%Y-%m') < = DATE_FORMAT(NOW(), '%Y-%m')
@if(!isEmpty(month)){
    and DATE_FORMAT(p.phase_time, '%Y-%m')=#month#
@}
 group by DATE_FORMAT(p.phase_time, 'MM"月')
 order by DATE_FORMAT(p.phase_time, 'MM"月')

getConInfo
===
select round(sum(case
             when e.con_end > NOW() AND
                  e.contract_id NOT IN
                  (SELECT t1.old_contract_id
                     FROM ma_lease_contract t1
                    WHERE t1.is_use = 'Y'
                         --续租的租赁合同
                      AND t1.con_type = 1
                   UNION
                   SELECT r.contract_id
                     FROM ma_lease_rebate r
                    WHERE r.is_use = 'Y') then
              ifnull(e.con_money, 0)
             else
              0
           end)/10000,2) carry_on_money,
       round(sum(case
             when DATE_FORMAT(e.sign_time, '%Y-%m') = DATE_FORMAT(NOW(), '%Y-%m') then
              ifnull(e.con_money, 0)
             else
              0
           end)/10000,2) this_money,
       round(sum(case
             when DATE_FORMAT(e.con_end, '%Y-%m') = DATE_FORMAT(NOW(), '%Y-%m') then
              ifnull(e.con_money, 0)
             else
              0
           end)/10000,2) this_end_money,
       sum(case
             when e.con_end > NOW() AND
                  e.contract_id NOT IN
                  (SELECT t1.old_contract_id
                     FROM ma_lease_contract t1
                    WHERE t1.is_use = 'Y'
                         --续租的租赁合同
                      AND t1.con_type = 1
                   UNION
                   SELECT r.contract_id
                     FROM ma_lease_rebate r
                    WHERE r.is_use = 'Y') then
              1
             else
              0
           end) carry_on_count,
       sum(case
             when DATE_FORMAT(e.sign_time, '%Y-%m') = DATE_FORMAT(NOW(), '%Y-%m') then
              1
             else
              0
           end) this_count,
       sum(case
             when DATE_FORMAT(e.con_end, '%Y-%m') = DATE_FORMAT(NOW(), '%Y-%m') then
              1
             else
              0
           end) this_end_count,
       sum(case
             when e.contract_id IN
                  (SELECT t1.old_contract_id
                     FROM ma_lease_contract t1
                    WHERE t1.is_use = 'Y'
                         --续租的租赁合同
                      AND t1.con_type = 1
                      and DATE_FORMAT(t1.sign_time, '%Y-%m') =
                          DATE_FORMAT(NOW(), '%Y-%m')) then
              1
             else
              0
           end) renewal_count
  from ma_lease_contract e
 where e.is_use = 'Y'
   and e.workflow_status IN (3)

getFinanceMoneyByYear
===
select round((ifnull(t.REV_MONEY, 0) - ifnull(t.tax_money, 0))/10000,2) sr_money,
       round((ifnull(t.REV_MONEY, 0) - ifnull(t.tax_money, 0) + ifnull(p.add_money, 0))/10000,2) total_money,
       round(ifnull(r.REV_money, 0)/10000,2) REV_money,
       substr(p.MONTH, 5, 2) MONTH
  from (select sum(ifnull(pp.plan_money, 0) - ifnull(pp.tax_money, 0)) add_money,
               replace(pp.month, '-', '') month
          from fm_fund_plan pp
         where pp.is_use = 'Y'
           and pp.bill_id is null
         group by pp.month) p
  left join (select sum(ifnull(rr.rev_money, 0) - ifnull(rr.tax_money, 0)) REV_money,
                    replace(rr.month, '-', '') month
               from FM_FUND_REV rr
              where rr.is_use = 'Y'
              group by rr.month) r
    on p.month = r.month
  left join FM_FUND_SETTLEMENT t
    on t.month = p.month
   and t.is_use = 'Y'
 where substr(p.MONTH, 1, 4) = DATE_FORMAT(NOW(), 'yyyy')
   and p.MONTH < = DATE_FORMAT(NOW(), 'yyyymm')
 @if(!isEmpty(month)){
    and p.MONTH=#month#
@}
 order by substr(p.MONTH, 5, 2)
 
getFundMoney
===
--所有公司当月剩余的资金余额
SELECT 
SUM(W.rest) rest,
SUM(W.fund) fund,
SUM(W.bank) bank
FROM (
select ifnull(SELECT ifnull(SUM(i.init_money), 0)
             FROM Fm_Balance_Init i
            WHERE i.IS_USE = 'Y'
              AND i.org_id = o.org_id),
           0)/10000 + ifnull(select sum(ifnull(a1.debit_amount, 0)) -
                           sum(ifnull(a1.lender_amount, 0))
                      from FM_BANK_JOURNAL a1
                     where a1.is_use = 'Y'
                       and a1.rev_unit = o.org_id
                       and a1.agree_status = 2
                       and a1.create_time <= TRUNC(NOW(), 'MONTH')),
                    0)/10000 rest,
       (ifnull(SELECT ifnull(SUM(i.init_money), 0)
              FROM Fm_Balance_Init i
             WHERE i.IS_USE = 'Y'
               and i.balance_type = 1 --库存现金初始化
               AND i.org_id = o.org_id),
            0) + ifnull(select sum(ifnull(a1.debit_amount, 0)) -
                             sum(ifnull(a1.lender_amount, 0))
                        from FM_BANK_JOURNAL a1
                       where a1.is_use = 'Y'
                         and a1.rev_unit = o.org_id
                         and a1.journal_type = 2 --现金日记
                         and a1.agree_status = 2
                         and a1.create_time <= TRUNC(NOW(), 'MONTH')), --  库存现金    
                      0))/10000 fund,
       ifnull(SELECT ifnull(SUM(i.init_money), 0)
             FROM Fm_Balance_Init i
            WHERE i.IS_USE = 'Y'
              and i.balance_type = 2 --账户初始化
              AND i.org_id = o.org_id),
           0)/10000 + ifnull(select sum(ifnull(a1.debit_amount, 0)) -
                           sum(ifnull(a1.lender_amount, 0))
                      from FM_BANK_JOURNAL a1
                     where a1.is_use = 'Y'
                       and a1.rev_unit = o.org_id
                       and a1.journal_type = 1 --银行日记
                       and a1.agree_status = 2
                       and a1.create_time <= TRUNC(NOW(), 'MONTH')), --银行存款
                    0)/10000 bank
  from bas_org  o where o.is_use = 'Y' ) W WHERE 1=1

getMainBusiIndex
===
select 
bs.system_id,
bs.system_name,
(select ifnull(sum(z.money),0) from (
select t.budget_id,
t.price_tax_money money,
r.workflow_status,
r.org_id
from fm_receive_detail t 
left join fm_receive_total r on r.receive_total_id = t.receive_total_id
where t.is_use = 'Y' and r.is_use = 'Y' and t.budget_id is not null

union all 

select t.budget_id,
t.ensure_money money,
r.workflow_status,
r.org_id
from fm_receive_ensure_detail t 
left join fm_receive_ensure r on r.receive_ensure_id = t.receive_ensure_id
where t.is_use = 'Y' and r.is_use = 'Y' and t.budget_id is not null

union all 

select 
T.BUDGET_ID,
T.TOTAL_COL_MONEY money,
t.workflow_status,
t.apply_org org_id
from gm_retail_collection t
where t.is_use = 'Y'and t.budget_id is not null

UNION ALL 

select 
T.Budget_Id,
T.COLLECTION_ENSURE_MONEY money,
t.workflow_status,
t.org_id
from gm_collection_ensure t
where t.is_use = 'Y' and t.budget_id is not null

union all 

select 
t.budget_id,
T.SHARE_MONEY money,
r.workflow_status,
r.org_id
from fm_reimburse_share t 
left join fm_expense_reimburse r on r.reimburse_id = t.reimburse_id 
where t.is_use = 'Y' and r.is_use = 'Y' and t.budget_id is not null

) z where z.workflow_status = 3 and  z.budget_id in (select s.system_id from fm_budget_system s  where s.is_use = 'Y' start with s.system_id =bs.system_id connect by prior s.system_id=s.pid))/10000 money
from fm_budget_system  bs 
where bs.is_use = 'Y' and bs.system_id in (9,10,12,13)


getConCockpit
===
SELECT round(SUM(ifnull(t.con_money, 0))/10000,2) zx_con_money, --执行合同总额
       round(COUNT(*)/10000,2) zx_num, --执行合同数量
       round(sum(case
             when t.formcode IN ('FmContract',
                                 'MaLeaseContract',
                                 'MaLeaseContract_FJYX',
                                 'PmBidSerconXS') then
              ifnull(t.con_money, 0) - ifnull(o.price_tax_money, 0)
             else
              0
           end)/10000,2) con_receive_left_money, --未收款总额
       round(sum(case
             when t.formcode in
                  ('PmPmcon', 'PmBidSercon', 'ImInvconGQ', 'ImInvconJJ') then
              ifnull(t.con_money, 0) - ifnull(pm.paid_money, 0)
             else
              0
           end)/10000,2) con_pay_left_money --未付总额
  FROM V_COMMON_CON t
  left join (select SUM(ifnull(oo.price_tax_money, 0)) price_tax_money,
                    oo.con_id
               from Fm_Receive_Total oo
              where oo.is_use = 'Y'
              group by oo.con_id) o
    on t.con_id = o.con_id
  left join (select m.con_id, SUM(ifnull(m.paid_money, 0)) paid_money
               from v_fm_con_pay_money m
              group by m.con_id) pm
    on t.con_id = pm.con_id
 WHERE t.workflow_status = 3

getMyApplyNew1  
===
select 
 @pageTag(){ 
 	t.* 
 @}
  from (select  f.form_name,
                        f.print_addr,
                        f.is_app,
                        t.msg_url,
                        t.msg_title title,
                        t.busi_main_id,
                        t.form_code,
                        t.processinstid,
                        getaccountname(p.creator) send_name,
                        date_format(p.createtime, '%Y-%m-%d %T') createtime,
                        (select group_concat(w.workitemname)
                           from WF_WORKITEM w
                          where w.processinstid = t.PROCESSINSTID
                            and w.currentstate in ('4', '10')) workitemname,
                        (select group_concat(getaccountname(r.account_id))
                           from WF_WORKITEM         tt,
                                bas_message         s,
                                bas_message_receive r
                          where s.msg_id = r.msg_id
                            AND nvl(R.IS_DEAL, '') <> 'Y'
                            and tt.currentstate in (4, 10)
                            and tt.workitemid = s.workitemid
                            and s.processinstid = t.processinstid) receive_By,
                        rank()over(partition by t.processinstid order by t.msg_id desc) rn
          from BAS_MESSAGE t
          left join gen_form f
            on f.form_code = t.form_code
           and f.is_use = 'Y', wf_processinst p
         where 
         	@if(isEmpty(accountType)){
         		p.CREATOR = #loginuser.accountid#
         	@}else{
         		@if(accountType=='self'){
         			p.CREATOR = #loginuser.accountid#
	         	@}else if(accountType=='dept'){
	         		p.CREATOR in(select account_id from bas_emp_account where dept_id = #loginuser.deptid#) 
	         	@}else if(accountType=='org'){
	         		p.CREATOR in(select account_id from bas_emp_account where org_id = #loginuser.orgid#) 
	         	@}
         	@}
         and p.PROCESSINSTNAME=#flowCode#
        and p.currentstate=12
           and p.processinstid = t.processinstid
) t  where t.rn=1
@if(!isEmpty(search)){
	and (t.title like #search# ESCAPE '/'  or
	t.createtime like #search# ESCAPE '/' )
@}
 order by  t.processinstid desc
 

 
getMyApplyListByFormCode  
===
select 
  @pageTag(){ 
  	t.* 
  @}
   from (select  f.form_name,
                         f.print_addr,
                         f.is_app,
                         t.msg_url,
                         t.msg_title title,
                         t.busi_main_id,
                         t.form_code,
                         t.processinstid,
                         getaccountname(p.creator) send_name,
                         date_format(p.createtime, '%Y-%m-%d %T') createtime,
                         (select group_concat(w.workitemname)
                            from WF_WORKITEM w
                           where w.processinstid = t.PROCESSINSTID
                             and w.currentstate in ('4', '10')) workitemname,
                         (select group_concat(getaccountname(r.account_id))
                            from WF_WORKITEM         tt,
                                 bas_message         s,
                                 bas_message_receive r
                           where s.msg_id = r.msg_id
                             AND nvl(R.IS_DEAL, '') <> 'Y'
                             and tt.currentstate in (4, 10)
                             and tt.workitemid = s.workitemid
                             and s.processinstid = t.processinstid) receive_By,
                         rank()over(partition by t.processinstid order by t.msg_id ) rn
           from BAS_MESSAGE t
           left join gen_form f
             on f.form_code = t.form_code
            and f.is_use = 'Y', wf_processinst p
          where 
          	@if(isEmpty(accountType)){
          		p.CREATOR = #loginuser.accountid#
          	@}else{
          		@if(accountType=='self'){
          			p.CREATOR = #loginuser.accountid#
 	         	@}else if(accountType=='dept'){
 	         		p.CREATOR in(select account_id from bas_emp_account where dept_id = #loginuser.deptid#) 
 	         	@}else if(accountType=='org'){
 	         		p.CREATOR in(select account_id from bas_emp_account where org_id = #loginuser.orgid#) 
 	         	@}
          	@}
         AND t.form_code=#formCode#
         and p.currentstate=12
            and p.processinstid = t.processinstid
 ) t  where t.rn=1
 @if(!isEmpty(search)){
 	and (t.title like #search# ESCAPE '/'  or
 	t.createtime like #search# ESCAPE '/' )
 @}
  order by  t.processinstid desc
  
  
pageMyFeedbackData
===
select @pageTag(){
      t.feedback_id,
      t.task_id,
      t.feedback_no,
      t.completion_status,
        GETDICNAME('taskCompletationStatus',t.completion_status) COMPLETION_STATUS_TEXT,
        (
        CASE
        WHEN g.is_close = 'Y' THEN
        '已关闭'
        WHEN t.WORKFLOW_STATUS ='1' THEN
        '待反馈'
        WHEN t.WORKFLOW_STATUS ='3' THEN
        '已完成'
        ELSE '办理中'
        END
        ) WORKFLOW_STATUS_TEXT,
      t.completion,
      t.problems,
      t.measures,
      g.task_content,
      t.org_id,
        GETORGNAME(t.org_id) ORG_ID_TEXT,
      t.dept_id,
        GETDEPTNAME(t.dept_id) DEPT_ID_TEXT,
      g.record_date,
      t.feedback_man,
        GETACCOUNTNAME(t.feedback_man) FEEDBACK_MAN_TEXT,
      t.create_account,
      t.create_time,
      t.processinstid,
      t.workflow_status,
      t.is_use,
      t.modify_account,
      t.modify_time,
        t.write_time,
      datediff(NOW(),t.record_date) days,
        g.TASK_NO,
      g.TASK_NAME,
       GETDICNAME('taskfrom', g.TASK_TYPE) AS TASK_TYPE
    @}
 FROM GM_TASK_FEEDBACK t,gm_task_content g
where g.TASK_ID=t.TASK_ID
AND t.is_use = 'Y'
and (select count(0) from gm_task_detail d where d.TASK_ID = g.TASK_ID  
and if(d.ASSIS_PERSON is null,d.MAIN_PERSON=#accountId#,d.ASSIS_PERSON=#accountId#) ) > 0
@if(!isEmpty(search)){
and(
 upper(g.task_name) like #search#  ESCAPE '/'  or
 upper(g.task_content) like #search#  ESCAPE '/' 
)@}
@if(!isEmpty(workflowStatus)){
#text(workflowStatus)#
@}
@pageIgnoreTag(){
   @if(isEmpty(sort)){
        order by t.feedback_id desc
    @}
    @if(!isEmpty(sort)){
        order by #text(sort)# #text(order)#
    @}
@}   