getOrgDeptTree
===
with recursive tmp AS (
        with org_dept as (SELECT
                    o.ORG_ID id,
                    @if(fullName){
                        o.org_name text,
                    @}else{
                         o.abbr text,
                    @}
                    o.PORG_ID pid,
                    o.abbr,
                    o.sort
                FROM
                    bas_org o 
                WHERE
                    o.is_use = 'Y' 
                    @if(!withOut){
                      and ifnull( o.TYPE, '0' ) = '0'
                    @}
                    @if(!showCancel){
                      and ifnull(o.status,1)!=0 
                    @}
               @if(showDept){
                    UNION ALL
                    SELECT
                        d.DEPT_ID id,
                        @if(fullName){
                            d.dept_name text,
                        @}else{
                             d.abbr text,
                        @}
                    CASE  WHEN d.PDEPT_ID = 0 THEN
                            d.ORG_ID ELSE d.PDEPT_ID 
                        END pid,
                        d.abbr abbr,
                        d.DISPLAY_NO
                    FROM
                        bas_dept d 
                    WHERE
                        d.is_use = 'Y'
                    @if(!showCancel){
                      and ifnull(d.status,1)!=0 
                    @}
                @}
               )
    SELECT
        o1.id,
        o1.text,
        o1.pid pid,
        1 level,
        o1.sort 
    FROM
        org_dept o1 
    WHERE
       @if(withSelf&&pid!=0){
            o1.id = #pid# 
       @}else{
            o1.pid = #pid# 
       @}
    UNION ALL
    SELECT
        o2.id,
        o2.text,
        o2.pid,
        t.level+1 level,
        o2.sort 
    FROM
        org_dept o2,
        tmp t 
    WHERE
        t.id = o2.pid 
        @if(!isEmpty(level)){
        and  t.level+1<=#level#
        @}
    ) 
SELECT
    * 
FROM
    tmp p 
ORDER BY
    p.sort
    
treeBasOrg
===
with recursive tmp as 
(select o1.org_id id,
@if(!isEmpty(showFullName)&&showFullName=='Y'){
o1.org_name text,
@}else{
o1.abbr text,
@}
o1.porg_id pid,o1.sort from BAS_ORG o1 where o1.porg_id =#pid# and o1.IS_USE='Y'  
@if(isEmpty(showCancel)||showCancel!='Y'){
and ifnull(o1.status,1)!=0  
@}
@if(isEmpty(type) ){
     and ifnull(o1.type,'0')= '0'
@}
UNION ALL 
select o2.org_id id,
@if(!isEmpty(showFullName)&&showFullName=='Y'){
o2.org_name text,
@}else{
o2.abbr text,
@}
o2.porg_id pid ,o2.sort from BAS_ORG o2,tmp t  where t.id = o2.porg_id and o2.IS_USE='Y' 
@if(isEmpty(showCancel)||showCancel!='Y'){
and ifnull(o2.status,1)!=0  
@}
@if(isEmpty(type)){
  and ifnull(o2.type,'0')= '0'
@}
) select *  from tmp p  ORDER BY p.sort

findBasOrgByOne
===
select o1.org_id id,o1.abbr text,o1.porg_id pid,o1.sort from BAS_ORG o1 where o1.org_id =#org_id# and o1.IS_USE='Y'


findTaxTypeByOrgId
===
select t.*
from BAS_ORG t 
where t.is_use ='Y'
@if(!isEmpty(orgId)){
and (t.ORG_ID = #orgId#)
@}


getComboDeptForLogin
===
select
	t.dept_id value,
	t.abbr text
	from BAS_DEPT t 
	where t.is_use='Y' 
	and t.org_id=#orgId#
	
getComboxListForApplyOrg
===
WITH RECURSIVE temp AS ( 
	SELECT b.sort, b.ORG_ID,b.abbr,b.PORG_ID FROM bas_org b WHERE   b.org_id = #orgId#
	UNION ALL
	SELECT b.sort, b.ORG_ID,b.abbr,b.PORG_ID FROM bas_org b,temp t WHERE b.ORG_ID = t.PORG_ID  
)
select t.ORG_ID id,t.ORG_ID value,  t.abbr  text from temp t  order by sort


getComboxListForOrgSub
===
SELECT
	b.id id,
	b.id VALUE ,
    b.pid ,
	b.text text 
FROM
	view_bas_org_dept b 
WHERE 1=1
@if(!isEmpty(orgId)){
	and (b.pid = #orgId#
	@if(!isEmpty(self)&&self=='Y'){
	 or b.id = #orgId#
      @}
	)
@}

ORDER BY
	B.DTYPE DESC,
	B.display_no ASC
	
	
findSubUnitAndSeptNameById
===
SELECT
	b.text text 
FROM
	view_bas_org_dept b 
WHERE 1=1
@if(!isEmpty(id)){
	and b.id = #id#
@}

findAssessmentOrg
===
select 
DISTINCT
T.BELONG_ORG_ID ID,
T.BELONG_ORG_ID VALUE,
GETORGNAME(T.BELONG_ORG_ID) text
from HR_ASSESSMENT_OBJECT t where t.IS_USE = 'Y' AND T.BELONG_ORG_ID <> ''

getChargeOrgAndDept
===
select distinct t.* from view_bas_org_dept t,(
select  a.ORG_ID
from
    bas_roles_account a,
    bas_roles r
where
    r.ROLE_CODE = 'FGGSLD'
    and a.ROLE_ID = r.ROLE_ID
    and a.ACCOUNT_ID = #loginuser.accountid#
)c  where t.pid  = c.ORG_ID or t.id =  c.ORG_ID and t.type=0
union   
select distinct t.* from view_bas_org_dept t,(
select  a.ORG_ID,a.dept_id
from
    bas_roles_account a,
    bas_roles r
where
    r.ROLE_CODE = 'BMFGLD'
    and a.ROLE_ID = r.ROLE_ID
    and a.ACCOUNT_ID = #loginuser.accountid#
) c where t.id  = c.ORG_ID or t.id =  c.dept_id and t.type=0

getLeaderDept
===
select distinct t.* from view_bas_org_dept t,(
select  a.ORG_ID,a.dept_id
from
    bas_roles_account a,
    bas_roles r
where
    r.ROLE_CODE = 'DEPT_LEADER'
    and a.ROLE_ID = r.ROLE_ID
    and a.ACCOUNT_ID = #loginuser.accountid#
) c where t.id  = c.ORG_ID or t.id =  c.dept_id and t.type=0


queryOrgAndDeptTreeRoot
====
WITH recursive org AS (
SELECT
m.*
FROM
view_bas_org_dept m
WHERE
m.pid = 0
AND ifnull( m.type, '0' )= '0' UNION ALL
SELECT
m.*
FROM
view_bas_org_dept m,
org
WHERE
m.pid = org.id
AND ifnull( m.type, '0' )= '0'
) 
SELECT
t.*
FROM
org t
where t.ORG_ID = 10000000  or t.pid = 10000000
ORDER BY
t.dtype DESC,
t.display_no

findInsideOrgList
===
SELECT
    t.ORG_ID,
    t.ABBR AS ORG_NAME
FROM
    BAS_ORG t 
WHERE
   t.IS_USE = 'Y'
    AND (t.TYPE = 0 or t.TYPE is null)
    
    
    
queryOrgTreeByEscrow
===
with recursive tmp as 
(
    select 
            o1.org_id id,
            o1.abbr text,
            (case when o1.is_escrow='Y' then o1.company_id else  o1.porg_id end) pid,
            o1.sort 
    from 
            BAS_ORG o1 
    where 
    if(o1.is_escrow='Y',o1.company_id=#pid# ,o1.porg_id =#pid#  )
   and o1.IS_USE='Y'  
@if(isEmpty(type) ){
     and ifnull(o1.type,'0')= '0'
@}
UNION ALL 
select 
        o2.org_id id,
        o2.abbr text,
        (case when o2.is_escrow='Y' then o2.company_id else  o2.porg_id end) pid ,
        o2.sort 
from 
        BAS_ORG o2,
        tmp t  
 where 
 if(o2.is_escrow='Y',t.id=o2.company_id,t.id = o2.porg_id)
 and o2.IS_USE='Y'  
@if(isEmpty(type)){
  and ifnull(o2.type,'0')= '0'
@}
) select *  from tmp p  ORDER BY p.sort 


getNamesByIds
===
select
group_concat(t.TEXT) names
from
view_bas_org_dept t
where
instr(concat(',',#ids#,','),concat(',',t.id,','))>0

getSubUnitAndSOrg
===
with recursive org as
(select m.* from view_bas_org_dept m
where  m.pid=0
union all
select m.* from view_bas_org_dept m,org  where  m.pid=org.id
)
select t.*,t.id VALUE,
if((instr(concat(',',#checkValue#,','),concat(',',t.id,','))>0),'true','false') checked,
case when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state
from org t where t.pid = 10000000
ORDER by t.dtype desc,t.display_no

getMembershipOrgLogo
===
WITH recursive tmp AS (
    SELECT
        t.ORG_ID,
        t.PORG_ID,
        t.PHOTO_VERSION_ID 
    FROM
        bas_org t 
    WHERE
        t.ORG_ID = #orgId# UNION ALL
    SELECT
        t.ORG_ID,
        t.PORG_ID,
        t.PHOTO_VERSION_ID 
    FROM
        bas_org t,
        tmp t1 
    WHERE
        t.IS_USE = 'Y' 
        AND t.ORG_ID = t1.PORG_ID 
    ) SELECT
    t1.PHOTO_VERSION_ID 
FROM
    tmp t1 
WHERE
    t1.PORG_ID = '0'
    
checkRepeatCount
===
SELECT
	count(*) 
FROM
	bas_org o 
WHERE
	( o.ORG_NAME = #orgName# OR o.ABBR = #abbr#  OR o.org_code = #orgCode# or o.retrieve_Code=#retrieveCode#) 
AND o.IS_USE = 'Y' 
@if(!isEmpty(orgId) ){
	AND o.ORG_ID != #orgId#
@}

queryThisUnitAndItsSubsidiaries
===
WITH RECURSIVE temp AS (
SELECT 
tt.*
FROM bas_org tt
WHERE tt.org_id = #orgId#
UNION ALL
SELECT aa.*
FROM temp cc
JOIN bas_org aa ON cc.org_id = aa.porg_id
)
SELECT
@if(!isEmpty(isTree) && isTree){
x.porg_id pid,
@}
x.org_id id,
x.org_id value,
x.abbr text
FROM temp x
where x.IS_USE = 'Y'
order by x.sort asc

getOrgEmpNums
===
SELECT
	count(1) 
FROM
	hr_emp e 
WHERE
	e.IS_USE = 'Y' 
	AND e.ORG_ID in(
	with recursive temp as (
		select bo.org_id,bo.status  from bas_org bo 
        where 
            bo.IS_USE ='Y'
        @if(!isEmpty(getAll)&&getAll=='Y'){
            and bo.PORG_ID = 0
         @}else{
            and bo.org_id = #orgId#
         @}
		union all
		select bo2.org_id,bo2.status from bas_org bo2 join temp on bo2.PORG_ID =temp.ORG_ID  where bo2.IS_USE ='Y'
		)
		select temp.org_id from temp 
        @if(isEmpty(showCancel)||showCancel!='Y'){
            where temp.status <> '0'
        @}
	)
    @if(isEmpty(showCancel)||showCancel!='Y'){
        and e.status in ('01','02')
    @}

getBasOrgCombotree
===
```sql
WITH RECURSIVE temp AS (SELECT b.sort, b.ORG_ID, b.abbr, b.PORG_ID, b.TYPE
                        FROM bas_org b
                        WHERE b.IS_USE = 'Y'
    @ if (!isEmpty(orgId)){
    and b.org_id = #orgId#
    @}
UNION
SELECT b.sort, b.ORG_ID, b.abbr, b.PORG_ID, b.TYPE
FROM bas_org b,
     temp t
WHERE b.IS_USE = 'Y'
  and b.PORG_ID = t.ORG_ID)
select t.ORG_ID id, t.PORG_ID pid, t.ORG_ID value, t.abbr text
from temp t
where 1 = 1 @if(!isEmpty(type) && type != ''){
    and t.TYPE = #type#
    @}
order by sort
```