treeBasModelManageWithRoot
===
WITH recursive temp AS (
    SELECT
        a.MODEL_ID,
        a.MODEL_PID,
        a.MODEL_NAME,
        a.MODEL_TYPE,
        a.ORDER_NUM,
        a.IS_USE 
    FROM
        bas_model_manage a 
    WHERE
        a.IS_USE = 'Y' 
        AND a.MODEL_PID = #pid# UNION ALL
    SELECT
        a.MODEL_ID,
        a.MODEL_PID,
        a.MODEL_NAME,
        a.MODEL_TYPE,
        a.ORDER_NUM,
        a.IS_USE 
    FROM
        bas_model_manage a,
        temp t 
    WHERE
        a.IS_USE = 'Y' 
        AND a.MODEL_PID = t.MODEL_ID 
    ) SELECT
    t.MODEL_ID AS id,
    t.MODEL_PID AS PID,
    t.MODEL_NAME AS text,
    (CASE WHEN t.MODEL_TYPE = 'workspace' THEN 'iconfont icon-namesapce'
         WHEN t.MODEL_TYPE = 'theme' THEN 'iconfont icon-biz-space'
         WHEN t.MODEL_TYPE = 'mainTable' OR t.MODEL_TYPE = 'sublistTable' THEN 'iconfont icon-table'
         WHEN t.MODEL_TYPE = 'tableRelationship' THEN 'iconfont icon-relation'
         WHEN t.MODEL_TYPE = 'dataColumn' THEN 'iconfont icon-column'
         WHEN t.MODEL_TYPE = 'computedColumn' THEN 'iconfont icon-compute'
         WHEN t.MODEL_TYPE = 'condition' THEN 'iconfont icon-condition'
         ELSE '' END) AS ICO,
    t.MODEL_TYPE,
    t.ORDER_NUM 
FROM
    temp t 
WHERE t.IS_USE = 'Y' AND t.MODEL_TYPE IS NOT NULL 
    @if(!isEmpty(modelType)){
        AND t.MODEL_TYPE = #modelType#
    @}
ORDER BY
    t.ORDER_NUM
    
delBasModelManage
===
UPDATE bas_model_manage t 
SET t.IS_USE = 'N' 
WHERE
    t.MODEL_ID IN (
        WITH recursive model AS (
        SELECT
            m.* 
        FROM
            bas_model_manage m 
        WHERE
            m.MODEL_ID = #modelId# 
            AND m.IS_USE = 'Y' UNION ALL
        SELECT
            m.* 
        FROM
            bas_model_manage m,
            model 
        WHERE
            m.MODEL_PID = model.MODEL_ID 
            AND m.IS_USE = 'Y' 
        ) SELECT
        MODEL_ID 
FROM
    model)

getDataColumns
===
SELECT
    t.COLUMN_NAME,
    t.DATA_TYPE,
CASE
        WHEN t.NUMERIC_PRECISION IS NOT NULL THEN
        t.NUMERIC_PRECISION ELSE t.CHARACTER_MAXIMUM_LENGTH 
    END AS datalength,
    t.NUMERIC_SCALE AS decplace,
    t.COLUMN_COMMENT AS COMMENTS 
FROM
    INFORMATION_SCHEMA.COLUMNS t 
WHERE
    t.TABLE_SCHEMA = SCHEMA () 
    @if(!isEmpty(search)){
        AND t.COLUMN_NAME LIKE #search#
    @}
    AND t.TABLE_NAME = ( SELECT a.MODEL_CODE FROM bas_model_manage a WHERE a.MODEL_ID = #modelPid# )
    
findThemeListByWorkspace
===
WITH recursive temp AS (
    SELECT
        a.MODEL_ID,
        a.MODEL_PID,
        a.MODEL_NAME,
        a.MODEL_TYPE,
        a.ORDER_NUM 
    FROM
        bas_model_manage a 
    WHERE
        a.IS_USE = 'Y' 
        AND a.MODEL_ID = #mainId# UNION ALL
    SELECT
        a.MODEL_ID,
        a.MODEL_PID,
        a.MODEL_NAME,
        a.MODEL_TYPE,
        a.ORDER_NUM 
    FROM
        bas_model_manage a,
        temp t 
    WHERE
        a.IS_USE = 'Y' 
        AND a.MODEL_PID = t.MODEL_ID 
    ) SELECT
    t.MODEL_ID AS value,
    t.MODEL_NAME AS text
FROM
    temp t 
WHERE
    t.MODEL_TYPE = 'theme' 
ORDER BY
    t.ORDER_NUM

findThemeListByWorkspaceNew
===
SELECT
t.MODEL_ID AS value,
t.MODEL_NAME AS text
FROM bas_model_manage t
WHERE t.MODEL_TYPE = 'theme' and t.IS_USE = 'Y'
ORDER BY t.ORDER_NUM

    
findThemeSqlInfoList
===
SELECT
    t1.MODEL_ID AS THEME_ID,
    t2.MODEL_ID AS TABLE_ID,
    t3.MODEL_TYPE,
    t2.MODEL_CODE AS TABLE_NAME,
    t2.PRIMARY_KEY,
    t2.R_TABLE1,
    t2.R_TABLE2,
    t2.R_COLUMN1,
    t2.R_COLUMN2,
    t3.MODEL_ID AS COLUMN_ID,
    t3.MODEL_CODE AS COLUMN_NAME,
    t3.DATA_CAT,
    t3.EXPRESS 
FROM
    bas_model_manage t1
    INNER JOIN bas_model_manage t2 ON t2.IS_USE = 'Y' 
    AND t2.MODEL_PID = t1.MODEL_ID
    INNER JOIN bas_model_manage t3 ON t3.IS_USE = 'Y' 
    AND t3.MODEL_PID = t2.MODEL_ID 
WHERE
    t1.IS_USE = 'Y' 
    AND t1.MODEL_TYPE = 'theme' 
    @if(!isEmpty(themeIds)){
        AND FIND_IN_SET(t1.MODEL_ID,  #themeIds#) > 0
    @}
UNION ALL 
SELECT
    t1.MODEL_ID AS THEME_ID,
    t2.MODEL_ID AS TABLE_ID,
    t2.MODEL_TYPE,
    t2.MODEL_CODE AS TABLE_NAME,
    t2.PRIMARY_KEY,
    t2.R_TABLE1,
    t2.R_TABLE2,
    t2.R_COLUMN1,
    t2.R_COLUMN2,
    NULL AS COLUMN_ID,
    NULL AS COLUMN_NAME,
    NULL AS DATA_CAT,
    NULL AS EXPRESS 
FROM
    bas_model_manage t1
    INNER JOIN bas_model_manage t2 ON t2.IS_USE = 'Y' 
    AND t2.MODEL_PID = t1.MODEL_ID 
WHERE
    t1.IS_USE = 'Y' 
    AND t1.MODEL_TYPE = 'theme'
    @if(!isEmpty(themeIds)){
        AND FIND_IN_SET(t1.MODEL_ID,  #themeIds#) > 0
    @}
    
findDataCatListByThemeId
===
SELECT
    t3.MODEL_ID,
    t3.MODEL_CODE,
    t3.DATA_CAT,
    t3.MODEL_NAME 
FROM
    bas_model_manage t1
    INNER JOIN bas_model_manage t2 ON t2.IS_USE = 'Y' 
    AND t2.MODEL_PID = t1.MODEL_ID
    INNER JOIN bas_model_manage t3 ON t3.IS_USE = 'Y' 
    AND t3.MODEL_PID = t2.MODEL_ID 
    AND t3.DATA_CAT IS NOT NULL 
    AND t3.DATA_CAT NOT IN ( '-', '', '01' ) 
WHERE
    t1.IS_USE = 'Y' 
    AND t1.MODEL_TYPE = 'theme' 
    AND t1.MODEL_ID = #themeId# 
ORDER BY
    t3.ORDER_NUM
    
getModelByCode
===
select * from bas_model_manage t where t.is_use='Y' and t.MODEL_CODE=#modelCode#