BaseFlowSendInfo
===
select @pageTag(){
		z.*
	 @}
from
(
with w as
 (select t.*,
         row_number() over(partition by t.processinstid order by t.starttime) rn
    from WF_WORKITEM t),
s as
 (select t.*,
         row_number() over(partition by t.processinstid order by t.starttime desc) rn
    from WF_WORKITEM t),
b as
 (select bas.*,
         row_number() over(partition by bas.processinstid order by bas.sendtime desc) rn
    from BAS_MESSAGE bas where bas.msg_type = '1')
select 
distinct w.processinstid,
                w.processdefname,
                p.processchname,
                (case
                  when b.is_use = 'N' then
                   '已完成'
                  when b.is_use = 'Y' then
                   '流程中'
                end) status,
                a.account_id fqr_by,
                a.account_name fqr_name,
                w.workitemname fqr_itemname,
                DATE_FORMAT(w.starttime,'%Y-%m-%d %H:%i:%s') starttime,w.endtime,                 
                b.busi_main_id,
                b.form_code,                         
                (case
                  when b.is_use = 'N' then
                   null
                  when b.is_use = 'Y' then
                   s.workitemname
                end)  dq_itemname,
                (case
                  when b.is_use = 'N' then
                   null
                  when b.is_use = 'Y' then
                   (select group_concat(re.account_id) from BAS_MESSAGE_RECEIVE re where re.account_id != #admin# and re.msg_id = b.msg_id and re.is_deal = 'N')
                end)  dq_by,
                (case
                  when b.is_use = 'N' then
                   null
                  when b.is_use = 'Y' then
                   (select group_concat(dq.account_name) from BAS_MESSAGE_RECEIVE re,bas_emp_account dq where re.account_id != #admin# and dq.account_id = re.account_id and re.msg_id = b.msg_id and re.is_deal = 'N')
                end)  dq_name
from w, bas_emp_account a, WF_PROCESSDEFINE p, b,s
 where w.rn = 1
   and a.account_id = w.participant
   and w.processdefname = p.processdefname
   and w.processinstid = b.processinstid
   and b.rn = 1
   and s.rn = 1
   and w.processinstid = s.processinstid
) z
where 1 = 1
@if(!isEmpty(search)){
   and (
       z.fqr_name like #search#   or
       z.processchname like #search# or
       z.dq_name like #search#
       )
@}
@if(!isEmpty(status)){
   and z.status = #status#
@}
@pageIgnoreTag(){
	order by z.starttime desc
@}


selectWin
===
select @pageTag(){ 
	z.*
@}
  from (
SELECT
	t.*,
	a.account_name AS creator_Text,
	date_format( t.sendtime, '%Y-%m-%d %H:%i:%s' ) AS sendtime_Text ,
	rank() over ( PARTITION BY t.processinstid ORDER BY t.SENDTIME asc ) rn 
FROM
	bas_message t,
	wf_processinst w,
	bas_emp_account a 
WHERE
	w.processinstid = t.processinstid 
	AND a.account_id = w.creator 
	AND w.creator = #loginuser.accountid#
	AND w.currentstate = 12 
	AND w.currentstate <> 7 
)z where z.rn = 1 
@if(!isEmpty(filterflowid)){
	and z.processinstid not in (#join(filterflowid)#)
@}
@if(!isEmpty(search)){
   and (
       z.form_code like #search#   or
       z.msg_title like #search# or
       z.busi_main_id like #search# or
       z.msg_params like #search# or
       z.processinstid like #search# 
)@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by z.sendtime desc 
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}

selectCheckFlowWin
===
select @pageTag(){ 
	t.*,
	getaccountname(w.creator) AS creator_Text,
	to_char(t.sendtime, 'yyyy"年"mm"月"dd"日" HH24:mi:ss') AS sendtime_Text
@}
  from bas_message t, wf_processinst w
 where w.processinstid   in ( select z.processinstid from (
							select f.processinstid,f.requisition_id  from Gm_Assets_Arrival f where f.is_use = 'Y' 
							union all 
							select f.processinstid,f.requisition_id  from Gm_Assets_Arrival_Fw f where f.is_use = 'Y') z 
							where 1=1 and z.requisition_id = #conId#)
	and instr('GmAssetsArrival,GmAssetsArrivalFw',t.form_code)>0
   and t.is_use = 'Y'
   and t.msg_type = #msgType#
   and w.creator = #loginuser.accountid#
   and w.currentstate = 12
@if(!isEmpty(filterflowid)){
	and t.processinstid not in (#join(filterflowid)#)
  
@}
@if(!isEmpty(search)){
   and (
       t.form_code like #search#   or
       t.msg_title like #search# or
       t.busi_main_id like #search# or
       t.msg_params like #search# or
       t.processinstid like #search# 
)@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.sendtime desc 
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}

FindConnectFlow
===
select @pageTag(){
				t.FLOW_RELATE_ID,
		t.RELATE_FORM_CODE,
		t.RELATE_BIZ_ID,
		t.REMARK,
		t.CREATE_ACCOUNT,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
		m.msg_id,
		m.busi_main_id,
		m.form_code,
		m.processinstid,
		m.msg_title,
		m.msg_params,
		getaccountname(m.sender) AS creator_Text,
		to_char(m.sendtime, 'yyyy"年"mm"月"dd"日" HH24:mi:ss') AS sendtime_Text
	 @}
from PUB_FLOW_RELATE t
left join bas_message m
  on m.msg_id = t.msg_id
  and m.is_use = 'Y'
 where t.is_use = 'Y'
@if(!isEmpty(busiMainId)){
	and t.relate_biz_id = #busiMainId#
@}
@if(!isEmpty(formCode)){
	and t.relate_form_code = #formCode#
@}


-- 获取我的流程 1:发起,2:已办,3:未办,4:超期
getMyFlow
===
select count(1) from (
select t.busi_main_id,t.processinstid,count(1)
  from bas_message t
  left join wf_processinst p
    on t.processinstid = p.processinstid
  left join bas_message_receive r 
  on r.msg_id = t.msg_id
 where 1=1 
@if(!isEmpty(myFLow)){
	@if(myFLow=='1'){
		and p.creator = #accountId#
	   and p.currentstate in (4, 10, 12)
	@}else if(myFLow=='2'){
		and r.ACCOUNT_ID = #accountId#
		and p.currentstate in (4, 10, 12)
		and r.is_deal = 'Y'
	@}else if(myFLow=='3'){
		and r.ACCOUNT_ID = #accountId#
		and p.currentstate in (4, 10)
		and r.is_deal = 'N'
	@}else if(myFLow=='0'){
		and 1=0
	@}
@}
group by t.busi_main_id,t.processinstid)

--获得当前登录人常用流程
getMyFlowCY
===
select @pageTag(){
     r.*,et.template_type,et.id
@}
from(select 
  bp.design_name, bp.flow_name, gf.form_code,count(1) AS count

from wf_processinst p, wf_processdefine pd, stf_business_process bp,BAS_MESSAGE gf

 where p.creator =#loginuser.accountid#
   and pd.processdefname = p.processinstname
   and pd.currentstate = 3
   and bp.design_name = p.processinstname
   and p.currentstate in (4, 10, 12)
   and p.PROCESSINSTID = gf.PROCESSINSTID
   
 group by p.processinstname,bp.design_name, bp.flow_name,gf.form_code
 
 order by bp.design_name, count(1) desc)r
 
 left join EDOC_TEMPLATE et
on r.design_name = et.flow_code
 
getAccountUndoMsgCount
===
SELECT count(1)
  FROM BAS_MESSAGE t 
  join (SELECT r.msg_id 
 FROM  bas_message         s,BAS_MESSAGE_RECEIVE r
where  r.account_id = #accountId#
 and r.is_deal = 'N' 
	AND s.msg_id = r.msg_id
	AND s.is_use = 'Y'
	and s.msg_type=1
UNION
SELECT s.msg_id 
     FROM WF_AGENT            a,
			gen_form            f,
			bas_message         s,
			bas_message_receive e
WHERE s.form_code = f.form_code
	AND s.msg_id = e.msg_id
	AND e.account_id = a.agent_to_account
	AND s.is_use = 'Y'
	AND e.is_deal = 'N'
 and a.agent_account = #accountId#
	and s.msg_type=1
	AND a.is_use = 'Y'
	AND ((FIND_IN_SET( a.agent_content ,f.flow_cat_id )>0 AND
			a.end_date > now() AND
			(a.cancel_date IS NULL OR a.cancel_date > now())) OR
			a.agent_type = '2')) r
    on r.msg_id = t.msg_id   
    
 

getUndoEmpMobileByProcessinstId
===
select t.mobilephone,s.msg_title,s.form_Code,a.account_name,getdeptname(a.dept_id) dept_name,a.account_id
  from HR_EMP              t,
       bas_emp             e,
       bas_emp_account     a,
       bas_message         s,
       bas_message_receive r,
       wf_workitem         w
 where e.emp_id = a.emp_id and t.is_use ='Y' and e.is_use ='Y' and a.is_use = 'Y'
   and e.hr_emp_id = t.hr_emp_id
   and s.msg_id = r.msg_id
   and r.account_id = a.account_id
   and w.workitemid = s.workitemid
   -- and t.mobilephone is not null
   and r.is_deal = 'N'
   and w.activitydefid = #actId#
   and w.processinstid = #processInstId#  
   and s.MSG_TYPE ='1'
   
checkHolidayByDate
===
select
count(distinct(t.holiday_date))
from
hr_attendance_holiday t
where
t.is_use = 'Y'
and date_format(t.HOLIDAY_DATE, '%Y-%m-%d')=#date# and t.HOLIDAY_TYPE != '5' and t.HOLIDAY_TYPE != '4'

getTodoGreaterThan4H
===
SELECT
	count(*) cou,
	r.ACCOUNT_ID
FROM
	BAS_MESSAGE t
	LEFT JOIN wf_workitem i ON t.workitemid = i.workitemid
	LEFT JOIN BAS_MESSAGE_RECEIVE R ON  r.msg_id = t.msg_id 
WHERE
	t.msg_type NOT IN ( 3, 4, 5 ) 
	AND t.is_use = 'Y' 
	-- AND r.account_id = 0 
	AND r.is_deal = 'N' 
	AND I.CURRENTSTATE IN (
	'4',
	'10')
	and t.SENDTIME<NOW() - INTERVAL 4 hour
	group by r.ACCOUNT_ID 
	order by r.ACCOUNT_ID 
	
	
getTodoGreaterThan12H
===
SELECT
	count(*) cou,
	r.ACCOUNT_ID
FROM
	BAS_MESSAGE t
	LEFT JOIN wf_workitem i ON t.workitemid = i.workitemid
	LEFT JOIN BAS_MESSAGE_RECEIVE R ON  r.msg_id = t.msg_id 
WHERE
	t.msg_type NOT IN ( 3, 4, 5 ) 
	AND t.is_use = 'Y' 
	--  AND r.account_id = 0 
	AND r.is_deal = 'N' 
	AND I.CURRENTSTATE IN (
	'4',
	'10')
	and t.SENDTIME<NOW() - INTERVAL 12 hour
    and t.SENDTIME>NOW() - INTERVAL 72 hour
	and FROM_UNIXTIME(UNIX_TIMESTAMP(NOW()),'%H') >=8 and FROM_UNIXTIME(UNIX_TIMESTAMP(NOW()),'%H') <=18
	group by r.ACCOUNT_ID 
	order by r.ACCOUNT_ID 
	
findIsSendMsgToDay
===
select  COUNT(T.ID) from pub_flow_send_log t where DATE(t.SEND_DATE) = DATE(NOW())  AND T.IS_USE = 'Y'

listMsgByProcessAndAccount
===
select m.MSG_ID from bas_message m ,bas_message_receive r
where m.PROCESSINSTID = #processinstid#
and m.MSG_TYPE='1' 
and r.MSG_ID = m.MSG_ID
and r.IS_DEAL='Y'
AND r.ACCOUNT_ID=#accountId#
order by m.MSG_ID desc

getSwToList
===
SELECT @pageTag(){
t.*,z.biz_type,
b.account_name  AS account_Name,getdeptname(b.dept_id) dept_name,
b2.account_name AS creator,
r.is_read       AS is_read
@}
FROM BAS_MESSAGE t
left join wf_workitem i on t.workitemid=i.workitemid    left join (SELECT r.msg_id, r.account_id, r.is_read
FROM BAS_MESSAGE_RECEIVE r
where  r.account_id = #accountid# and r.is_deal = 'N'
UNION
SELECT s.msg_id, a.agent_account, e.is_read
FROM WF_AGENT            a,
gen_form            f,
bas_message         s,
bas_message_receive e
WHERE s.form_code = f.form_code
AND s.msg_id = e.msg_id
and a.agent_account = #accountid# 	
AND e.account_id = a.agent_to_account
AND s.is_use = 'Y'
AND e.is_deal = 'N'
AND a.is_use = 'Y'
AND ((concat('%,' , a.agent_content , ',%')) LIKE
(concat('%,' , f.flow_cat_id , ',%')) AND
a.end_date > now() AND
(a.cancel_date IS NULL OR a.cancel_date > now()) OR
a.agent_type = '2')) r
on r.msg_id = t.msg_id
LEFT JOIN bas_emp_account b
ON t.sender = b.account_id
LEFT JOIN WF_PROCESSDEFINE_PROCESSINST w
ON t.processinstid = w.processinstid
LEFT JOIN bas_emp_account b2
ON w.creator = b2.account_id
LEFT JOIN stf_business_process y
ON y.design_name = w.PROCESSDEFNAME
LEFT JOIN STF_BUSINESS_type z
ON z.res_id = y.business_type_id
WHERE t.is_use = 'Y' and i.CURRENTSTATE in(4,10)
and  #businessType# like concat('%,',z.res_id,',%')
@if(!isEmpty(startDate)){
and date_format(t.SENDTIME, '%Y-%m-%d') >= #startDate#
@}
@if(!isEmpty(endDate)){
and  date_format(t.SENDTIME, '%Y-%m-%d') <= #endDate#
@}
@if(!isEmpty(search)){
and(
upper(t.MSG_TITLE) like #search#  ESCAPE '/'  or
upper(b.account_name) like #search#  ESCAPE '/'
)@}
and r.account_id = #accountid#
AND t.msg_type NOT IN (3, 4, 5)
and not exists (select 1 from bas_message_collapse c where c.is_common='Y' and c.is_use='Y' and c.flow_code = y.design_name and (find_in_set (i.ACTIVITYDEFID,c.act_id)!=0 or c.act_id is null or c.ACT_ID='' )) 
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
@if(isEmpty(sort)){
order by t.SENDTIME desc
@}
@if(!isEmpty(sort)){
order by #text(sort)# #text(order)#
@}
@}

getMsgAccount
===
select
br.account_id
from
bas_message t
join bas_message_receive br on br.msg_id = t.msg_id
where t.msg_id = #msgId#


findBasMessageByAccountIdAndProcessinstid
===
select 
t.*,
r.account_id receive_account
from Bas_Message t, 
BAS_MESSAGE_RECEIVE r

where r.msg_id = t.msg_id
and (r.ACCOUNT_ID =#accountid# or exists (select 1
from WF_AGENT a, gen_form f,  bas_message_receive e
where   f.form_code =t.form_code
and e.account_id = a.agent_to_account
and e.msg_id=t.msg_id
and a.agent_to_account=r.account_id
and a.agent_account = #accountid#
and( (concat('%,' , a.agent_content , ',%') like concat('%,' , f.flow_cat_id , ',%')
and a.end_date > now()
and (a.cancel_date is null or a.cancel_date > now())) or a.agent_type='2')) )
@if(!isEmpty(dbType)){
and t.msg_type = 1
@if("YB" == dbType){
and r.is_deal = 'Y'
@}
@if("DB" == dbType){
and r.IS_DEAL = 'N'
@}
@}
@if(!isEmpty(msgId)){
and t.msg_id = #msgId#
@}
and t.processinstid = #processinstid#

checkIsHaveNotDeal
===
select
count(1)
from
wf_workitem ww
join bas_message bm on bm.PROCESSINSTID = ww.PROCESSINSTID
where
bm.msg_id = #msgId#
and
(
(
ww.CURRENTSTATE in (4,10)
and
ww.PARTICIPANT = #accountId#)
or
(
ww.workitemid in (
select
wwa.workitemid
from
wf_workitem_add  wwa
where
concat(",",wwa.add_persons,",") like concat("%,",#accountId#,",%")
)
and ww.CURRENTSTATE in (4,10)
)
)

findStartMsg
===
select
r.*
from
bas_message t
left join bas_message_receive r on
t.MSG_ID = r.MSG_ID
where
r.ACCOUNT_ID = #receiveId#
and
t.PROCESSINSTID = #processinstid#
and
t.MSG_TITLE like "%发起流程%"
and r.IS_READ ='N'
limit 1

getDbMsgAndReceiveId
===
select
t.msg_id
from
bas_message t
join bas_message_receive r
where
t.is_use = 'Y' and t.msg_type = '1'
and r.account_id = #receiveId#
and t.processinstid = #processinstid#


getHaveDoneSumList
===
select
a.res_id,
a.name,
a.res_color,
a.res_ico
from
STF_BUSINESS_TYPE a
where
a.PARENT_ID = 0
and exists (
select
1
from wf_processinst w  
LEFT JOIN STF_BUSINESS_PROCESS e ON e.design_name = w.PROCESSINSTNAME
LEFT JOIN stf_business_type y ON y.res_id = e.business_type_id
where
y.res_id in
(
with recursive temp as(
select aa.* from stf_business_type aa where  aa.RES_ID = a.res_id
union all
select aa.* from stf_business_type aa,temp t where aa.PARENT_ID=t.RES_ID  )
select t.res_id id from temp t order by t.res_id
)
and exists(
select
t.participant
from
wf_workitem t
where
t.PARTICIPANT = #accountid# and t.CURRENTSTATE = 12
and
t.PROCESSINSTID = w.PROCESSINSTID
)
)
order by
a.ORDER_INDEX

getHaveDoneSumListOld
===
select
a.res_id,
a.name,
a.res_color,
a.res_ico
from
STF_BUSINESS_TYPE a
where
a.PARENT_ID = 0
and exists (
select
t.processinstid
from
wf_workitem t
left join wf_processinst w on t.PROCESSINSTID = w.PROCESSINSTID
LEFT JOIN STF_BUSINESS_PROCESS e ON e.design_name = w.PROCESSINSTNAME
LEFT JOIN stf_business_type y ON y.res_id = e.business_type_id
where
t.PARTICIPANT = #accountid# and t.CURRENTSTATE = 12
AND y.res_id in
(
with recursive temp as(
select aa.* from stf_business_type aa where  aa.RES_ID = a.res_id
union all
select aa.* from stf_business_type aa,temp t where aa.PARENT_ID=t.RES_ID  )
select t.res_id id from temp t order by t.res_id
)
) 