select
===
with tmp as
 (select g.GROUP_ID,
         group_concat(concat(g.user_type,':',g.user_id) ORDER BY g.user_id) user_id,
         group_concat((case
                   when g.user_type = 'dept' then
                    getdeptname(g.user_id)
                   when g.user_type = 'org' then
                    getbaseabbr(g.user_id)
                   when g.user_type = 'user' then
                    getaccountname(g.user_id)
                 end) ORDER BY g.user_id) user_name
    from BAS_GROUP_ACCOUNT_RELATE g
   where g.is_use = 'Y'
   group by g.GROUP_ID)
select @pageTag(){
				t.GROUP_ID,
		t.GROUP_NAME,
		t.STATUS,
        GETDICNAME('GROUP_STATUS',t.STATUS) STATUS_TEXT,
		t.GROUP_ORG,
        GETORGNAME(t.GROUP_ORG) GROUP_ORG_TEXT,
		t.GROUP_OWNER,
        GETACCOUNTNAME(t.GROUP_OWNER) GROUP_OWNER_TEXT,
		t.GROUP_TYPE,
        GETDICNAME('GROUP_TYPE',t.GROUP_TYPE) GROUP_TYPE_TEXT,
		t.ORDER_NUM,
		t.CREATE_ACCOUNT,
		getaccountname(t.CREATE_ACCOUNT)CREATE_ACCOUNT_name,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
        t.REMARK,
		p.user_id group_component,
		p.user_name group_component_TEXT
	 @}
from BAS_GROUP t
left join tmp p on t.GROUP_ID = p.GROUP_ID
where t.is_use = 'Y'
@if(!isEmpty(applyPerson)){
    and getaccountname(t.CREATE_ACCOUNT)  like #applyPerson# ESCAPE '/'  
@}
@if(!isEmpty(mgrFilter)){
    and (t.CREATE_ACCOUNT=#loginuser.accountid# or
          (t.GROUP_TYPE='1' 
             and ( exists(select 1 from bas_group_scope s where s.group_id = t.group_id and   s.is_use='Y' and
                                        ((s.user_type = 'user' and s.user_id=#loginuser.accountid#) 
                                        or (s.user_type = 'dept' and s.user_id=#loginuser.deptid#) 
                                        or (s.user_type = 'org' and s.user_id=#loginuser.orgid#))
                        ) 
                    or not exists(select 1 from bas_group_scope s where s.group_id = t.group_id and s.is_use='Y' ) 
                 )
          )  
        )
@}else if(loginuser.accountid!=0){
    and t.CREATE_ACCOUNT=#loginuser.accountid# 
@}
@if(!isEmpty(dept)){
    and t.APPLY_DEPT= #dept#
@}
@if(!isEmpty(startDate) && !isEmpty(endDate)){
and (t.CREATE_TIME
 between STR_TO_DATE(#startDate#,'%Y-%m-%d') and STR_TO_DATE(#endDate#,'%Y-%m-%d'))
@}
@if(!isEmpty(search)){
and(
 upper(t.GROUP_NAME) like #search#  ESCAPE '/'  or
 upper(p.user_name) like #search#  ESCAPE '/'
)@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.GROUP_ID desc
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}

findByAccountIdAndRoleId
===
select t.*
from BAS_ROLES_ACCOUNT t
where 1=1
@if(!isEmpty(accountId)){
and t.ACCOUNT_ID=#accountId#
@}
@if(!isEmpty(roleId)){
and t.ROLE_ID=#roleId#
@}

getComponentsByGroupId
===
with tmp as
 (select g.GROUP_ID,
         group_concat(concat(g.user_type,':',g.user_id) ORDER BY g.user_id) user_id,
         group_concat((case
                   when g.user_type = 'dept' then
                    getdeptname(g.user_id)
                   when g.user_type = 'org' then
                    getbaseabbr(g.user_id)
                   when g.user_type = 'user' then
                    getaccountname(g.user_id)
                 end) ORDER BY g.user_id) user_name
    from BAS_GROUP_ACCOUNT_RELATE g
   where g.is_use = 'Y'
	and  g.GROUP_ID=#groupId#
   group by g.GROUP_ID),
scope as
 (select g.GROUP_ID,
         group_concat(concat(g.user_type,':',g.user_id) ORDER BY g.user_id) scope_id,
         group_concat((case
                   when g.user_type = 'dept' then
                    getdeptname(g.user_id)
                   when g.user_type = 'org' then
                    getbaseabbr(g.user_id)
                   when g.user_type = 'user' then
                    getaccountname(g.user_id)
                 end) ORDER BY g.user_id) scope_name
    from BAS_GROUP_SCOPE g
   where g.is_use = 'Y'
    and  g.GROUP_ID=#groupId#
   group by g.GROUP_ID)
select 
p.user_id,
p.user_name,
s.scope_id,
s.scope_name
from BAS_GROUP t 
left join tmp p on t.GROUP_ID = p.GROUP_ID
left join scope S on t.GROUP_ID = S.GROUP_ID
where t.is_use = 'Y'
@if(!isEmpty(groupId)){
	and t.GROUP_ID=#groupId#
@}


getAllGroup
===
```mysql
select
        t.GROUP_ID as id,
        t.GROUP_ID as value,
        t.GROUP_NAME as text,
        t.GROUP_TYPE as group_type
from 
        BAS_GROUP t
where 
        t.is_use = 'Y'
@if(!isEmpty(mgrFilter)){
        and (t.CREATE_ACCOUNT=#loginuser.accountid# or
                (t.GROUP_TYPE='1' 
                 and ( exists(select 1 from bas_group_scope s where s.group_id = t.group_id and s.is_use='Y' and
                                           ( (s.user_type = 'user' and s.user_id=#loginuser.accountid#) 
                                            or (s.user_type = 'dept' and s.user_id=#loginuser.deptid#) 
                                            or (s.user_type = 'org' and s.user_id=#loginuser.orgid#) )
                            ) 
                        or not exists(select 1 from bas_group_scope s where s.group_id = t.group_id and s.is_use='Y' ) 
                      )
                )  
        )
@}else if(loginuser.accountid!=0){
        and t.CREATE_ACCOUNT=#loginuser.accountid# 
@}
@if(!isEmpty(dept)){
        and t.APPLY_DEPT= #dept#
@}
@if(!isEmpty(startDate) && !isEmpty(endDate)){
        and (t.CREATE_TIME
        between STR_TO_DATE(#startDate#,'%Y-%m-%d') and STR_TO_DATE(#endDate#,'%Y-%m-%d'))
@}
@if(!isEmpty(groupName)){
        and(
        upper(t.GROUP_NAME) like #groupName#  ESCAPE '/'  
)@}
@if(!isEmpty(search)){
        and(
         upper(t.GROUP_NAME) like #search#  ESCAPE '/'  
)@}
@if(!isEmpty(flowsql)){
        #text(flowsql)#
@}
@pageIgnoreTag(){
        @if(isEmpty(sort)){
                order by t.GROUP_ID desc
        @}
        @if(!isEmpty(sort)){
                order by #text(sort)# #text(order)#
        @}
@}
```



findByGroupType
===
```mysql
SELECT
        t.*
FROM
        BAS_GROUP t
WHERE
        t.is_use = 'Y'
@if(!isEmpty(groupType)){
        and t.GROUP_TYPE=#groupType#
@}
@if(!isEmpty(searchCommonGroup)){
        and (
                -- 创建人是当前登录人
                t.CREATE_ACCOUNT=#loginuser.accountid# 
                or
                (
                        -- 公有组
                        t.GROUP_TYPE='1'
                        and ( 
                                -- 公有组范围包含自己
                                exists(select 1 from bas_group_scope s where s.group_id = t.group_id and   s.is_use='Y' and
                                ((s.user_type = 'user' and s.user_id=#loginuser.accountid#)
                                or (s.user_type = 'dept' and s.user_id=#loginuser.deptid#)
                                or (s.user_type = 'org' and s.user_id=#loginuser.orgid#))
                                )
                                -- 或者组没有配置范围
                                or not exists(select 1 from bas_group_scope s where s.group_id = t.group_id and s.is_use='Y' )
                        )
                )
        )
@}else if(loginuser.accountid!=0){
        and t.CREATE_ACCOUNT=#loginuser.accountid#
@}
```


