

pageAll
===
select @pageTag(){
t.statistics_id,
t.statistics_day,
t.login_num,
t.not_login_num
	 @}
from BAS_EMP_LOGIN_STATISTICS t
where t.is_use = 'Y'
@if(!isEmpty(startDate) && !isEmpty(endDate)){
and t.statistics_day
	between #startDate# and #endDate#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.statistics_id desc
    @}else{
   	 order by #text(sort)# #text(order)#
    @}
@}

getLoginNum
===
select count(1)
from (select distinct ACCOUNT_ID
from bas_sys_loginlog
where LOGIN_TIME between STR_TO_DATE(#startDate#, '%Y-%m-%d') and STR_TO_DATE(#endDate#, '%Y-%m-%d')) t

getTotalEmpNum
===
select count(1)
from bas_emp
where IS_USE = 'Y'

getLoginInfo
===
select t3.ORG_ID      orgId,
t3.ORG_NAME    orgName,
t4.DEPT_ID     deptId,
t4.DEPT_NAME   deptName,
t2.EMP_NAME    empBame,
t1.LOGIN_COUNT loginCount
from (select EMP_ID, count(*) LOGIN_COUNT
from bas_sys_loginlog
where LOGIN_TIME between STR_TO_DATE(#startDate#, '%Y-%m-%d') and STR_TO_DATE(#endDate#, '%Y-%m-%d')
group by ACCOUNT_ID) t1
left join bas_emp t2 on t1.EMP_ID = t2.EMP_ID
left join bas_org t3 on t3.ORG_ID = t2.ORG_ID
left join bas_dept t4 on t4.DEPT_ID = t2.DEPT_ID
where t2.IS_USE = 'Y'

getOrgLoginNum
===
select count(distinct t1.emp_id)
from bas_emp t1
left join bas_org t2 on t1.ORG_ID = t2.ORG_ID
left join bas_sys_loginlog t3 on t3.EMP_ID = t1.EMP_ID
where t1.IS_USE = 'Y' and t2.ORG_ID = #orgId#
and t3.LOGIN_TIME between STR_TO_DATE(#startDate#, '%Y-%m-%d') and STR_TO_DATE(#endDate#, '%Y-%m-%d')

getOrgTotalEmpNum
===
select count(*)
from bas_emp t1
left join bas_org t2 on t1.ORG_ID = t2.ORG_ID
where t1.IS_USE = 'Y' and t1.ORG_ID = #orgId#

getTopTen
===
select t3.ORG_NAME "orgName", t4.DEPT_NAME "deptName", t1.EMP_NAME "empName", count(1) "loginNum"
from bas_emp t1
left join bas_sys_loginlog t2 on t1.EMP_ID = t2.EMP_ID
left join bas_org t3 on t1.ORG_ID = t3.ORG_ID
left join bas_dept t4 on t1.DEPT_ID = t4.DEPT_ID
where t2.LOGIN_TIME between STR_TO_DATE(#startDate#, '%Y-%m-%d') and STR_TO_DATE(#endDate#, '%Y-%m-%d')
group by t3.ORG_NAME, t4.DEPT_NAME, t1.EMP_NAME
order by loginNum desc
limit 0, 10






