pageAll
===
SELECT @pageTag(){
    t.WARNING_SETTING_ID,
    t.SETTING_CODE,
    t.SETTING_NAME,
    t.WARNING_TYPE,
    t1.MODEL_NAME AS WARNING_TYPE_NAME,
    t.BUSINESS_TYPE,
    t2.MODEL_NAME AS BUSINESS_TYPE_NAME,
    t.IS_ENABLE,
    t.MENU_ID,
    t3.MENU_NAME 
@}
FROM
    bas_early_warning_setting t
    INNER JOIN bas_model_manage t1 ON t.WARNING_TYPE = t1.MODEL_ID
    INNER JOIN bas_model_manage t2 ON t.BUSINESS_TYPE = t2.MODEL_ID
    left JOIN bas_menu t3 ON t.MENU_ID = t3.MENU_ID 
WHERE
    t.IS_USE = 'Y' 
    @if(!isEmpty(search)){
        AND (t.SETTING_CODE LIKE #search# OR t.SETTING_NAME LIKE #search#) 
    @}
    @if(!isEmpty(warningType)){
        AND t.WARNING_TYPE = #warningType#
    @}
@pageIgnoreTag(){
    @if(isEmpty(sort)){
        ORDER BY t.WARNING_SETTING_ID DESC
    @}else{
        order by #text(sort)# #text(order)#
    @}
@}

findEarlyWarningThemeList
===
SELECT DISTINCT
    q.*,
    q1.MODEL_NAME AS WORKSPACE_NAME,
    q2.MODEL_NAME AS THEME_NAME,
    q1.order_num
FROM
    (
    SELECT
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE AS WORKSPACE_ID,
        t1.BUSINESS_TYPE AS THEME_ID,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE,
        t1.DEAL_SCRIPT
    FROM
        bas_early_warning_use t,
        bas_early_warning_setting t1,
        bas_roles_account f1,
        bas_emp_account f2 
    WHERE
        t.IS_USE = 'Y' 
        AND t1.IS_USE = 'Y' 
        and t1.IS_ENABLE='1'
        AND t.WARNING_SETTING_ID = t1.WARNING_SETTING_ID 
        AND t.USER_TYPE = 'role' 
        AND LOCATE( '\>', t.USER_ID ) = 0 
        AND f1.ACCOUNT_ID = f2.ACCOUNT_ID 
        AND f1.ROLE_ID = t.USER_ID 
        @if(!isEmpty(workspaceId)){
            AND t1.WARNING_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_ID = #workspaceId# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            ) 
        @}
        @if(!isEmpty(themeId)){
            AND t1.BUSINESS_TYPE = #themeId# 
        @}
        @if(!isEmpty(themeCode)){
            AND t1.BUSINESS_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_code = #themeCode# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            )
        @}
        AND f2.EMP_ID = #empId# UNION ALL
    SELECT
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE AS WORKSPACE_ID,
        t1.BUSINESS_TYPE AS THEME_ID,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE,
        t1.DEAL_SCRIPT
    FROM
        bas_early_warning_use t,
        bas_early_warning_setting t1,
        bas_roles_account f1,
        bas_emp_account f2 
    WHERE
        t.IS_USE = 'Y' 
        AND t1.IS_USE = 'Y' 
        and t1.IS_ENABLE='1'
        AND t.WARNING_SETTING_ID = t1.WARNING_SETTING_ID 
        AND t.USER_TYPE = 'role' 
        AND t.USER_ID LIKE '%>%' 
        AND t.USER_ID NOT LIKE '%>%>%' 
        AND LOCATE( '\%', t.USER_ID ) = 0 
        AND f1.ACCOUNT_ID = f2.ACCOUNT_ID 
        AND CONCAT( f1.ORG_ID, '>', f1.ROLE_ID ) = t.USER_ID 
        @if(!isEmpty(workspaceId)){
            AND t1.WARNING_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_ID = #workspaceId# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            ) 
        @}
        @if(!isEmpty(themeId)){
            AND t1.BUSINESS_TYPE = #themeId# 
        @}
         @if(!isEmpty(themeCode)){
            AND t1.BUSINESS_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_code = #themeCode# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            )
        @}
        AND f2.EMP_ID = #empId# UNION ALL
    SELECT
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE AS WORKSPACE_ID,
        t1.BUSINESS_TYPE AS THEME_ID,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE,
        t1.DEAL_SCRIPT
    FROM
        bas_early_warning_use t,
        bas_early_warning_setting t1,
        bas_roles_account f1,
        bas_emp_account f2 
    WHERE
        t.IS_USE = 'Y' 
        AND t1.IS_USE = 'Y' 
        AND f2.IS_USE = 'Y' 
        and t1.IS_ENABLE='1'
        AND t.WARNING_SETTING_ID = t1.WARNING_SETTING_ID 
        AND t.USER_TYPE = 'role' 
        AND t.USER_ID LIKE '%>%>%' 
        AND LOCATE( '\%', t.USER_ID ) = 0 
        AND f1.ACCOUNT_ID = f2.ACCOUNT_ID 
        AND CONCAT( f1.ORG_ID, '>', f1.DEPT_ID, '>', f1.ROLE_ID ) = t.USER_ID 
        @if(!isEmpty(workspaceId)){
            AND t1.WARNING_TYPE = #workspaceId# 
        @}
        @if(!isEmpty(themeId)){
            AND t1.BUSINESS_TYPE = #themeId# 
        @}
         @if(!isEmpty(themeCode)){
            AND t1.BUSINESS_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_code = #themeCode# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            )
        @}
        AND f2.EMP_ID = #empId# UNION ALL
    SELECT
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE AS WORKSPACE_ID,
        t1.BUSINESS_TYPE AS THEME_ID,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE,
        t1.DEAL_SCRIPT
    FROM
        bas_early_warning_use t,
        bas_early_warning_setting t1 
    WHERE
        t.IS_USE = 'Y' 
        AND t1.IS_USE = 'Y' 
        and t1.IS_ENABLE='1'
        AND t.WARNING_SETTING_ID = t1.WARNING_SETTING_ID 
        AND t.USER_TYPE = 'user' 
        AND LOCATE( '%', t.USER_ID ) = 0 
        AND t.USER_ID = #empId# 
        @if(!isEmpty(workspaceId)){
            AND t1.WARNING_TYPE = #workspaceId# 
        @}
         @if(!isEmpty(themeCode)){
            AND t1.BUSINESS_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_code = #themeCode# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            )
        @}
        @if(!isEmpty(themeId)){
            AND t1.BUSINESS_TYPE = #themeId# 
        @} 
    ) q
    LEFT JOIN bas_model_manage q1 ON q.WORKSPACE_ID = q1.MODEL_ID
    LEFT JOIN bas_model_manage q2 ON q.THEME_ID = q2.MODEL_ID

findEarlyWarningThemeListForData
===
SELECT
    q.WARNING_SETTING_ID,
    q.WORKSPACE_ID,
    q.THEME_ID,
    q.MENU_ID,
    q.IS_DEAL_IN_FORM,
    q.FORM_CODE,
    q1.MODEL_NAME AS WORKSPACE_NAME,
    q1.order_num,
    q2.MODEL_NAME AS THEME_NAME,
    GROUP_CONCAT( q.ORG_IDS ) AS ORG_IDS,
    GROUP_CONCAT( q.DEPT_IDS ) AS DEPT_IDS,
    GROUP_CONCAT( q.EMP_IDS ) AS EMP_IDS,
     q.DEAL_SCRIPT
FROM
    (
    SELECT DISTINCT
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE AS WORKSPACE_ID,
        t1.BUSINESS_TYPE AS THEME_ID,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE,
        GROUP_CONCAT( DISTINCT f1.ORG_ID ) AS ORG_IDS,
        NULL AS DEPT_IDS,
        NULL AS EMP_IDS ,
        t1.DEAL_SCRIPT
    FROM
        bas_early_warning_use t,
        bas_early_warning_setting t1,
        bas_roles_account f1,
        bas_emp_account f2 
    WHERE
        t.IS_USE = 'Y' 
        AND t1.IS_USE = 'Y' 
        AND f2.IS_USE = 'Y' 
        and t1.IS_ENABLE='1'
        AND t.WARNING_SETTING_ID = t1.WARNING_SETTING_ID 
        AND t.USER_TYPE = 'role' 
        AND t.USER_ID LIKE '%>%' 
        AND t.USER_ID NOT LIKE '%>%>%' 
        AND f1.ACCOUNT_ID = f2.ACCOUNT_ID 
        AND CONCAT( '%>', f1.ROLE_ID ) = t.USER_ID 
        @if(!isEmpty(workspaceId)){
            AND t1.WARNING_TYPE  in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_ID = #workspaceId# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            ) 
        @}
        @if(!isEmpty(themeId)){
            AND t1.BUSINESS_TYPE = #themeId# 
        @}
        AND f2.EMP_ID = #empId# 
    GROUP BY
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE,
        t1.BUSINESS_TYPE,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE UNION ALL
    SELECT DISTINCT
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE AS WORKSPACE_ID,
        t1.BUSINESS_TYPE AS THEME_ID,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE,
        NULL AS ORG_IDS,
        GROUP_CONCAT( DISTINCT f1.DEPT_ID ) AS DEPT_IDS,
        NULL AS EMP_IDS ,
        t1.DEAL_SCRIPT
    FROM
        bas_early_warning_use t,
        bas_early_warning_setting t1,
        bas_roles_account f1,
        bas_emp_account f2 
    WHERE
        t.IS_USE = 'Y' 
        AND t1.IS_USE = 'Y' 
        AND f2.IS_USE = 'Y' 
        and t1.IS_ENABLE='1'
        AND t.WARNING_SETTING_ID = t1.WARNING_SETTING_ID 
        AND t.USER_TYPE = 'role' 
        AND t.USER_ID LIKE '%>%>%' 
        AND f1.ACCOUNT_ID = f2.ACCOUNT_ID 
        AND CONCAT( '%>%>', f1.ROLE_ID ) = t.USER_ID 
        @if(!isEmpty(workspaceId)){
            AND t1.WARNING_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_ID = #workspaceId# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            ) 
        @}
        @if(!isEmpty(themeId)){
            AND t1.BUSINESS_TYPE = #themeId# 
        @}
        AND f2.EMP_ID = #empId# 
    GROUP BY
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE,
        t1.BUSINESS_TYPE,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE UNION ALL
    SELECT DISTINCT
        t1.WARNING_SETTING_ID,
        t1.WARNING_TYPE AS WORKSPACE_ID,
        t1.BUSINESS_TYPE AS THEME_ID,
        t1.MENU_ID,
        t1.IS_DEAL_IN_FORM,
        t1.FORM_CODE,
        NULL AS ORG_IDS,
        NULL AS DEPT_IDS,
        CONCAT(#empId#, '') AS EMP_IDS ,
        t1.DEAL_SCRIPT
    FROM
        bas_early_warning_use t,
        bas_early_warning_setting t1 
    WHERE
        t.IS_USE = 'Y' 
        AND t1.IS_USE = 'Y' 
        and t1.IS_ENABLE='1'
        AND t.WARNING_SETTING_ID = t1.WARNING_SETTING_ID 
        AND t.USER_TYPE = 'user' 
        AND LOCATE( '%', t.USER_ID ) > 0 
        @if(!isEmpty(workspaceId)){
            AND t1.WARNING_TYPE in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_ID = #workspaceId# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            ) 
        @}
        @if(!isEmpty(themeId)){
            AND t1.BUSINESS_TYPE = #themeId# 
        @}
    ) q 
    LEFT JOIN bas_model_manage q1 ON q.WORKSPACE_ID = q1.MODEL_ID
    LEFT JOIN bas_model_manage q2 ON q.THEME_ID = q2.MODEL_ID
    where 1=1 
    @if(!isEmpty(themeCode)){
            AND q.THEME_ID in(
                    WITH recursive model AS (
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m 
                    WHERE
                        m.MODEL_code = #themeCode# 
                        AND m.IS_USE = 'Y' UNION ALL
                    SELECT
                        m.* 
                    FROM
                        bas_model_manage m,
                        model 
                    WHERE
                        m.MODEL_PID = model.MODEL_ID 
                        AND m.IS_USE = 'Y' 
                    ) SELECT MODEL_ID  FROM model
            )
        @}
GROUP BY
    q.WARNING_SETTING_ID,
    q.WORKSPACE_ID,
    q.THEME_ID,
    q.MENU_ID,
    q.IS_DEAL_IN_FORM,
    q.FORM_CODE
    
