<%@ page language="java" pageEncoding="UTF-8"
         contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<link rel="stylesheet" href="${ctx}/static/plugins/printPreview/css/print-preview.css" type="text/css" media="all">
<jsp:include page="../common/common.jsp"></jsp:include>
<script type="text/javascript" src="${ctx}/static/plugins/qrcode/jqeury-qrcode.js"></script>
<script type="text/javascript" src="${ctx}/static/plugins/printPreview/jquery.print-preview.js"></script>
<html>
<head>
    <%--    1、页面由打印a标签和table组成--%>
</head>
<body>
<a onclick="printDiv()" id="printDiv" class="easyui-linkbutton"
   style="display:block;width:80px;position:fixed;left:300;top:0"
   data-options="iconCls:'icon-printer iconfont blue',plain:true">打印</a>
<div style="text-align: center;width:208mm;margin: auto;" id="maindiv">
    <div id="GmAssetsMaterialReq" align=center>
        <style>
            body, td, th, label {
                font-family: 楷体;
                font-size: 14px;
                color: #1d1007;
            }

            .printtable tr, .printtable tr td {
                height: 60px;
                border: 1px solid;
                text-align: center
            }

            .checkboxStyle {
                display: inline-block;
                margin-left: 50px;
            }
        </style>
        <table class="printtable" cellpadding=0 cellspacing=0
               style="margin-top: 30px;width:180mm;border-collapse:collapse;">
            <col width="120px"/>
            <col width="120px"/>
            <col width="120px"/>
            <col width="120px"/>
            <col width="108px"/>
            <col width="108px"/>

            <tr style="border:none;height: 60px">
                <td style="border:none;"></td>
                <td colspan=4 style="border:none;text-align:center">
                    <span style="font-size: 24px;font-weight: bold;">${ObjectMap.orgName}</span>
                </td>
                <!-- 放置二维码的内容 style="border:none;"-->
                <td rowspan=3 style="border:none">
                    <div id="qrcode" class="code"></div>
                </td>
            </tr>

            <%--            头部--%>
            <tr style="border:none;height: 29px">
                <td style="border:none;"></td>
                <td colspan=4 style="border:none;text-align:center">
                    <span style="font-size: 24px;font-weight: bold;">信息化需求申请单</span>
                </td>
            </tr>
            <tr style="border:none;height: 15px">
                <td colspan=3 style="border:none;height: 15px;text-align:left">
                    <span></span>
                </td>
                <td colspan=3 style="border: none; height: 15px;text-align:left">
                </td>
            </tr>
            <tr style="border:none;height: 50px">
                <td>申请单位:</td>
                <td colspan=2>江东控股集团有限责任公司</td>
                <td>申请部门:</td>
                <td colspan=2> ${ObjectMap.deptName}</td>
            </tr>
            <tr style="border:none;height: 50px">
                <td>申请人:</td>
                <td colspan=2> ${ObjectMap.ApplyManName}</td>
                <td>申请日期:</td>
                <td colspan=2>  <fmt:formatDate value="${ObjectMap.applyDate}" pattern="yyyy-MM-dd"/></td>
            </tr>
            <tr style="border:none;height: 80px">
                <td>需求类型:</td>
                <td colspan=5 style="text-align:left;padding-left: 10px"> ${ObjectMap.demandTypeText}</td>
            </tr>
            <tr style="border:none;height: 80px">
                <td>需求说明:</td>
                <td colspan=5 style="text-align:left;padding-left: 10px"> ${ObjectMap.remark}</td>
            </tr>

            <c:if test="${!empty pfrList}">
            <tr style="border:none;height: 50px">
<%--                rowsspan根据pfrList的大小+1设置--%>
                <td rowspan="${pfrList.size()+1}">关联流程</td>
                <td colspan="2">消息标题</td>
                <td colspan=1>发送人</td>
                <td colspan="2">发送时间</td>
            </tr>
            </c:if>
            <c:forEach items="${pfrList}" var="item" varStatus="status">
                <tr style="border:none;height: 50px">
                    <td colspan="2">${item.msgTitle}</td>
                    <td colspan=1>${item.creatorText}</td>
                    <td colspan="2">${item.sendtimeText}</td>
                </tr>
            </c:forEach>


            <tr>
                <td style="height: 80px; text-align: center" rowspan="3">审批意见</td>
                <td colspan="5" style="text-align: left;" colspan="3">
                    <c:if test="${!empty advices.Act_2}">
                        <div style="text-align: left;bottom: 5px">&nbsp;${advices.Act_2}</div>
                        <div style="border-bottom: 1px dashed #000;margin: 10px;text-align: right;">${sender.Act_2}&nbsp;${adviceTime.Act_2}&nbsp;</div>
                    </c:if>
                </td>
            </tr>

            <tr>

                <td colspan="5" style="text-align: left;" colspan="3">
                    <c:if test="${!empty advices.Act_3}">
                        <div style="text-align: left;bottom: 5px">&nbsp;${advices.Act_3}</div>
                        <div style="border-bottom: 1px dashed #000;margin: 10px;text-align: right;">${sender.Act_3}&nbsp;${adviceTime.Act_3}&nbsp;</div>
                    </c:if>
                </td>
            </tr>
            <tr>

                <td colspan="5" style="text-align: left;" colspan="3">
                    <c:if test="${!empty advices.Act_4}">
                        <div style="text-align: left;bottom: 5px">&nbsp;${advices.Act_4}</div>
                        <div style="border-bottom: 1px dashed #000;margin: 10px;text-align: right;">${sender.Act_4}&nbsp;${adviceTime.Act_4}&nbsp;</div>
                    </c:if>
                </td>
            </tr>




        </table>
    </div>
</div>
<script type="text/javascript">

    function printDiv() {
        $.printPreview.loadPrintPreview("#maindiv")
    }

    $("#printDiv").css('right', $("body").width() / 2 - 350)
</script>
</body>
</html>
