
var fmReceiveTotalApiLogGrid = $("#fmReceiveTotalApiLogGrid");
$(function(){
	initFmReceiveTotalApiLogGrid();
});


/**
 * 初始化
 */
function initFmReceiveTotalApiLogGrid(){
	fmReceiveTotalApiLogGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#fmReceiveTotalApiLogGridTbar",
	    url:ctx+'/fmReceiveTotalApiLog/pageAll',
	    columns:[[
	    {field:'logMsg',title:'日志内容',width:100,align:'center',halign:'center',sortable:true},
	    {field:'logTypeText',title:'日志类型',width:100,align:'center',halign:'center'},
	    {field:'logTime',title:'日志发生时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createAccountText',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
	    }
	});
	
    fmReceiveTotalApiLogGrid.datagrid('doCellTip');
    var pager = fmReceiveTotalApiLogGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('fmReceiveTotalApiLogGrid',menuName)
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function fmReceiveTotalApiLogFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=FmReceiveTotalApiLog&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadFmReceiveTotalApiLog(){
	fmReceiveTotalApiLogGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchFmReceiveTotalApiLog(){
	fmReceiveTotalApiLogGrid.datagrid('load',{

		logType : $("#logTypeQuery").combobox("getValue"),
		logTimeStart : $("#logTimeStartQuery").datebox("getValue"),
		logTimeEnd : $("#logTimeEndQuery").datebox("getValue")
	});
}


/**
 * 增加
 */
function addFmReceiveTotalApiLog() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=FmReceiveTotalApiLog",
		submiturl : "/fmReceiveTotalApiLog/saveFmReceiveTotalApiLog?formcode=FmReceiveTotalApiLog",
		callback : reloadFmReceiveTotalApiLog
	});
	
}


/**
 * 修改
 */
function editFmReceiveTotalApiLog() {

	var row = fmReceiveTotalApiLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=FmReceiveTotalApiLog&id=" + row.middleLogId,
		submiturl:"/fmReceiveTotalApiLog/saveFmReceiveTotalApiLog?formcode=FmReceiveTotalApiLog",
		callback : reloadFmReceiveTotalApiLog
	});
}


/**
 * 删除
 */
function delFmReceiveTotalApiLog() {

	var row = fmReceiveTotalApiLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/fmReceiveTotalApiLog/delFmReceiveTotalApiLog",
				data : {
					id : row.middleLogId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						fmReceiveTotalApiLogGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
