
var conInfoApiLogGrid = $("#conInfoApiLogGrid");
$(function(){
	initConInfoApiLogGrid();
});


/**
 * 初始化
 */
function initConInfoApiLogGrid(){
	conInfoApiLogGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#conInfoApiLogGridTbar",
	    url:ctx+'/conInfoApiLog/pageAll',
	    columns:[[
	    {field:'logMsg',title:'日志内容',width:100,align:'center',halign:'center',sortable:true},
	    {field:'logTypeText',title:'日志类型',width:100,align:'center',halign:'center'},
	    {field:'logTime',title:'日志发生时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createAccountText',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			// conInfoApiLogFormDetail(row.middleLogId);
	    }
	});
	
    conInfoApiLogGrid.datagrid('doCellTip');
    var pager = conInfoApiLogGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('conInfoApiLogGrid',menuName)
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function conInfoApiLogFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ConInfoApiLog&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadConInfoApiLog(){
	conInfoApiLogGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchConInfoApiLog(){
	conInfoApiLogGrid.datagrid('load',{

		logType : $("#logTypeQuery").combobox("getValue"),
		logTimeStart : $("#logTimeStartQuery").datebox("getValue"),
		logTimeEnd : $("#logTimeEndQuery").datebox("getValue")
	});
}


/**
 * 增加
 */
function addConInfoApiLog() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=ConInfoApiLog",
		submiturl : "/conInfoApiLog/saveConInfoApiLog?formcode=ConInfoApiLog",
		callback : reloadConInfoApiLog
	});
	
}


/**
 * 修改
 */
function editConInfoApiLog() {

	var row = conInfoApiLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ConInfoApiLog&id=" + row.middleLogId,
		submiturl:"/conInfoApiLog/saveConInfoApiLog?formcode=ConInfoApiLog",
		callback : reloadConInfoApiLog
	});
}


/**
 * 删除
 */
function delConInfoApiLog() {

	var row = conInfoApiLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/conInfoApiLog/delConInfoApiLog",
				data : {
					id : row.middleLogId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						conInfoApiLogGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
