var appvue = new Vue({
    el: '#app',
    data: {
        // 配置总数据
        // 增加功能是否启用
        add_is_on: false,
        // 禁用功能是否启用
        enable_is_on: false,
        // 删除功能是否启用
        delete_is_on: false,
        // configCode是否显示
        configCodeIsShow: false,
        // type: new=新建态,edit=编辑态,del=删除状态,enable=不可用状态

        // 添加配置显示
        addBasSystemConfigShow: true,
        // 编辑配置显示
        editBasSystemConfigShow: true,
        // 删除配置显示
        delBasSystemConfigShow: false,
        // 是否可用配置显示
        enableBasSystemConfigShow: false,
        // 保存配置显示
        saveBasSystemConfigShow: true,
        // 正在编辑
        editing: true,
        // SYSTEM_FLOW_TITLE 配置下拉框
        configContentArray: [],
        // 是否下拉框
        isOrNotArray : [],
        //字典值：is_or_not
        dicOptions:[],
        //
        //
        // group_name_sys:'系统配置',
        // group_name_query:'查询验证配置',


        activeIndex:'1',
        //menu列表
        menuList:[],
        configs: [],
        //系统配置数据
        configs_sys:[],
        //查询验证配置数据
        configs_query:[],
        isEditQuery:true,
        isQueryVerify:false, //启用查询验证
        //是否是密码验证方式
        isPassVerify:true,
        //流程配置数据
        configs_flow:[],
        configs_other:[],
        isEditFlow:true
    },
    mounted() {
        // this.init();
        this.$nextTick(function () {
            // 1、设置SYSTEM_FLOW_TITLE 配置下拉框
            this.getFlowTitleArray();
            // 2、初始化
            this.init();
        });
    },
    watch:{
        configs_query:{
            deep:true,
            immediate:false,
            handler(newValue,oldValue){
                this.dealQueryData();
            }
        }
    },
    methods: {
        //切换导航
        handleSelect(val){
            this.activeIndex = val;
        },
        //处理查询密码设置
        dealQueryData(){
            let isQueryVerify = this.configs_query.filter(x => x.configCode == 'QUERY_VERIFY')[0]['configContent'];
            this.isQueryVerify = isQueryVerify == 'N'?false:true;
            if(!this.isQueryVerify){//不启用，将其他参数置空
                let arr = this.configs_query.filter(config => config.configCode != "QUERY_VERIFY")
                arr.forEach(x=>{
                    x.configContent = "";
                })
            }
        },
        //变更密码验证
        changeVerifyMode(val){
            if(val == 1 || val == "" || val == 3){//密码验证
                this.isPassVerify = true;
            }else{
                let config = this.configs_query.filter(config => config.configCode == "QUERY_PASS_SPECIFY")[0];
                config.configContent = "";
                this.isPassVerify = false;
            }
        },
        // 设置SYSTEM_FLOW_TITLE 配置下拉框
        getFlowTitleArray() {
            this.configContentArray.push({
                value: "${flowName!}-${bizTitle!}",
                label: '[流程名称]-[业务标题]'
            });
            this.configContentArray.push({
                value: "${flowName!}-${bizTitle!}-${creatorName!}",
                label: '[流程名称]-[业务标题]-[流程发起人]'
            });
            this.configContentArray.push({
                value: "【${flowName!}】${bizTitle!}",
                label: '【[流程名称]】[业务标题]'
            });
            this.configContentArray.push({
                value: "【${flowName!}】${bizTitle!}-${creatorName!}",
                label: '【[流程名称]】[业务标题]-[流程发起人]'
            });

            this.configContentArray.push({
                value: "${flowName!}-${bizTitle!}-${orgAbbr!}-${deptAbbr!}-${creatorName!}",
                label: '[流程名称]-[业务标题]-[发起人单位简称]-[发起人部门简称]-[流程发起人]'
            });
            
            this.configContentArray.push({
                value: "${formName!}-${bizTitle!}",
                label: '[表单名称]-[业务标题]'
            });
            this.configContentArray.push({
                value: "${formName!}-${bizTitle!}-${creatorName!}",
                label: '[表单名称]-[业务标题]-[流程发起人]'
            });
            this.configContentArray.push({
                value: "【${formName!}】${bizTitle!}",
                label: '【[表单名称]】[业务标题]'
            });
            this.configContentArray.push({
                value: "【${formName!}】${bizTitle!}-${creatorName!}",
                label: '【[表单名称]】[业务标题]-[流程发起人]'
            });
            this.configContentArray.push({
                value: "${formName!}-${bizTitle!}-${orgAbbr!}-${deptAbbr!}-${creatorName!}",
                label: '[表单名称]-[业务标题]-[发起人单位简称]-[发起人部门简称]-[流程发起人]'
            });
            this.isOrNotArray.push({
                value : "Y",
                label: "是"
            });
            this.isOrNotArray.push({
                value : "N",
                label: "否"
            })
        },
        // 初始化
        init() {
            var _this = this;
            // 1、获取数据
            let data = [];
            let queryData = [];
            let flowConfigData = [];
            let otherData = [];
            var allConfigData = _this.getAllData();
            if(allConfigData){
                allConfigData.forEach(x=>{
                    if(x.configGroupName == "系统配置"){
                        data.push(x);
                    }else if(x.configGroupName == "查询验证配置"){
                        queryData.push(x);
                    }else if(x.configGroupName == "流程配置"){
                        flowConfigData.push(x);
                    }else{
                    	otherData.push(x)
                    }
                })
                console.log(flowConfigData);
            }
            // 1、初始化系统配置数据
            if (data) {
                _this.menuList.push({no:'1',name:'系统配置'});
                _this.configs = data;
                _this.configs_sys = [];
                // 3、遍历设置configType
                for (var i = 0; i < _this.configs.length; i++) {

                    // 配置编辑类型
                    if (_this.configs[i]['isEnable'] === 'N') {
                        _this.configs[i]['configType'] = 'enable';
                    } else if (_this.configs[i]['isUse'] === 'N') {
                        _this.configs[i]['configType'] = 'del';
                    } else if (_this.configs[i]['configType'] === 'new') {
                    } else {
                        _this.configs[i]['configType'] = '';
                    }
                    // 配置checkBox
                    _this.configs[i]['checked'] = false;
                    _this.configs[i]['selected'] = false;
                    //配置数据字典
                    if(_this.configs[i]['configDicCode'] !== "" && _this.configs[i]['configDicCode'] !== null){
                        let options = _this.getDicInfo(_this.configs[i]['configDicCode']);
                        _this.configs[i]['configOptions'] = options;
                    }
                }
                _this.configs_sys = _this.configs;
            }
            //2、初始化查询验证配置
            if (queryData) {
                _this.menuList.push({no:'2',name:'查询验证配置'});
                _this.configs_query = queryData;
                for (var i = 0; i < _this.configs_query.length; i++) {
                    //配置数据字典
                    if(_this.configs_query[i]['configDicCode'] !== "" && _this.configs_query[i]['configDicCode'] !== null){
                        let options = _this.getDicInfo(_this.configs_query[i]['configDicCode']);
                        _this.configs_query[i]['configOptions'] = options;
                    }
                }
            }
            //3、初始化流程配置
            if(flowConfigData){
                _this.menuList.push({no:'3',name:'流程配置'});
                _this.configs_flow = flowConfigData;
                for (var i = 0; i < _this.configs_flow.length; i++) {
                    //配置数据字典
                    if(_this.configs_flow[i]['configDicCode'] !== "" && _this.configs_flow[i]['configDicCode'] !== null){
                        let options = _this.getDicInfo(_this.configs_flow[i]['configDicCode']);
                        _this.configs_flow[i]['configOptions'] = options;
                    }
                }

            }
            //4、其他配置
            if(otherData){
                _this.menuList.push({no:'4',name:'其他配置'});
                _this.configs_other = otherData;
                for (var i = 0; i < _this.configs_other.length; i++) {
                    //配置数据字典
                    if(_this.configs_other[i]['configDicCode'] !== "" && _this.configs_other[i]['configDicCode'] !== null){
                        let options = _this.getDicInfo(_this.configs_flow[i]['configDicCode']);
                        _this.configs_other[i]['configOptions'] = options;
                    }
                }

            }

        },
        //获取数据字典
        getDicInfo(dicCode){
            let dicList = [];
            $.ajax({
                url: ctx + "/basSystemConfig/getDicInfo",
                data: {dicCode:dicCode},
                dataType: 'json',
                type: "post",
                // 是否异步
                async: false,
                success: function (result) {
                    dicList = result.msg;
                },
                error: function () {
                    alertError('获取数据字典失败');
                }
            });
            return dicList;
        },
        setSelectStatus(config) {
            if (!this.editing) {
                return;
            }
            config.selected = !config.selected;
            config.checked = config.selected;
        },
        getAllData(){
            var method_result = null;
            $.ajax({
                url: ctx + "/basSystemConfig/getAllData",
                data: {},
                dataType: 'json',
                type: "post",
                // 是否异步
                async: false,
                success: function (result) {
                    method_result = result;
                },
            });
            return method_result;
        },

        // add config
        addBasSystemConfig() {
            var _this = this;
            var config = {
                configName: '',
                configContent: '',
                configCode: '',
                configType: 'new',
                isUse: 'Y',
                isEnable: 'Y',
                checked: false,
                selected: false,
            }
            _this.configs_sys.push(config);
        },
        // edit config
        editBasSystemConfig() {
            // 开启编辑状态
            this.editing = !this.editing;
            let that = this;
            // 遍历configs，设置可编辑状态
            for (let i = 0; i < that.configs_sys.length; i++) {
                if (that.configs_sys[i]['configType'] !== 'new') {
                    that.configs_sys[i]['configType'] = 'edit';
                }
            }
            this.enableBasSystemConfigShow = true;
            this.delBasSystemConfigShow = true;
        },
        //编辑密码查询验证配置
        editBasSystemConfigQuery(){
            // 开启编辑状态
            this.isEditQuery = !this.isEditQuery;
        },
        //编辑流程配置
        editBasSystemConfigFlow(){
            // 开启编辑状态
            this.isEditFlow = !this.isEditFlow;
        },
        // del config
        delBasSystemConfig() {
            // 遍历所有选择的行
            for (let i = 0; i < this.configs.length; i++) {
                // 如果选中设置为相反的值
                if (this.configs_sys[i]['checked']) {
                    this.configs_sys[i]['isUse'] = (this.configs[i]['isUse'] === 'Y' ? 'N' : 'Y');
                }
            }
        },
        // enable config
        enableBasSystemConfig() {
            // 遍历所有选择的行
            for (let i = 0; i < this.configs.length; i++) {
                // 如果选中设置为相反的值
                if (this.configs_sys[i]['checked']) {
                    this.configs_sys[i]['isEnable'] = (this.configs[i]['isEnable'] === 'Y' ? 'N' : 'Y');
                }
            }
        },
        // save
        saveBasSystemConfigQuery(){
            let configs = [];
            if(this.activeIndex == '1'){
                configs = JSON.stringify(this.configs_sys);
            }
            if(this.activeIndex == '2'){//查询验证配置
                if(this.isEditQuery){
                    return false;
                }
                let queryVerify = this.configs_query.filter(x=>x.configCode == "QUERY_VERIFY")[0];
                let verifyMode = this.configs_query.filter(x=>x.configCode == "VERIFY_MODE")[0];
                let queryPassSpecify = this.configs_query.filter(x=>x.configCode == "QUERY_PASS_SPECIFY")[0];
                let continuousQueryVerify = this.configs_query.filter(x=>x.configCode == "CONTINUOUS_QUERY_VERIFY")[0];
                if(queryVerify.configContent == 'Y' || queryVerify.configContent == '' || !queryVerify.configContent){
                    if(!verifyMode.configContent || verifyMode.configContent == ''){
                        alertWarn("请选择一种验证方式！")
                        return false;
                    }
                }
                configs = JSON.stringify(this.configs_query);
            }
            if(this.activeIndex == '3'){//流程配置
                if(this.isEditFlow){
                    return false;
                }
                configs = JSON.stringify(this.configs_flow);
            }
            if(this.activeIndex == '4'){//其他
                if(this.isEditFlow){
                    return false;
                }
                configs = JSON.stringify(this.configs_other);
            }
            var _this = this;
            $.ajax({
                url: ctx + "/basSystemConfig/saveQueryVerifyDataByJsonStr",
                data: {
                    configs: configs,
                },
                dataType: 'json',
                type: "post",
                // 是否异步
                async: false,
                success: function (result) {
                    if (result.success) {
                        alertInfo('保存成功');
                        if(_this.activeIndex == '1'){
                            _this.editing = !_this.editing;
                        }else if(_this.activeIndex == '2'){
                            _this.isEditQuery = !_this.isEditQuery;
                        }else {
                            _this.isEditFlow = !_this.isEditFlow;
                        }
                    }
                },
                error: function () {
                    alertError('保存失败');
                }
            });
        }
    }
});