
var basProcessForwardingGrid = $("#basProcessForwardingGrid");
$(function(){
	initBasProcessForwardingGrid();
});


/**
 * 初始化
 */
function initBasProcessForwardingGrid(){
	basProcessForwardingGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basProcessForwardingGridTbar",
	    url:ctx+'/basProcessForwarding/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basProcessForwardingFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basProcessForwardingFormDetail(row.id);
	    }
	});
	
    basProcessForwardingGrid.datagrid('doCellTip');
    var pager = basProcessForwardingGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basProcessForwardingGrid',"流程转发表")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basProcessForwardingFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasProcessForwarding&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasProcessForwarding(){
	basProcessForwardingGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasProcessForwarding(){
	basProcessForwardingGrid.datagrid('load',{

	});
}


/**
 * 增加
 */
function addBasProcessForwarding() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasProcessForwarding",
		submiturl : "/basProcessForwarding/saveBasProcessForwarding?formcode=BasProcessForwarding",
		callback : reloadBasProcessForwarding
	});
	
}


/**
 * 修改
 */
function editBasProcessForwarding() {

	var row = basProcessForwardingGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasProcessForwarding&id=" + row.id,
		submiturl:"/basProcessForwarding/saveBasProcessForwarding?formcode=BasProcessForwarding",
		callback : reloadBasProcessForwarding
	});
}


/**
 * 删除
 */
function delBasProcessForwarding() {

	var row = basProcessForwardingGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basProcessForwarding/delBasProcessForwarding",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basProcessForwardingGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
