var basetree = $('#basModelManageTree');
var baseform = $('#basModelManageForm');
var menutree = $('#basModelManageMenu');

$(function() {
	initTree();
	// 初始化表单显示
	changeShow();
});

function changeShow(dataType) {
    $('.editForm tr').hide();
    
    if(dataType == null 
            || dataType == "" 
            || dataType == "workspace" 
            || dataType == "theme") {
        // 页面初始化状态、空间、业务主题
        $('.show_colum').show();
        
        $("#modelCodeEdit").textbox({
            required: true,
            buttonText: null
        });
        
    } else if(dataType == "mainTable" || dataType == "sublistTable") {
        // 主表、子表
        $('.show_colum').show();
        $('.table_pk').show();
        
        $("#modelCodeEdit").textbox({
            required: true,
            buttonText: "选择",
            onClickButton: chooseTableModel
        });
        
    } else if(dataType == "tableRelationship") {
        // 表关系
        $('.show_colum').show();
        $('.relation_ship').show();
        
        $("#modelCodeEdit").textbox({
            required: false,
            buttonText: null
        });
    } else if(dataType == "dataColumn" || dataType == "computedColumn") {
        // 数据列、计算列
        $('.show_colum').show();
        $('.data_column').show();
        if(dataType == "computedColumn") {
            $('.condition').show();
        }
        
        if(dataType == "dataColumn") {
            $("#modelCodeEdit").textbox({
                required: true,
                buttonText: "选择",
                onClickButton: showSelectColumns
            });
        } else {
            $("#modelCodeEdit").textbox({
                required: true,
                buttonText: null
            });
        }
    } else if(dataType == "condition") {
        // 表达式
        $('.show_colum').show();
        $('.condition').show();
        
        $("#modelCodeEdit").textbox({
            required: false,
            buttonText: null
        });
    }
    
    $.parser.parse("#basModelManageForm");
}

//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/basModelManage/treeBasModelManageWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onContextMenu: function (e, node) {
		    e.preventDefault();
		    var selectnode = basetree.tree('getSelected');
            if(selectnode != node){
                basetree.tree('select', node.target);
                selectnode = node;
            }
            
            // 根据不同的情况加载右键菜单
            menutree.empty();
            
            var modelType = selectnode.attributes.modeltype;
            
            if(selectnode.id === "0") {
                //根节点
                menutree.menu('appendItem', {
                    text: '新增命名空间',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "workspace", "新增命名空间", 400, 300);
                    }
                });
            } else if(modelType == "workspace") {
                // 命名空间
                menutree.menu('appendItem', {
                    text: '新增命名空间',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "workspace", "新增命名空间", 400, 300);
                    }
                });
                
                menutree.menu('appendItem', {
                    text: '新增业务主题',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "theme", "新增主题", 400, 350);
                    }
                });
            } else if(modelType == "theme") {
                // 主题
                menutree.menu('appendItem', {
                    text: '新增主表',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "mainTable", "新增主表", 400, 400);
                    }
                });
                
                menutree.menu('appendItem', {
                    text: '新增子表',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "sublistTable", "新增子表", 400, 400);
                    }
                });
                
                menutree.menu('appendItem', {
                    text: '新增表关系',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "tableRelationship", "新增表关系", 400, 440);
                    }
                });
                
            } else if(modelType == "sublistTable" || modelType == "mainTable") {
                //主表和子表下
                menutree.menu('appendItem', {
                    text: '新增数据列',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "dataColumn", "新增数据列", 700, 300);
                    }
                });
                
                menutree.menu('appendItem', {
                    text: '新增计算列',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "computedColumn", "新增计算列", 700, 450);
                    }
                });
                
                menutree.menu('appendItem', {
                    text: '新增条件',
                    iconCls : 'icon-new',
                    onclick: function(){
                        addBasModelManageTree(selectnode, "condition", "新增条件", 400, 450);
                    }
                });
            }
            
            if(selectnode.id !== "0") {
                menutree.menu('appendItem', {
                    text: '删除节点',
                    iconCls : 'icon-layout_delete',
                    onclick: function(){
                        delBasModelManageTree(selectnode);
                    }
                });
            }
            
            menutree.menu('show', {
                left : e.pageX,
                top : e.pageY
            });
		},
		onLoadSuccess : function(node, data) {
		    var root = $(this).tree('getRoot');
		    if(node){
                $(this).tree('select', node.target);
            }else{
                $(this).tree('collapseAll');
                $(this).tree('expand',root.target);
                $(this).tree('select', root.target);
            }
		}
	});
}

// 控制按钮可用状态
function controlBtn(isable){
    if(isable){
        $('#saveBtn').linkbutton('enable');
    }else{
        $('#saveBtn').linkbutton('disable');
    }
}

// 选择节点
function openNode(node) {
    var modelType = node.attributes.modeltype;
    changeShow(modelType);
    
    if(node.id === "0") {
        baseform.form('clear');
        controlBtn(false);
    } else {
        controlBtn(true);
        $("#modelPid").combotree("reload");
        baseform.form('load', ctx + "/basModelManage/findBasModelManage?id=" + node.id);
    }
}

//添加节点信息
function addBasModelManageTree(node, modelType, title, width, height) {
    openSaveDialog({
        title : title,
        height : height,
        width : width,
        contenturl: "/view/base/basModelManage_" + modelType,
        submiturl: '/basModelManage/saveBasModelManage',
        onload : function(){
            $('#bfm_form #modelPid').combotree('setValue', node.id);
            $('#bfm_form #modelType').combobox('setValue', modelType);
        },
        callback: resetBasModelManageTree
    });
}

//删除节点信息
function delBasModelManageTree(node) {
    if(node.id === "0") {
        alertWarn('根节点不可删除!');
        return;
    }
    
    alertConfirm('确定删除该节点及下级所有节点?', function(r) {
        if (r) {
            $.ajax({
                type : 'post',
                dataType : 'json',
                url : ctx + "/basModelManage/delBasModelManage",
                data : {
                   id : node.id
                },
                success : function(result) {
                    if (result.success) {
                        var pnode = basetree.tree('getParent',node.target);
                        if(pnode){
                            basetree.tree('select', pnode.target);
                        }
                        basetree.tree('remove', node.target);
                        alertInfo(result.msg);
                    }else {
                        alertError(result.msg);
                    }
                },error:function(){
                    alertError("删除失败!");
                }
            });
        }
    });
}

//更新节点信息
function resetBasModelManageTree(result) {
    var selectnode = basetree.tree('getSelected');
    if (result.success) {
        // 获取选中的节点
        var resultnode = basetree.tree('find', result.o.modelId);
        if (resultnode) {
            basetree.tree('update', {
                target : selectnode.target,
                text : result.o.modelName
            });
        } else {
            basetree.tree('append', {
                parent : selectnode.target,
                data : [{
                    id : result.o.modelId,
                    text : result.o.modelName,
                    attributes: {
                        modeltype: result.o.modelType
                    }
                }]
            });
        }
        alertInfo(result.msg);
        
        var newnode = basetree.tree('find', result.o.modelId);            
        basetree.tree('select', newnode.target);
        
    } else {
        alertError(result.msg);
    }
}

// 保存数据源信息
function saveBasModelManage() {
    var selectnode = basetree.tree('getSelected');
    if (selectnode) {
        baseform.form('submit', {
            url : ctx + "/basModelManage/saveBasModelManage",
            onSubmit : function() {
                if ($(this).form('validate')) {
                    $('#saveBtn').linkbutton('disable');
                    return true;
                } else {
                    return false;
                }
            },
            success : function(result) {
                result = jQuery.parseJSON(result);
                if (result.success) {
                    // 获取选中的节点
                    var resultnode = basetree.tree('find', result.o.modelId);
                    if (resultnode) {
                        basetree.tree('update', {
                            target : selectnode.target,
                            text : result.o.modelName
                        });
                    } else {
                        basetree.tree('append', {
                            parent : selectnode.target,
                            data : [{
                                id:result.o.modelId,
                                text:result.o.modelName,
                                attributes: {
                                    modeltype: result.o.modelType
                                }
                            }]
                        });
                    }
                    alertInfo(result.msg);
                    
                    var newnode = basetree.tree('find',result.o.modelId);
                    basetree.tree('select', newnode.target);
                    
                    $('#saveBtn').linkbutton('enable');
                } else {
                    alertError(result.msg);
                    $('#saveBtn').linkbutton('enable');
                }
            }
        });
    } else {
        alertWarn('请选择一个节点');
    }
}

// 重置操作
function resetBasModelManage() {
    var node = basetree.tree('getSelected');
    openNode(node);
}

function chooseTableModel() {
    var modelType = "";
    
    if(haseasyui('#modelType')) {
        modelType = $('#modelType').combobox('getValue');
    } else if(haseasyui('#modelTypeEdit')) {
        modelType = $('#modelTypeEdit').combobox('getValue');
    }
    
    if(modelType == 'mainTable' || modelType == 'sublistTable') {
        // 主表、子表
        openChooseDialog({
            title: '选择数据库表',
            contenturl: '/gen/alltable',
            width: 400,
            height: 500,
            okhandler: function () {
                var row = $("#alltable").datagrid('getSelected');
                if (row) {
                    if(haseasyui('#modelCode')) {
                        $('#modelCode').textbox('setValue', row.code);
                    }
                    if(haseasyui('#modelCodeEdit')) {
                        $('#modelCodeEdit').textbox('setValue', row.code);
                    }
                    if(haseasyui('#modelNameEdit')) {
                        $('#modelNameEdit').textbox('setValue', row.name);
                    }
                    if(haseasyui('#modelName')) {
                        $('#modelName').textbox('setValue', row.name);
                    }
                    
                    $.ajax({
                        type : 'post',
                        dataType : 'json',
                        url : ctx + "/gen/getPk",
                        data : {
                           tableName : row.code
                        },
                        success : function(result) {
                            if (result.success) {
                                if(haseasyui('#primaryKey')) {
                                    $('#primaryKey').textbox('setValue', result.o);
                                }
                                if(haseasyui('#primaryKeyEdit')) {
                                    $('#primaryKeyEdit').textbox('setValue', result.o);
                                }
                            }
                        },error:function(){
                            alertError("获取主键失败!");
                        }
                    });
                    
                    return true;
                } else {
                    alertInfo("请选择表名!");
                    return false;
                }
            }
        });
        
    } else {
        
    }
}

// 选择表数据字段
function showSelectColumns() {
    var modelPid = "";
    if(haseasyui('#modelPid')) {
        modelPid = $('#modelPid').combotree('getValue');
    } else if(haseasyui('#modelPidEdit')) {
        modelPid = $('#modelPidEdit').combotree('getValue');
    }
    
    openChooseDialog({
        title: "选择列信息",
        contenturl: '/view/base/basModelManage_selectColumns?modelPid=' + modelPid,
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#selectColumns_datagrid').datagrid('getSelected');
            if (r) {
                if(haseasyui('#modelCode')) {
                    $('#modelCode').textbox('setValue', r.columnName);
                }
                if(haseasyui('#modelCodeEdit')) {
                    $('#modelCodeEdit').textbox('setValue', r.columnName);
                }
                if(haseasyui('#modelName')) {
                    $('#modelName').textbox('setValue', r.comments);
                }
                if(haseasyui('#modelNameEdit')) {
                    $('#modelNameEdit').textbox('setValue', r.comments);
                }
                if(haseasyui('#dataType')) {
                    $('#dataType').combobox('setValue', r.dataType);
                }
                if(haseasyui('#dataTypeEdit')) {
                    $('#dataTypeEdit').combobox('setValue', r.dataType);
                }
                if($("#dataLength").length > 0 && r.datalength != null) {
                    $("#dataLength").val(r.datalength);
                }
                if($("#dataLengthEdit").length > 0 && r.datalength != null) {
                    $("#dataLengthEdit").val(r.datalength);
                }
                if($("#decPlace").length > 0 && r.decplace != null) {
                    $("#decPlace").val(r.decplace);
                }
                if($("#decPlaceEdit").length > 0 && r.decplace != null) {
                    $("#decPlaceEdit").val(r.decplace);
                }
                return true;
            } else {
                alertWarn("请选择相应列！");
                return false;
            }
        }
    })
}

function selDataCat(newVal, oldVal) {
    if(newVal == "01") {
        if(haseasyui('#ddCode')) {
            $("#ddCode").combobox("readonly", false);
        }
        if(haseasyui('#ddCodeEdit')) {
            $("#ddCodeEdit").combobox("readonly", false);
        }
    } else {
        if(haseasyui('#ddCode')) {
            $("#ddCode").combobox("setValue", "");
            $("#ddCode").combobox("readonly", true);
        } 
        if(haseasyui('#ddCodeEdit')) {
            $("#ddCodeEdit").combobox("setValue", "");
            $("#ddCodeEdit").combobox("readonly", true);
        }
    }
}