
var basMessageCollapseGrid = $("#basMessageCollapseGrid");
$(function(){
	initBasMessageCollapseGrid();
	bindEnterKey("#fuzzy",searchBasMessageCollapse);
});


/**
 * 初始化
 */
function initBasMessageCollapseGrid(){
	basMessageCollapseGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		sortName:'orderNum',
		sortOrder:'asc',
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basMessageCollapseGridTbar",
	    url:ctx+'/basMessageCollapse/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basMessageCollapseFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',hidden:true},
	    {field:'collapseName',title:'折叠名称',width:100,align:'center',halign:'center',sortable:false},
	    // {field:'flowCode',title:'折叠流程',width:100,align:'center',halign:'center',sortable:false},
		{field:'flowName',title:'折叠流程',width:100,align:'center',halign:'center',sortable:false},
	    // {field:'actId',title:'折叠节点',width:100,align:'center',halign:'center',sortable:false},
		{field:'actName',title:'折叠节点',width:80,align:'center',halign:'center',sortable:false},
	    {field:'linkUrl',title:'跳转路径',width:340,align:'center',halign:'center',sortable:false},
	    {field:'isCommonText',title:'是否公共',width:40,align:'center',halign:'center'},
	    // {field:'effectScope',title:'生效范围',width:100,align:'center',halign:'center',sortable:true},
	    {field:'orderNum',title:'排序',width:40,align:'center',halign:'center',sortable:true,order:'asc'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basMessageCollapseFormDetail(row.id);
	    }
	});
	
    basMessageCollapseGrid.datagrid('doCellTip');
    var pager = basMessageCollapseGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basMessageCollapseGrid',"流程待办折叠表")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basMessageCollapseFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasMessageCollapse&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasMessageCollapse(){
	basMessageCollapseGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasMessageCollapse(){
	basMessageCollapseGrid.datagrid('load',{
		fuzzy : $("#fuzzy").textbox("getValue")
	});
}


/**
 * 增加
 */
function addBasMessageCollapse() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasMessageCollapse",
		submiturl : "/basMessageCollapse/saveBasMessageCollapse?formcode=BasMessageCollapse",
		callback : reloadBasMessageCollapse
	});
	
}


/**
 * 修改
 */
function editBasMessageCollapse() {

	var row = basMessageCollapseGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasMessageCollapse&id=" + row.id,
		submiturl:"/basMessageCollapse/saveBasMessageCollapse?formcode=BasMessageCollapse",
		callback : reloadBasMessageCollapse
	});
}

/**
 * 流程弹框获取单个流程
 */
function chooseSingleFlow(){
	openChooseDialog({
		title:'选择流程',
		contenturl:'/GenForm/allflow',
		width:400,
		height:500,
		okhandler:function(){
			var row=$("#allflow").datagrid('getSelected');
			if(row){
				$("#flowCode").textbox("setValue",row.value);
				$("#flowCode").textbox("setText",row.text);
				return true;
			}else{
				alertWarn("请选择流程");
				return false;
			}
		},
	});
}

function changeFlow(flowCode){
	$.ajax({
		type : 'request',
		dataType : 'json',
		url : ctx +"/basMessageCollapse/getFlowActByFlowCode?flowCode="+flowCode,
		success: function (result){
			$("#actId").combobox('loadData',result);
		}
	});
}

/**
 * 删除
 */
function delBasMessageCollapse() {

	var row = basMessageCollapseGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basMessageCollapse/delBasMessageCollapse",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basMessageCollapseGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
