
var basHolidayBackgroudGrid = $("#basHolidayBackgroudGrid");
$(function(){
	initBasHolidayBackgroudGrid();
	bindEnterKey("#search",searchBasHolidayBackgroud);
});


/**
 * 初始化
 */
function initBasHolidayBackgroudGrid(){
	basHolidayBackgroudGrid.datagrid({
		height : ($("body").height() - 180),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basHolidayBackgroudGridTbar",
	    url:ctx+'/basHolidayBackgroud/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basHolidayBackgroudFormDetail('+row.backgroudId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'holidayName',title:'节庆日名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'holidayDate',title:'节庆日日期',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isHolidayText',title:'是否为自定义节日',width:100,align:'center',halign:'center'},
	    {field:'advanceDays',title:'提前天数',width:100,align:'center',halign:'center',sortable:true},
	    {field:'delayDays',title:'延迟天数',width:100,align:'center',halign:'center',sortable:true},
	    {field:'levleNo',title:'展示优先级',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isEnableText',title:'是否启用',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basHolidayBackgroudFormDetail(row.backgroudId);
	    }
	});
	
    basHolidayBackgroudGrid.datagrid('doCellTip');
    var pager = basHolidayBackgroudGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basHolidayBackgroudGrid',"节庆日背景维护")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basHolidayBackgroudFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasHolidayBackgroud&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasHolidayBackgroud(){
	basHolidayBackgroudGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasHolidayBackgroud(){
	basHolidayBackgroudGrid.datagrid('load',{
		fuzzy : $("#search").textbox("getValue")
	});
}


/**
 * 增加
 */
function addBasHolidayBackgroud() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasHolidayBackgroud",
		submiturl : "/basHolidayBackgroud/saveBasHolidayBackgroud?formcode=BasHolidayBackgroud",
		onload:isHolidayChange,
		callback : reloadBasHolidayBackgroud
	});
	
}


/**
 * 修改
 */
function editBasHolidayBackgroud() {

	var row = basHolidayBackgroudGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasHolidayBackgroud&id=" + row.backgroudId,
		submiturl:"/basHolidayBackgroud/saveBasHolidayBackgroud?formcode=BasHolidayBackgroud",
		callback : reloadBasHolidayBackgroud
	});
}


/**
 * 删除
 */
function delBasHolidayBackgroud() {

	var row = basHolidayBackgroudGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}
	if(row.isEnable == 'Y'){
		alertWarn('启用状态下不可删除!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basHolidayBackgroud/delBasHolidayBackgroud",
				data : {
					id : row.backgroudId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basHolidayBackgroudGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}


//仅用作测试生成任务
// function testBasHolidayBackgroud(){
// 		$.ajax({
// 		url: ctx + "/basHolidayBackgroud/testBasHolidayBackgroud",
// 		data: {
//
// 		},
// 		dataType: 'json',
// 		success: function(result) {
//
// 		}
// 	});
// }


