
var basFlowPrintGrid = $("#basFlowPrintGrid");
$(function(){
	initBasFlowPrintGrid();
	bindEnterKey('#searchBasFlowPrint',searchBasFlowPrint);
});


/**
 * 初始化
 */
function initBasFlowPrintGrid(){
	basFlowPrintGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basFlowPrintGridTbar",
	    url:ctx+'/basFlowPrint/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basFlowPrintFormDetail('+row.printId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'flowNo',title:'流程编号',width:100,align:'center',halign:'center',sortable:true},
	    {field:'flowName',title:'流程名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'applyOrgsName',title:'适用单位',width:100,align:'left',halign:'center',sortable:true},
	    {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basFlowPrintFormDetail(row.printId);
	    }
	});
	
    basFlowPrintGrid.datagrid('doCellTip');
    var pager = basFlowPrintGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basFlowPrintGrid',"流程打印节点维护")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basFlowPrintFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasFlowPrint&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasFlowPrint(){
	basFlowPrintGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasFlowPrint(){
	basFlowPrintGrid.datagrid('load',{
		search: $("#searchBasFlowPrint").textbox("getValue"),

		createTimeStart : $("#createTimeStartQuery").datebox("getValue"),
		createTimeEnd : $("#createTimeEndQuery").datebox("getValue")
	});
}


/**
 * 增加
 */
function addBasFlowPrint() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasFlowPrint&isdetail=false",
		submiturl : "/basFlowPrint/saveBasFlowPrint?formcode=BasFlowPrint",
		onload:function (){
			isEnableChange();
			if (!$("#BasFlowPrint").hasClass("detail")){
				var flowNo = $("#flowNo").val();
				if (flowNo) {
					$("#firstAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#secondAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#thirdAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#fourthAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#fifthAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
				}
			}
		},
		callback : reloadBasFlowPrint
	});
	
}


/**
 * 修改
 */
function editBasFlowPrint() {

	var row = basFlowPrintGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasFlowPrint&id=" + row.printId + "&isdetail=false",
		submiturl:"/basFlowPrint/saveBasFlowPrint?formcode=BasFlowPrint",
		onload:function (){
			var isEnable = $("#isEnable").val();
			if (isEnable == 'Y') {
				setCss($("#formCode"),'textbox',true,false,true,false,false);
			}else {
				setCss($("#formCode"),'textbox',false,true,false,true,false);
			}
			if (!$("#BasFlowPrint").hasClass("detail")){
				var flowNo = $("#flowNo").val();
				if (flowNo) {
					$("#firstAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#secondAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#thirdAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#fourthAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
					$("#fifthAct").combobox('reload', ctx + '/basFlowPrint/findActListByFlowName?flowName=' + flowNo);
				}
			}
		},
		callback : reloadBasFlowPrint
	});
}


/**
 * 删除
 */
function delBasFlowPrint() {

	var row = basFlowPrintGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basFlowPrint/delBasFlowPrint",
				data : {
					id : row.printId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basFlowPrintGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
