
var basFlowActPrintGrid = $("#basFlowActPrintGrid");
$(function(){
	initBasFlowActPrintGrid();
	bindEnterKey('#searchBasFlowActPrint',searchBasFlowActPrint);
	copyValue();
});


/**
 * 初始化
 */
function initBasFlowActPrintGrid(){
	basFlowActPrintGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basFlowActPrintGridTbar",
	    url:ctx+'/basFlowActPrint/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basFlowActPrintFormDetail('+row.printId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'printId',hidden:true},
	    {field:'designFlowName',title:'流程名称',width:100,align:'center',halign:'center',sortable:true},
		{field:'processChName',title:'流程标题',width:100,align:'center',halign:'center',sortable:true},
		{field:'versionSign',title:'流程版本',width:100,align:'center',halign:'center',sortable:true},
	    {field:'processdefid',title:'流程定义ID',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'busiId',title:'流程分类id',width:100,align:'center',halign:'center',sortable:true},
	    {field:'printTitle',title:'打印标题',width:100,align:'center',halign:'center',sortable:true},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basFlowActPrintFormDetail(row.printId);
	    }
	});
	
    basFlowActPrintGrid.datagrid('doCellTip');
    var pager = basFlowActPrintGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basFlowActPrintGrid',"流程打印节点")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basFlowActPrintFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasFlowActPrint&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasFlowActPrint(){
	basFlowActPrintGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasFlowActPrint(){
	basFlowActPrintGrid.datagrid('load',{
		search: $("#searchBasFlowActPrint").textbox("getValue"),

	});
}


/**
 * 增加
 */
function addBasFlowActPrint() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?isdetail=false&formcode=BasFlowActPrint",
		submiturl : "/basFlowActPrint/saveBasFlowActPrint?formcode=BasFlowActPrint",
		onsubmit:function (param){
			param.detailList = getBasFlowActPrintDetailData();
			return true;
		},
		callback : reloadBasFlowActPrint
	});
	
}


/**
 * 修改
 */
function editBasFlowActPrint() {

	var row = basFlowActPrintGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasFlowActPrint&isdetail=false&id=" + row.printId,
		submiturl:"/basFlowActPrint/saveBasFlowActPrint?formcode=BasFlowActPrint",
		onsubmit:function (param){
			param.detailList = getBasFlowActPrintDetailData();
			return true;
		},
		callback : reloadBasFlowActPrint
	});
}


/**
 * 删除
 */
function delBasFlowActPrint() {

	var row = basFlowActPrintGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basFlowActPrint/delBasFlowActPrint",
				data : {
					id : row.printId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basFlowActPrintGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}

function getCopyValue(){
	$("#copy1").select();
	try {
		var state = document.execCommand("copy");
	} catch(err){
		var state = false;
	}
	state ? alertInfo("复制成功") : alertError("复制失败");
}