/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.workflow.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.workflow.entity.WfConfirmPersons;
import com.guochuang.imp.workflow.entity.WfConfirmPersonsDetil;
import com.guochuang.imp.workflow.service.WfConfirmPersonsDetilService;
import com.guochuang.imp.workflow.service.WfConfirmPersonsService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wfConfirmPersons"})
public class WfConfirmPersonsController
extends BaseController {
    @Autowired
    private WfConfirmPersonsService wfConfirmPersonsService;
    @Autowired
    private WfConfirmPersonsDetilService wfConfirmPersonsDetilService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(String groupName, String affirmWay, int page, int rows, String sort, String order) {
        return this.wfConfirmPersonsService.pageAll(groupName, affirmWay, page, rows, sort, order);
    }

    @PostMapping(value={"/saveWfConfirmPersons"})
    @ResponseBody
    public JsonMsg saveWfConfirmPersons(HttpServletRequest request, WfConfirmPersons entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getConfirmId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        entity.setOrgId(this.getLoginUser(request).getOrgid());
        this.wfConfirmPersonsService.saveWfConfirmPersons(entity);
        this.wfConfirmPersonsDetilService.deleteByConfirmId(entity.getConfirmId());
        if (StringUtils.isNotBlank((CharSequence)entity.getUserId()) && !":".equals(entity.getUserId())) {
            for (String id : entity.getUserId().split(",")) {
                String[] idArray = id.split(":");
                WfConfirmPersonsDetil wfConfirmPersonsDetil = new WfConfirmPersonsDetil();
                wfConfirmPersonsDetil.setConfirmId(entity.getConfirmId());
                wfConfirmPersonsDetil.setUserType(idArray[0]);
                wfConfirmPersonsDetil.setUserId(Long.parseLong(idArray[1]));
                wfConfirmPersonsDetil.setModifyAccount(this.getLoginUser(request).getAccountid());
                wfConfirmPersonsDetil.setModifyTime(new Date());
                wfConfirmPersonsDetil.setIsUse("Y");
                if (wfConfirmPersonsDetil.getConfirmDetilId() == null) {
                    wfConfirmPersonsDetil.setCreateAccount(this.getLoginUser(request).getAccountid());
                    wfConfirmPersonsDetil.setCreateTime(new Date());
                }
                this.wfConfirmPersonsDetilService.saveWfConfirmPersonsDetil(wfConfirmPersonsDetil);
            }
        }
        msg.setO(entity);
        return msg;
    }

    @PostMapping(value={"/findWfConfirmPersons"})
    @ResponseBody
    public WfConfirmPersons findWfConfirmPersons(Long id) {
        WfConfirmPersons entity = this.wfConfirmPersonsService.findWfConfirmPersons(id);
        return entity;
    }

    @PostMapping(value={"/delWfConfirmPersons"})
    @ResponseBody
    public JsonMsg delWfConfirmPersons(Long id) {
        this.wfConfirmPersonsService.delWfConfirmPersons(id);
        this.wfConfirmPersonsDetilService.deleteByConfirmId(id);
        return new JsonMsg();
    }

    @PostMapping(value={"/findAffirmWayByAccountId"})
    @ResponseBody
    public Object findAffirmWayByAccountId(Long accountId, Long businessProcessId) {
        return this.wfConfirmPersonsService.findAffirmWayByAccountId(accountId, businessProcessId);
    }
}

