/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.report.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.report.entity.ReportBase;
import com.guochuang.imp.report.entity.ReportBean;
import com.guochuang.imp.report.service.ReportBaseService;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/ReportBase"})
public class ReportBaseController
extends BaseController {
    @Autowired
    private ReportBaseService reportbaseService;
    @Autowired
    private CommonService commonService;

    @RequestMapping(value={"/pageReportBase"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageReportBase(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.reportbaseService.PageAll(search, page, rows, sort, order);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryReport(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, Long id) {
        return this.reportbaseService.queryReport(search, page, rows, sort, order, id, this.getLoginUser(request), request);
    }

    @RequestMapping(value={"/findReportBase"})
    @ResponseBody
    public Object findReportBase(Long id) {
        ReportBase entity = this.reportbaseService.findReportBase(id);
        return entity;
    }

    @RequestMapping(value={"/genReport"})
    public Object genReport(String reportCode, Model model, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="showTitle", defaultValue="true") Boolean showTitle) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        ReportBean entity = this.reportbaseService.genReport(reportCode, this.getLoginUser(request), request);
        entity.getSearchColumns().stream().forEach(sm -> {
            if (StringUtils.isNotBlank((CharSequence)sm.getDicCode()) && ("tags".equals(sm.getColumnType()) || "radio".equals(sm.getColumnType()) || "radiogroup".equals(sm.getColumnType()))) {
                sm.setDicMap(this.commonService.getDicMap(sm.getDicCode()));
            }
        });
        model.addAttribute("bean", (Object)entity);
        model.addAttribute("loginuser", (Object)this.getLoginUser(request));
        Enumeration enu = request.getParameterNames();
        HashMap<String, String> maps = new HashMap<String, String>();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            String parameter = request.getParameter(paraName);
            if (parameter.contains(" or ") || parameter.contains(" and ") || parameter.contains("--") || parameter.contains("'")) {
                JsonMsg msg = new JsonMsg();
                msg.setSuccess(false);
                msg.setMsg("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
                response.setStatus(403);
                return msg;
            }
            maps.put(paraName, parameter);
        }
        model.addAttribute("params", maps);
        model.addAttribute("showTitle", (Object)showTitle);
        if ("2".equals(entity.getReport().getReportType())) {
            return "/report/reportChart";
        }
        return "/report/report";
    }

    @RequestMapping(value={"/saveReportBase"})
    @ResponseBody
    public Object saveReportBase(HttpServletRequest request, ReportBase entity, String rows, HttpServletResponse response) {
        JsonMsg msg = new JsonMsg();
        String sql = entity.getSqlScript();
        if (sql.contains("delete ") || sql.contains("update ") || sql.contains("truncate ") || sql.contains("drop ") || sql.contains("create ") || sql.contains("alter ") || sql.contains("insert ") || sql.contains("DELETE ") || sql.contains("UPDATE ") || sql.contains("TRUNCATE ") || sql.contains("DROP ") || sql.contains("CREATE ") || sql.contains("ALTER ") || sql.contains("INSERT ")) {
            msg.setSuccess(false);
            msg.setMsg("sql\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
            response.setStatus(403);
            return msg;
        }
        if (entity.getId() == null) {
            entity.setCreateBy(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.reportbaseService.saveReportBase(entity, rows);
        return msg;
    }

    @RequestMapping(value={"/delReportBase"})
    @ResponseBody
    public Object delReportBase(Long id) {
        this.reportbaseService.delReportBase(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/copyReportBase"})
    @ResponseBody
    public Object copyReportBase(Long id) throws IllegalAccessException, InvocationTargetException {
        this.reportbaseService.copyReportBase(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/editReportBase"})
    public Object editReportBase(Long id, Model model) {
        ReportBase entity = this.reportbaseService.findReportBase(id);
        model.addAttribute("report", (Object)entity);
        if ("2".equals(entity.getReportType())) {
            return "/report/ReportBaseDs";
        }
        return "/report/ReportBaseTemp";
    }

    @RequestMapping(value={"/pageReportBas"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageReportBas(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, boolean isContainUrl, boolean isContainColum) {
        return this.reportbaseService.pageReportBas(search, page, rows);
    }

    @RequestMapping(value={"/exportReportBasXml"})
    public void exportReportBasXml(String ids, HttpServletResponse response) {
        this.reportbaseService.exportReportBasXml(ids, response);
    }

    @RequestMapping(value={"/importReportBas"})
    @ResponseBody
    public Object importReportBas(MultipartHttpServletRequest multiRequest) throws Throwable {
        Iterator iter = multiRequest.getFileNames();
        JsonMsg msg = new JsonMsg();
        while (iter.hasNext()) {
            MultipartFile file = multiRequest.getFile((String)iter.next());
            try {
                InputStream inputStream = file.getInputStream();
                Throwable var6 = null;
                try {
                    InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                    int ch = 0;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        stringBuffer.append((char)ch);
                    }
                    ((Reader)reader).close();
                    String jsonString = stringBuffer.toString();
                    msg = this.reportbaseService.importReportBas(jsonString);
                }
                catch (Throwable var19) {
                    var6 = var19;
                    throw var19;
                }
                finally {
                    if (inputStream == null) continue;
                    if (var6 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable var18) {
                            var6.addSuppressed(var18);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception var21) {
                msg = new JsonMsg(false, "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25");
            }
        }
        return msg;
    }
}

