/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubCoordinateSystemDao;
import com.guochuang.imp.pub.entity.PubCoordinateSystem;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubCoordinateSystemService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubCoordinateSystemDao pubcoordinatesystemDao;

    public PubCoordinateSystem findPubCoordinateSystem(Long id) {
        PubCoordinateSystem entity = (PubCoordinateSystem)this.pubcoordinatesystemDao.findById(id).get();
        return entity;
    }

    public List<Map<String, Object>> findByForeignId(Long id, String formcode) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", id);
        params.put("formcode", formcode);
        return this.bSqlHelper.getMapList("pub.PubCoordinateSystem.select", params);
    }

    public void savePubCoordinateSystem(PubCoordinateSystem entity) {
        this.pubcoordinatesystemDao.save(entity);
    }

    public void delPubCoordinateSystem(Long id) {
        PubCoordinateSystem entity = (PubCoordinateSystem)this.pubcoordinatesystemDao.findById(id).get();
        entity.setIsUse("N");
        this.pubcoordinatesystemDao.save(entity);
    }

    public void delPubCoordinateSystemList(Long id) {
        List<PubCoordinateSystem> coordinateSystems = this.pubcoordinatesystemDao.findByBizMainIdAndIsUse(id, "Y");
        if (coordinateSystems.size() > 0 && coordinateSystems != null) {
            for (PubCoordinateSystem coordinateSystem : coordinateSystems) {
                coordinateSystem.setIsUse("N");
                coordinateSystem.setModifyTime(new Date());
                this.pubcoordinatesystemDao.save(coordinateSystem);
            }
        }
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and " + SysUtils.genFlowDoneStatusSQL("t.workflow_status", flowDone) + " \n");
        }
        return this.bSqlHelper.serachPage("pub.PubCoordinateSystem.select", params, PageRequest.of((int)page, (int)rows));
    }
}

