/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import cn.hutool.core.map.MapUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.Pinyin4jUtil;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.doc.entity.FormFileBean;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubContactDao;
import com.guochuang.imp.pub.dao.PubContactOrgAccountDao;
import com.guochuang.imp.pub.dao.PubContactOrgDao;
import com.guochuang.imp.pub.dao.PubContactOrgTypeDao;
import com.guochuang.imp.pub.entity.PubContact;
import com.guochuang.imp.pub.entity.PubContactOrg;
import com.guochuang.imp.pub.entity.PubContactOrgAccount;
import com.guochuang.imp.pub.entity.PubContactOrgMiddle;
import com.guochuang.imp.pub.entity.PubContactOrgType;
import com.guochuang.imp.pub.service.PubContactOrgTypeService;
import com.guochuang.imp.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@Transactional
public class PubContactOrgService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private PubContactOrgDao pubcontactorgDao;
    @Autowired
    private PubContactOrgTypeDao pubcontactorgtypeDao;
    @Autowired
    private PubContactOrgTypeService pubContactOrgTypeService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private PubContactOrgAccountDao pubContactOrgAccountDao;
    @Autowired
    private PubContactDao pubContactDao;
    @Autowired
    private BasMessageService msgService;

    public PubContactOrg findPubContactOrg(Long id) {
        Optional opt = this.pubcontactorgDao.findById(id);
        if (opt.isPresent()) {
            PubContactOrg entity = (PubContactOrg)opt.get();
            return entity;
        }
        return null;
    }

    public void savePubContactOrg(PubContactOrg entity) {
        this.pubcontactorgDao.save(entity);
    }

    public String queryContactOrgNameByIds(String contactOrgIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgIds", contactOrgIds);
        return this.bSqlHelper.getStringValue("pub.PubContactOrg.searchMulti", params);
    }

    public PubContactOrg savePubContactOrg(PubContactOrg entity, FormFileBean formfile) {
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        String pinyin = Pinyin4jUtil.getPinyinJianPin(entity.getContactOrgName());
        if (pinyin.length() > 1000) {
            pinyin = pinyin.substring(0, 1000);
        }
        entity.setToNamePinyin(pinyin);
        this.pubcontactorgDao.save(entity);
        if (entity.getDataPCOAList() != null) {
            for (PubContactOrgAccount oa : entity.getDataPCOAList()) {
                if (StringUtils.isEmpty((Object)oa.getContactOrgId())) {
                    oa.setContactOrgId(entity.getContactOrgId());
                }
                if (StringUtils.isEmpty((Object)oa.getIsUse())) {
                    oa.setStatus("2");
                    oa.setIsUse("Y");
                }
                if (oa.getWorkflowStatus() == null) {
                    oa.setWorkflowStatus(SysContent.PASS_STATUS);
                }
                this.pubContactOrgAccountDao.save(oa);
            }
        }
        if (entity.getDataContactList() != null) {
            for (PubContact contact : entity.getDataContactList()) {
                if (StringUtils.isEmpty((Object)contact.getContactOrgId())) {
                    contact.setContactOrgId(entity.getContactOrgId());
                }
                if (StringUtils.isEmpty((Object)contact.getIsUse())) {
                    contact.setIsUse("Y");
                }
                this.pubContactDao.save(contact);
            }
        }
        formfile.setPrimaryKey(entity.getContactOrgId());
        formfile.setAccountid(entity.getModifyAccount());
        this.docFormFileService.SaveFormFileBean(formfile);
        return entity;
    }

    public void delPubContactOrg(Long id) {
        PubContactOrg entity = (PubContactOrg)this.pubcontactorgDao.findById(id).get();
        entity.setIsUse("N");
        this.pubcontactorgDao.save(entity);
        List<PubContact> contacts = this.pubContactDao.findByContactOrgIdAndIsUse(id, "Y");
        if (contacts != null && contacts.size() > 0) {
            for (PubContact contact : contacts) {
                contact.setIsUse("N");
                this.pubContactDao.save(contact);
            }
        }
        List<PubContactOrgAccount> accounts = this.pubContactOrgAccountDao.findByContactOrgIdAndIsUse(id, "Y");
        for (PubContactOrgAccount acccount : accounts) {
            acccount.setIsUse("N");
            this.pubContactOrgAccountDao.save(acccount);
        }
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public List<Map<String, Object>> findListByContactOrgId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgId", id);
        return this.bSqlHelper.getMapList("business.pm.PubContactOrgAccount.select", params);
    }

    public List<Map<String, Object>> findByContactOrgId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgId", id);
        return this.bSqlHelper.getMapList("pub.PubContactOrgAccount.selectWin", params);
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order, Long contactOrgTypeId, String type, String contactType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)type)) {
            params.put("type", type);
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((Object)contactType)) {
            params.put("contactType", "%" + contactType.toUpperCase() + "%");
        }
        if (flowDone != null) {
            params.put("flowsql", " and " + SysUtils.genFlowDoneStatusSQL("t.workflow_status", flowDone) + " \n");
        } else {
            params.put("flowsql", " and t.workflow_status='3' \n");
        }
        params.put("contactOrgTypeId", contactOrgTypeId);
        PageObject<Map<String, Object>> mapPageObject = this.bSqlHelper.serachPage("pub.PubContactOrg.select", params, PageRequest.of((int)page, (int)rows));
        if (mapPageObject != null && mapPageObject.getRows() != null) {
            for (Map<String, Object> row : mapPageObject.getRows()) {
                row.put("typeText", MemCache.getDicText("REV_PAY_UNIT_TYPE", row.get("type") == null ? "" : row.get("type").toString()));
            }
        }
        return mapPageObject;
    }

    public PubContactOrg findByProcessinstid(long processinstid) {
        return this.pubcontactorgDao.findByProcessinstid(processinstid);
    }

    public JsonMsg checkrepeat(PubContactOrg entity) {
        JsonMsg msg = new JsonMsg();
        PubContactOrgType type = this.pubContactOrgTypeService.findPubContactOrgType(entity.getContactOrgTypeId());
        if ("1".equals(type.getType())) {
            if (entity.getContactOrgName().length() > 4 && StrKit.notBlank(entity.getContactOrgName()) && this.hasrepeatOrgName(entity.getContactOrgName(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u5355\u4f4d\u540d\u79f0/\u59d3\u540d\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
            if (StrKit.notBlank(entity.getContactOrgCode()) && this.hasrepeatOrgCode(entity.getContactOrgCode(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u7edf\u4e00\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
        } else if ("2".equals(type.getType())) {
            if (entity.getContactOrgName().length() > 4 && StrKit.notBlank(entity.getContactOrgName()) && this.hasrepeatOrgName(entity.getContactOrgName(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u5355\u4f4d\u540d\u79f0/\u59d3\u540d\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
            if (StrKit.notBlank(entity.getContactOrgCode()) && this.hasrepeatOrgCode(entity.getContactOrgCode(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u7edf\u4e00\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
        }
        return msg;
    }

    public JsonMsg checkContactOrgData(String orgName, String contactOrgCode, String type, Long contactOrgId) {
        JsonMsg msg = new JsonMsg();
        if ("1".equals(type)) {
            if (this.hasrepeatOrgName(orgName, contactOrgId, type) && orgName.length() <= 4) {
                msg.setSuccess(false);
                msg.setMsg("\u5df2\u5b58\u5728\u5355\u4f4d\u540d\u79f0/\u59d3\u540d,\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?");
                return msg;
            }
        } else if ("2".equals(type) && this.hasrepeatOrgName(orgName, contactOrgId, type) && orgName.length() <= 4) {
            msg.setSuccess(false);
            msg.setMsg("\u5df2\u5b58\u5728\u5355\u4f4d\u540d\u79f0/\u59d3\u540d,\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?");
            return msg;
        }
        return msg;
    }

    public boolean hasrepeatOrgName(String orgname, Long contactorgid, String type) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from PUB_CONTACT_ORG t where replace(replace(trim(t.contact_org_name), '\uff08', '('), '\uff09', ')') =");
        sql.append(" replace(replace(?1, '\uff08', '('), '\uff09', ')') and t.is_use='Y' ");
        if (contactorgid != null && contactorgid != 0L) {
            sql.append(" and t.contact_org_id <> " + contactorgid);
        }
        if (StrKit.notBlank(type)) {
            sql.append(" and t.type = " + type);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{orgname.trim()})).toString()) > 0L;
    }

    public boolean hasrepeatOrgCode(String orgcode, Long contactorgid, String type) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from PUB_CONTACT_ORG t where  trim(t.contact_org_code)= ?1 and t.is_use='Y' ");
        if (contactorgid != null && contactorgid != 0L) {
            sql.append(" and t.contact_org_id <> " + contactorgid);
        }
        if (StrKit.notBlank(type)) {
            sql.append(" and t.type = " + type);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{orgcode.trim()})).toString()) > 0L;
    }

    public boolean hasrepeatIdCard(String idcard, Long contactorgid) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from PUB_CONTACT_ORG t where  (trim(t.id_card)= ?1 or trim(t.contact_org_code)=?1) and t.is_use='Y' ");
        if (contactorgid != null && contactorgid != 0L) {
            sql.append(" and t.contact_org_id <> " + contactorgid);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{idcard.trim()})).toString()) > 0L;
    }

    public void back(Long processinstid) {
        PubContactOrg o = this.findByProcessinstid(processinstid);
        o.setModifyTime(new Date());
        o.setWorkflowStatus(SysContent.BACK_STATUS);
        this.pubcontactorgDao.save(o);
    }

    public PageObject PageAllSelWin(String type, String pubContactOrgIds, String search, int page, int rows, String sort, String order, Long contactOrgTypeId, Long contactOrgTypeCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StrKit.notBlank(pubContactOrgIds)) {
            params.put("pubContactOrgIds", pubContactOrgIds);
        }
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        params.put("type", type);
        params.put("contactOrgTypeId", contactOrgTypeId);
        params.put("contactOrgTypeCode", contactOrgTypeCode);
        return this.bSqlHelper.serachPage("pub.PubContactOrg.selectWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject pagePubContactBlockSelWin(String contactOrgTypeId, String type, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((Object)contactOrgTypeId)) {
            params.put("contactOrgTypeId", contactOrgTypeId);
        }
        params.put("type", type);
        return this.bSqlHelper.serachPage("pub.PubContactOrg.selectBlockWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PubContactOrgType findPubContactOrgTypeByPubContactOrgId(Long contactOrgId) {
        PubContactOrg pubContactOrg = (PubContactOrg)this.pubcontactorgDao.findById(contactOrgId).get();
        PubContactOrgType pubContactOrgType = (PubContactOrgType)this.pubcontactorgtypeDao.findById(pubContactOrg.getContactOrgTypeId()).get();
        return pubContactOrgType;
    }

    public PubContactOrg findByContactOrgIdZcAndIsUse(String id) {
        List<PubContactOrg> pubContactOrg = this.pubcontactorgDao.findByContactOrgIdZcAndIsUse(id, "Y");
        if (pubContactOrg == null || pubContactOrg.size() == 0) {
            return null;
        }
        return pubContactOrg.get(0);
    }

    public Map<String, Object> getMatchType(String code, String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<PubContactOrg> list1 = this.pubcontactorgDao.findByContactOrgCodeAndContactOrgNameAndIsUse(code, name, "Y");
        if (!list1.isEmpty()) {
            map.put("type", "1");
            map.put("entity", list1.get(0));
            return map;
        }
        List<PubContactOrg> list2 = this.pubcontactorgDao.findByContactOrgCodeAndIsUse(code, "Y");
        if (!list2.isEmpty()) {
            map.put("type", "2");
            map.put("entity", list2.get(0));
            return map;
        }
        List<PubContactOrg> list3 = this.pubcontactorgDao.findByContactOrgNameAndIsUse(code, "Y");
        if (!list2.isEmpty()) {
            map.put("type", "3");
            map.put("entity", list3.get(0));
            return map;
        }
        map.put("type", "0");
        map.put("entity", null);
        return map;
    }

    public String copyPropertiesWithChangeLog(PubContactOrgMiddle source, PubContactOrg target) {
        String newIsUse;
        String newContactCertType;
        String oldContactCertType;
        String newContactOrgNature;
        String oldContactOrgNature;
        String newContactOrgCode;
        String oldContactOrgCode;
        String newContactOrgName;
        StringBuilder changedFields = new StringBuilder();
        String oldContactOrgName = target.getContactOrgName();
        if (!org.apache.commons.lang.StringUtils.equals((String)oldContactOrgName, (String)(newContactOrgName = source.getContactOrgName()))) {
            target.setContactOrgName(newContactOrgName);
            changedFields.append("\u5ba2\u5546\u540d\u79f0(\u539f:").append(StringUtil.null2String(oldContactOrgName)).append(",\u65b0:").append(StringUtil.null2String(newContactOrgName)).append(");");
        }
        if (!org.apache.commons.lang.StringUtils.equals((String)(oldContactOrgCode = target.getContactOrgCode()), (String)(newContactOrgCode = source.getContactOrgCode()))) {
            target.setContactOrgCode(newContactOrgCode);
            changedFields.append("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7(\u539f:").append(StringUtil.null2String(oldContactOrgCode)).append(",\u65b0:").append(StringUtil.null2String(newContactOrgCode)).append(");");
        }
        if (!org.apache.commons.lang.StringUtils.equals((String)(oldContactOrgNature = target.getContactOrgNature()), (String)(newContactOrgNature = source.getContactOrgNature()))) {
            target.setContactOrgNature(newContactOrgNature);
            changedFields.append("\u5ba2\u5546\u6027\u8d28(\u539f:").append(StringUtil.null2String(oldContactOrgNature)).append(",\u65b0:").append(StringUtil.null2String(newContactOrgNature)).append(");");
        }
        if (!org.apache.commons.lang.StringUtils.equals((String)(oldContactCertType = target.getContactCertType()), (String)(newContactCertType = source.getContactCertType()))) {
            target.setContactCertType(newContactCertType);
            changedFields.append("\u8bc1\u4ef6\u7c7b\u578b(\u539f:").append(StringUtil.null2String(oldContactCertType)).append(",\u65b0:").append(StringUtil.null2String(newContactCertType)).append(");");
        }
        String oldType = target.getType();
        String newType = source.getType();
        if ("1".equals(oldType)) {
            target.setType(oldType + "," + newType);
            changedFields.append("\u5ba2\u5546\u7c7b\u578b(\u539f:").append(StringUtil.null2String(oldType)).append(",\u65b0:").append(StringUtil.null2String(target.getType())).append(");");
        }
        if ("N".equals(newIsUse = source.getIsUse())) {
            target.setContactOrgIdZc(null);
            changedFields.append("contactOrgIdZc\u8bbe\u7f6e\u4e3anull");
        } else {
            String newContactOrgIdZc;
            String oldContactOrgIdZc = target.getContactOrgIdZc();
            if (!org.apache.commons.lang.StringUtils.equals((String)oldContactOrgIdZc, (String)(newContactOrgIdZc = source.getContactOrgIdZc()))) {
                target.setContactOrgIdZc(newContactOrgIdZc);
                changedFields.append("contactOrgIdZc(\u539f:").append(StringUtil.null2String(oldContactOrgIdZc)).append(",\u65b0:").append(StringUtil.null2String(newContactOrgIdZc)).append(");");
            }
        }
        if (changedFields.length() > 0) {
            changedFields.deleteCharAt(changedFields.length() - 1);
        }
        if (changedFields.length() == 0) {
            changedFields.append("\u65e0\u4fee\u6539");
        }
        return changedFields.toString();
    }

    public PageObject getContractOrgByCon(String currentLat, String currentLng, String distance, String type, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((Object)type)) {
            params.put("type", type);
        }
        if (!StringUtils.isEmpty((Object)currentLat)) {
            params.put("currentLat", currentLat);
        }
        if (!StringUtils.isEmpty((Object)currentLng)) {
            params.put("currentLng", currentLng);
        }
        if (!StringUtils.isEmpty((Object)distance)) {
            params.put("distance", distance);
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrg.getContractOrgByCon", params, PageRequest.of((int)page, (int)rows));
    }

    public String getOtherPartsText(String ids) {
        if (ids != null) {
            String[] contactOrgIds;
            String otherPartsText = "";
            for (String contactOrgId : contactOrgIds = ids.split(",")) {
                String contactOrgName = this.findPubContactOrg(Long.parseLong(contactOrgId)).getContactOrgName();
                otherPartsText = otherPartsText + contactOrgName + ",";
            }
            return otherPartsText.substring(0, otherPartsText.length() - 1);
        }
        return null;
    }

    public Map<String, Object> findContactOrgAndType(String contactOrgId, String orgBankAccount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isEmpty(contactOrgId) || StringUtil.isEmpty(orgBankAccount)) {
            return null;
        }
        params.put("contactOrgId", contactOrgId);
        params.put("orgBankAccount", orgBankAccount);
        return this.bSqlHelper.getMap("pub.PubContactOrg.findContactOrgAndType", params);
    }

    public void enableOrgAccount(Long processinstid) {
        List<PubContactOrgAccount> accounts = this.bSqlHelper.getList("pub.PubContactOrg.findOrgAccounts", MapUtil.of((Object)"processinstid", (Object)processinstid), PubContactOrgAccount.class);
        if (accounts == null || accounts.size() == 0) {
            return;
        }
        for (PubContactOrgAccount oa : accounts) {
            oa.setStatus("1");
        }
        this.pubContactOrgAccountDao.saveAll(accounts);
    }

    public Long getContactOrgIdByContactOrgIdZc(String contactOrgIdZc) {
        List<PubContactOrg> pubContactOrg = this.pubcontactorgDao.findByContactOrgIdZcAndIsUse(contactOrgIdZc, "Y");
        if (pubContactOrg != null) {
            return pubContactOrg.get(0).getContactOrgId();
        }
        return null;
    }
}

